/*
 **************************************************************************
 *
 * Boot-ROM-Code to load an operating system across a TCP/IP network.
 *
 * Module:  main.c
 * Purpose: Call all initialization routines and then start boot process
 * Entries: main
 *
 **************************************************************************
 *
 * Copyright (C) 1995,1996 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "../public/minidos.h"
#include "../public/net.h"
#include "../public/arpa.h"
#include "../public/boot.h"
#include "../public/romlib.h"
#include "../../headers/general.h"
#include "../../headers/version.h"


/*
 **************************************************************************
 * 
 * Main routine: call all the initialization routines, and then start
 * the net boot process
 *
 */
void kernelmain(progadr, dataend)
void far *progadr;
void far *dataend;
{

  /* Initialize all modules */
  init_minidos(progadr, dataend);
  init_net();
  init_arpa();

  /* Print some messages */
  printf("\nFree memory: %d\n\n\nBoot-Rom V%d.%d, (C) G. Kuhlmann\n\n",
					memavail(), MAJOR_VER, MINOR_VER);

  /* Now actually load the operating system */
  do_boot();
}
