;**************************************************************************
;*
;* Boot-ROM-Code to load an operating system across a TCP/IP network.
;*
;* Module:  misc.asm
;* Purpose: Routines for different things
;* Entries: _random, _far2long, _fatal, prnstr, prnword, prnbyte
;*
;**************************************************************************
;*
;* Copyright (C) 1995,1996 Gero Kuhlmann <gero@gkminix.han.de>
;*
;*  This program is free software; you can redistribute it and/or modify
;*  it under the terms of the GNU General Public License as published by
;*  the Free Software Foundation; either version 2 of the License, or
;*  any later version.
;*
;*  This program is distributed in the hope that it will be useful,
;*  but WITHOUT ANY WARRANTY; without even the implied warranty of
;*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;*  GNU General Public License for more details.
;*
;*  You should have received a copy of the GNU General Public License
;*  along with this program; if not, write to the Free Software
;*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;*


;
;**************************************************************************
;
; Include assembler macros:
;
include ..\..\headers\asm\macros.inc
include ..\..\headers\asm\layout.inc
include ..\..\headers\asm\memory.inc
include .\libpriv.inc


;
;**************************************************************************
;
; Definitions for the random number generator:
;
RANDLOW		equ	4E35h		; Low multiplication value
RANDHIGH	equ	015Ah		; High multiplication value
RANDMUL		equ	015A4E35h	; everything together for 386
RANDADD		equ	23968


;
;**************************************************************************
;
; Define BIOS entry point for rebooting the system.
;
% reboot	segment	seguse at 0FFFFh

	org	0
doboot	label	far

reboot		ends


;
;**************************************************************************
;
; BSS segment:
;
bss_start

rseed		dd	?		; seed for random number

bss_end


;
;**************************************************************************
;
; Start code segment.
;
text_start

	public	_random			; define entry points
	public	_far2long
	public	_fatal
	public	prnstr
	public	prnword
	public	prnbyte

	extrn	_get_ticks:near


;
;**************************************************************************
;
; Return a short integer random number
; Input:  none
; Output: random number
;
_random		proc	near

ifdef IS386
	mov	eax,rseed		; check if the seed has already been
	or	eax,eax			; set
else
	mov	dx,word ptr [rseed+0]
	mov	ax,dx			; check if the seed has already been
	or	dx,word ptr [rseed+2]	; set
endif
	jnz	short rand1
	call	_get_ticks		; if not set it by reading the timer
	xchg	ah,dl			; tick count
	xchg	ah,dh			; mix the values a little bit
	xchg	ah,al
	mov 	word ptr [rseed+0],ax
	mov	word ptr [rseed+2],dx

rand1:
ifdef IS386
	mov	eax,RANDMUL		; multiply the seed with a magic number
	mul	rseed
	add	eax,RANDADD		; add another magic number
	mov	rseed,eax		; save new seed
	and	eax,7FFFh		; prepare return value
else
	mov	dx,RANDHIGH
	mul	dx			; multiply the seed with a magic number
	mov	bx,ax
	mov	ax,RANDLOW
	mul	word ptr [rseed+0]
	mov	cx,ax
	add	bx,dx
	mov	ax,RANDLOW
	mul	word ptr [rseed+2]
	add	bx,ax
	add	cx,RANDADD		; add another magic number
	adc	bx,0
	mov	word ptr [rseed+0],cx	; save new seed number
	mov	word ptr [rseed+2],bx
	mov	ax,bx			; prepare return value
	and	ax,7FFFh		; make it a signed short integer
endif
	ret

_random		endp


;
;**************************************************************************
;
; Convert far pointer into linear long number
; Input:  1. Arg  -  far pointer
; Output: linear address
;
_far2long	proc	near

	penter
	getarg	dx,1			; get far pointer
	getarg	ax,0
	mov	bx,dx
	shift	shr,dx,12		; convert into linear address
	shift	shl,bx,4
	add	ax,bx
	adc	dx,0
	pleave
	ret

_far2long	endp


;
;**************************************************************************
;
; Handle fatal errors
; Input:  none
; Output: none
;
_fatal		proc	near

	mov	bx,offset cgroup:fatmsg
	call	prnstr			; print startup message
	xor	ax,ax
	int	16h			; wait for key press

	cli
	xor	ax,ax
	mov	ds,ax
	mov	ds:[0472h],1234h	; indicates warm boot
	jmp	doboot			; reboot the system

; Error messages

fatmsg	db	0Dh,0Ah,0Dh,0Ah
	db	'Press a key to reboot...'
	db	0

_fatal		endp


;
;**************************************************************************
;
; Print a string onto the console screen.
; Input:  CS:BX  -  pointer to zero terminated string
; Output: none
; Registers changed: AX, BX
;
prnstr		proc	near

prnst1:	mov	al,cs:[bx]
	or	al,al			; end of string
	jz	short prnst2
	call	prnchar			; print character
	inc	bx			; proceed with next character
	jmp	short prnst1
prnst2:	ret

prnstr		endp


;
;**************************************************************************
;
; Print a word/byte/nibble onto the console screen
; Input:  AX  -  value
; Output: none
; Registers changed: AX
;
prnword		proc	near

	push	ax
	mov	al,ah
	call	prnbyte			; print high word
	pop	ax			; print low word

prnbyte		label	near

	push	ax
ifdef IS186
	shr	al,4
else
	shr	al,1
	shr	al,1			; print high nibble
	shr	al,1
	shr	al,1
endif
	call	prnnibble
	pop	ax			; print low nibble

prnnibble	label	near

	and	al,0Fh
	add	al,'0'			; convert into ASCII character
	cmp	al,'9'
	jbe	short prnchar
	add	al,7

prnchar		label	near

	push	bx
	mov	ah,0Eh			; don't use int 29h here, because this
	xor	bh,bh			; routine might be called before int 29h
	int	10h			; has been setup. use the BIOS directly.
	pop	bx
	ret

prnword		endp


;
;**************************************************************************
;
text_end

	end

