.TH KNEWS 1 "1996"
.SH NAME
knews \- Karl's threaded newsreader for X
.SH SYNOPSIS
.B knews
[ options ]
.SH DESCRIPTION
Knews is a threaded newsreader with an X Window interface that uses
NNTP to get news. This manual is intended to explain things that are not
apparent from the interface, so if you just want to get started, you
probably don't need to read this.
.SH OPTIONS
In addition to the standard X Toolkit options knews accepts the
following options, which set various X resources.  For an explanation
of what the resources do, see the sections on resources and the
config file.

You don't have to type out the entire name of the option, as long
as it is unique.

.B -nntpServer hostname
.RS
Sets the resource 'Knews.nntpServer' to 'hostname'.  This will cause
knews to connect to this server on startup.
.RE

.B +/-bell
.RS
Sets the resource 'Knews.bell' to True/False.
.RE

.B +/-separate
.RS
Sets the resource 'Knews.separateWindows' to True/False.
.RE

.B +/-active
.RS
Sets the resource 'Knews.readActiveFile' to True/False.
.RE

.B +/-descriptions
.RS
Sets the resource 'Knews.retrieveDescriptions' to True/False.
.RE

.B +/-fill
.RS
Sets the resource 'Knews.fillNewsrcFile' to True/False.
.RE

.B +/-keep
.RS
Sets the resource 'Knews.keepThreadInfo' to True/False.
.RE

.B -install
.RS
This will make knews install its own colormap.
.RE

.nf
.B -visual class
.B -depth bits
.fi
.RS
These will set the resources 'Knews.visualClass' and 'Knews.visualDepth'.
.RE

.B +/-icase
.RS
Will set the resource 'Knews.icaseRegexps' to True/False.
.RE

.B +/-images
.RS
This will turn on/off inline images and color allocation.
.RE

.B -ncols number
.RS
Sets the resource Knews.nCols to 'number', which is the max number
of colors knews will allocate for inline images.
.RE

.B -version
.RS
Prints out the version and compile time to stderr and quits.
.RE

.SH "THE THREAD TREE"
The articles in a thread are displayed as nodes in a tree. A border inside
a node indicates that the article is unread, a border outside a node
indicates that the article is 'tagged', and a dashed branch in the tree
indicates a change of subject. By default, you can scroll around in the
tree with the middle mouse button. An empty box in the tree indicates
a 'fake' article, i.e. one that has expired on the server, has not yet
arrived or was posted in a different newsgroup.

.SH "TAGGING ARTICLES"
Articles in the thread tree can be tagged with the third mouse button.
Clicking on a subject with the third mouse button causes the unread articles
in that thread to be tagged in preorder (depth first). Once you have
tagged the articles, you can mark then read/unread, save or pipe them in
order, and so on.

.SH "CLICKING ON URLS"
Knews supports a simple form of clicking on URLs.  It works by
selecting a piece of text in the article text window and clicking
on it with the middle mouse button.  If there is no selection,
knews will make a crude guess as to what the URL might be.  The
resource Knews.urlCommand must be set for this to work, see the
section on X resources for details.

.SH "DRAG AND DROP"
The all groups list and the kill list can be reordered by drag'n'drop.
The default translation is the second mouse button.

.SH ABORT
You may abort the interaction with the NNTP server at any time. This
causes the connection to be closed, and a new one to be opened. Note
that this puts a certain load on the server.

.SH "THREAD AHEAD"
Knews is capable of threading groups in the background while you are
e.g. reading another group.  To do this you click on one or more groups
in the group list with the right mouse button.  Knews then opens a second
connection to the server and uses it to thread the selected groups.  The
status of the thread ahead is shown in the group list as a character:

.nf
-       The group is scheduled for thread ahead.
*       The group is being threaded.
+       The group has been threaded.
.fi

.SH "REGULAR EXPRESSIONS"
The regular expressions used by knews are POSIX.2 extended regular
expressions, similar to those used by egrep(1), by default
case insensitive.  Note that these are not anchored by default,
so that e.g. the expression 'alt' will match any string containing
the three character sequence 'alt'.  See Henry Spencer's excellent
man-page for details, regex(7).

.SH SEARCHING
Article heads and bodies may be searched for regular expressions.
Searching applies to read or unread articles as specified with
the 'only unread' toggle, and starts with the 'next' article.
The newsgroup list may also be searched.

Note: the 'Stop' button stops the search as soon as the current
article has been retrieved from the server.  This is different
from 'Abort' which requires closing and reopening the connection
to the server.

It is also possible to use XPAT searching, if the nntp server supports
it.  To do this, you fill in the 'Header' field on the search popup
with the header you're interested in (e.g. 'Content-Type') and the
wildcard field with a wildcard expression.  Pressing 'Submit' then
sends this to the server, and after a while it responds with a list
of matching articles.  You can then move between those articles with
the 'Next' and 'First' buttons on the search popup.

.SH "FILE NAME EXPANSION"
In most places where knews uses file names, such as the save/pipe popup,
the save/pipe action procedures, and the newsrcFile options etc, ~ is
expanded to $HOME, and the following %'s are expanded:

.nf
%%      %
%n      The name of the current group.
%N      The name of the current group, capitalized.
%g      The name of the current group, slashed.
%G      The name of the current group, capitalized and slashed.
%s      The name of the nntp server.
%p      The number of the port the server listens to.
%a      The number of the currently selected article.
.fi

Slashed means that the dots are replaced with slashes.  Note that
if you save an entire thread to a file continaing %a, the number
will not change with the article.

.SH "THE KILL FILE"
The kill file may be used to 'kill' (mark read) or 'hot' (mark interesting)
articles, subjects and threads based on different criteria.

Each line in the kill file specifies an entry according to the following
syntax:

.nf
(F)(S)(A)[Col] || Group regexp || Field expression
.fi

.B (F)
.RS
This is a character specifying to which header this entry applies.
Legal values are:

.nf
\'M'     The 'Message-ID:' header, by far the most efficient.
\'S'     The 'Subject:' header.
\'F'     The 'From:' header.
\'X'     The 'Xref:' header.
.fi

Note that 'X' only works if the 'Xref:' header is included in the
overview files from the server. Also note that the 'Re: ' prefix
is not considered part of the subject.

Entries applying to a message-id automatically expire when the
relevant article has expired.
.RE

.B (S)
.RS
This is a character specifying the scope of the entry, i.e. what articles
are killed/'hotted' when this entry applies to an article. Legal values
are:

.nf
\'A'     This article.
\'S'     All articles with the same subject.
\'T'     The entire thread.
\'t'     The subthread starting with this article.
.fi
.RE

.B (A)
.RS
This is a character specifying the action of the entry.  Legal values are:

.nf
\'K'     Kill, which means mark read.
\'H'     Hot, which means mark interesting.
.fi
.RE

.B [col]
.RS
In 'hot' entries, this is the color used to mark the relevant
articles with.
.RE

.B ||
.RS
This two character sequence is used as a separator.
.RE

.B Group regexp
.RS
Only newsgroups matching this regular expression will be
affected by this entry.  This field is empty in the per-group
kill files.
.RE

.B Field expression
.RS
If the header field is 'S', 'F' or 'X', this is a regular expression,
and the entry applies to all matching articles. If the header field
is 'M', this is a message id; this id is probably the fastest type of
kill entry, since it can be checked with a single hash lookup.
.RE

To see what articles were killed: when you have read all unread articles,
or marked them read, use the 'mark unread, killed' feature on the
misc menu.

When a kill rule is applied, hot articles are not killed.  Since the
entries in the kill file are processed in order, it is possible to
put kills at the beginning, so that the articles are killed before
they have a chance to become hot.

There is one global kill file (~/.knews/.kill-%s by default) and one
kill file per group (~/.knews/%s/%g/KILL by default).  The rules in
the global kill file are applied before the per-group kill file.

.SH "MIME VIEWERS AND MAILCAP FILES"

Knews has internal support for content-types text/plain, message/rfc822,
message/partial, multipart/mixed and multipart/digest.  For other types,
knews will look for a mailcap entry for that type (see mailcap(5)).  If
one is found, a clickable line will be inserted in the article text
window that is used to start the viewer.  If there is no viewer,
then if the type is a subtype of text, knews will display it, if it
is a subtype of multipart, knews will treat it as multipart/mixed,
and otherwise knews will give the user opportunity to 'Save or Pipe'.

Mailcap files are found via the environment variable MAILCAPS,
which is a colon separated list of path names.  If this variable
is not set, a default list of

.nf
$HOME/.mailcap:/etc/mailcap:/usr/etc/mailcap:/usr/local/etc/mailcap
.fi

will be used.  Note that all files found will be merged to produce
the mailcap database.

As a hack around miss/over designed mailcap files, knews will ignore
entries for text/plain and multipart/mixed.

.SH "TEXT/PLAIN ARTICLES"

The following resources determine how knews will display an article
of type text/plain with a particular charset:

.nf
Knews.charset.headerFont
Knews.charset.bodyFont
Knews.charset.quoteFont
Knews.charset.listFont
Knews.charset.treeFont
Knews.charset.encoding
Knews.charset.headEncHack
.fi

The header, body and quote fonts are used for displaying headers,
ordinary text and quoted text in the article window.  Knews also
has some support for encoded 16-bit charsets, this is specified
with the encoding resource.  Legal values for this are:

.nf
utf-7       The encoding specified for unicode in rfc 1642.
16-bit      Straight 16-bit network byte order.
hz-gb-2312  The encoding for chinese described in rfc 1842.
ksc-5601    Also called iso-2022-kr, described in rfc 1557.
big5        Another encoding for chinese.
.fi

Note that due to the authors non-existent understanding of asian
languages these encodings have not been extensively tested.
Lots of guess work here.

For every newsgroup it is possible to specify a default charset (see
the section on THE CONFIG FILE).  The fonts for this charset will be
used to display articles without proper MIME-headers.  Also, the
listFont and treeFont (which may not be encoded) will be used in the
thread list and article tree, respectively.

When specifying an encoded charset as defaultCharset, it may
be desirable to still assume that headers are ascii.  This may
be accomplished by setting the 'headEncHack' resource listed
above, and setting the headerFont to an ascii (superset) font.

.SH "MESSAGE/PARTIAL"

Unless the config option assemblePartials is False (see the section
on THE CONFIG FILE), when knews encounters an article of type
message/partial, it will be rememberered.  When all the parts have
been seen, a notice will be popped up offering to assemble the
parts.

There is also an entry on the misc menu that allows a number of
articles to be tagged and processed to look for message/partial
articles.

.SH "POSTING MIME"

When you post an article containing 8 bit characters that doesn't
have a Content-Type header, knews will add such a header with
charset equal to the value of the defaultCharset config option.
Also, when quoting articles with Content-Type: text/plain and
charset equal to the defaultCharset, knews will decode the article
before quoting.  In both these contexts, the charset iso-8859-1
will be used if defaultCharset is not set.

.SH "READING THE SPOOLDIR"
Knews supports a rather obscure mechanism for communicating with an
arbitrary program instead of an nntp server.  Using knewsd(1), this
can be used for reading news (in)directly from the spool dir, or even
mail folders if they are in the correct format.  This is how it works:
If the nntp server is given as #str, where str is an arbitrary string
not containing white space or the characters '/', '.' or '*', knews
finds the value of the resource
.B Knews.#str
and tries to execute that program.  The program has its standard input
and output connected to knews.  If you use this resource setting:

.nf
Knews.#spool: knewsd -spool /var/spool/news \\
        -active /usr/local/news/active
.fi

with the appropriate paths for your system, you can read the spool
directory by specifying the nntp server as '#spool' in e.g. the connect
dialogue.  This could easily be used to read mh(1) style mail folders
too.

.SH "X RESOURCES"
There are a number of X resources that affect the behaviour and
appearance of knews.   Most widgets in the widget hierarchy has
resources named
.B background
,
.B foreground
,
.B shadowWidth
, and so on. For more information see the application defaults
file Knews.ad included in the distribution. To get a feeling for
resources, try editres(1).

Knews contains a small xpm-file to pixmap converter, so it is
possible to use settings like e.g.

.nf
Knews*backgroundPixmap:	~/pixmaps/texture.xpm
.fi

.B Knews.nntpServer
.RS
If this resource is set, knews automatically connects to this
nntp server on startup. This overrides the NNTPSERVER environment
variable. If the server listens to a non-standard port, you may
specify this e.g as foo.bar:1234. If you don't want knews to
autoconnect, don't set this or $NNTPSERVER.
.RE

.B Knews.editCommand
.RS
This resource specifies the editor used to edit posts. Possible
values include:

.nf
Knews.editCommand:  xemacs +%i %s
Knews.editCommand:  emacs +%i %s
Knews.editCommand:  xterm -e vi +%i %s
.fi

%s stands for the name of a temporary file, and %i for the line
where editing should begin. The default value of this resource
is a compile time option.
.RE

.B Knews.urlCommand
.RS
This command is used for clicking on URLs.  %s is expanded to the
URL, and the result is passed to the shell.  As a simple security
measure, URLs will not be allowed to contain quotes, parentheses,
whitespace or ampersands.
.RE

.B Knews.printCommand
.RS
If this resource is set, the misc menu will have a print option
which invokes this command.
.RE

.nf
.B Knews.needsTerminal
.B Knews.copiousOutput
.fi
.RS
These are two shell command templates that will be used for
mailcap viewers that have the
.B needsterminal
or the
.B copiousoutput
flag set, respectively.  In these, %C will be expanded to the
relevant mailcap command.  An example should explain it:

.nf
Knews.needsTerminal:	exec xterm -e /bin/sh -c '%C'
Knews.copiousOuptut:	exec xterm -e /bin/sh '(%C) | less'
.fi
.RE

.B Knews.mimeTypes
.RS
This should point to a file whose contents maps filename extensions
to mime types.  The syntax of this file is examplified by the
following list of compiled in types:

.nf
image/jpeg              jpg jpeg
image/gif               gif
application/postscript  ps
.fi

This is used to guess the Content-Type of attachments.
.RE

.B Knews.bell
.RS
Setting this resource to False will turn off the bell.
.RE

.B Knews.sortGroups
.RS
If this is set to True, knews will keep newsgroups alphabetically sorted
when new groups are subscribed.
.RE

.B Knews.separateWindows
.RS
Setting this resource to True will make knews use a different
top level window for the article text widget.
.RE

.B Knews.stderrTimeout
.RS
When knews starts a pipe or similar, it captures the standard
error output and displays it in a notice popup.  This resource
is the time in milliseconds this popup should stay up.  The
default is 10000.  Setting this to 0 means stay up indefinitely,
and negative means no popups.
.RE

.B Knews.showCache
.RS
If this is True, knews will show the state of the article caches
in a small popup.  See the config options cacheAheadSize and
cacheTrailSize for details.
.RE

.B Knews.mailName
.RS
If you have a mail address which isn't of the form 'userid@domain.name',
you can set this to the part of the address that goes before the '@',
e.g.

.nf
Knews.mailName:      FirstName.LastName
.fi

Note that your userid will still be used for the 'Sender' header if
necessary.
.RE

.B Knews.useIcon
.RS
If this is set to True (the default), knews will use an icon.
.RE

.B Knews.confirmQuit
.RS
Setting this to True will make knews ask for confirmation before
disconnecting or quitting.
.RE

.B Knews.confirmCatchup
.RS
If this is set to True, knews will ask for confirmation before
catching up a group.
.RE

.B Knews.confirmQuitGroup
.RS
If this is set to 'True', knews will ask for confirmation before
leaving a group.  If set to 'tagged', knews will ask confirmation
when exiting a group if there are tagged articles.
.RE

.nf
.B Knews.visualClass	class
.B Knews.visualDepth	bits
.fi
.RS
If these are set knews will use a visual of the specified class
and depth.  Typical values for depth are 8 or 24.  Legal values
for class are 'StaticGray)', 'GrayScale', 'StaticColor',
\'PseudoColor', 'TrueColor' and 'DirectColor'.  The depth will be
ignored if no class is specified.
.RE

.B Knews.installCmap
.RS
If this is set to True, knews will create its own colormap.
.RE

.B Knews.inlineImages
.RS
This boolean resource turns on/off inline images and color
allocation.  Knews can show jpeg, gif and png images (if
compiled with support for this).
.RE

.B Knews.nCols
.RS
This is the maximum number of colors knews will allocate for
inline images.  The default is 137 (17 greys and a 5x5x5
color cube minus the 5 greys in that cube).
.RE

.B Knews.colorHack
.RS
If this is set to True, knews try to allocate the same colors
as other programs have already allocated, thus increasing the
chances for color sharing.  The number of colors is controlled
by the resource Knews.nCols.
.RE


The following resources can be used to change various color,
font and geometry settings:

.nf
.B Knews*grouplist.preferredLines
.B Knews*grouplist.preferredColumns
.fi
.RS
These resources specify the number of lines and columns the
grouplist widget will start up with. The default is 14 for
lines and 84 for columns.
.RE

.nf
.B Knews*text.preferredLines
.B Knews*text.preferredColumns
.fi
.RS
These resources specify the number of lines and columns the
article text widget start up with. The default is 32 for
lines and 84 for columns.
.RE

.B Knews*ArtTree.nodeColumns
.RS
The width of the nodes in the article tree in characters.  The
default is 16.
.RE

.B Knews*rubberColor
.RS
The color used for rubberbanding in one or two widgets.  The default is red.
.RE

.nf
.B Knews.headerColor
.B Knews.bodyColor
.B Knews.quoteColor
.fi
.RS
The colors used for headers, ordinary text and quoted text respectiely
in the article window.
.RE

.nf
.B Knews*innerColor
.B Knews*innerDashed
.fi
.RS
The color and line style used for the border of unread articles in
the article tree. The defaults are Red and False.
.RE

.nf
.B Knews*outerColor
.B Knews*outerDashed
.fi
.RS
The color and line style used for the border of tagged articles in
the article tree. The defaults are foreground and False.
.RE

.B Knews*ScrList.font
.RS
The font used in the lists.
.RE

.B Knews.defaultHotColor
.RS
The color used for hot entries in the kill file when the specified
color is invalid or cannot be allocated.
.RE


Some miscellaneous resources:

.B Knews.icaseRegexps
.RS
Setting this to False will make regular expressions case sensitive.
They are case insensitive by default.
.RE

.nf
.B Knews.readActiveFile
.B Knews.retrieveDescriptions
.B Knews.fillNewsrcFile
.B Knews.showNumberLines
.B Knews.keepThreadInfo
.B Knews.checkForNewGroups
.fi
.RS
These set the default values for the corresponding configuration
options.  Their main purpose is to allow command line arguments.
Read the section on the config file for details.
.RE

.nf
.B Knews.newsrcTemplate
.B Knews.oldNewsrcTemplate
.fi
.RS
These set the default values for the configuration options
newsrcFile and oldNewsrcFile, the default values are ~/.newsrc-%s
and ~/.oldnewsrc-%s.  A value not containing %s will not be
accepted; if you want the traditional ~/.newsrc for a particular
server, see the resource Knews.configNntpServer below.
.RE

.B Knews.killFileTemplate
.RS
This sets the default value of the config option killFile.  The
default value is ~/.knews/.kill-%s.
.RE

.B Knews.groupKillFileTemplate
.RS
This is the template for the per-group kill file.  The default
is ~/.knews/%s/%g/KILL, so that e.g. the newsgroup news.software.readers
will have ~/.knews/%s/news/software/readers/KILL as kill file,
where %s is the name of the server, as usual.
.RE

.B Knews.configFile
.RS
The configuration file used by knews.  The default value
is ~/.knews/config-%s, a value not containing %s will not
be accepted.
.RE

.nf
.B Knews.configNntpServer
.B Knews.configPostingAgent
.fi
.RS
Setting configNntpServer will make knews Do The Right Thing
when the user first connects to this server, which means
setting the newsrc file for this server to ~/.newsrc when
creating the config file.

If the configPostingAgent is set this will be used for
the postingAgent config option for the configNntpServer.
.RE

.B Knews.generatePath
.RS
If this is set to True, knews will generate a Path header for
articles.  The header will be 'Path: d!u' where d and u are such
that the From header generated by knews would be 'From: u@d'.
.RE

.B Knews.autoSubscribe
.RS
The value of this resource will be used when creating a new
newsrc file.  If it starts with a '/', it is taken as a pathname
of a file whose contents will be inserted into the new newsrc
file, otherwise the literal value of this resource will be
inserted into the newsrc file.  The default value is

.nf
   news.answers:\\nnews.newusers.questions:\\n
.fi
.RE

.B Knews.bogusFileSystem
.RS
When knews checks for new groups, it uses the atime (time of
last access) of the config file.  Some filesystems (e.g. AFS) have
no concept of atime, but fakes it with mtime (time of last
modification) instead.  Setting this resource to True will
make knews forcibly update the mtime of the config file.
.RE


.SH THE CONFIG FILE

When knews connects to an NNTP server it reads a configuration
file that will affect its behavior.  This file is by default
called ~/.knews/config-%s where %s expands to the name of the
server, but this may be changed with the Knews.configFile resource.

The syntax of the config file is the same as for X resource
files.  When knews can't find the configure file, a new one
will be created containing some default settings and a few
examples settings that should be sufficient to clue you in
as to how it works.

It is possible to used #include statements in the config file
to include other files.  Relative pathnames are considered
relative to the current working directory, which for knews
is always $HOME.  ~ pathnames are not handled in #includes (if
you want that you have to hack Xlib).

The following global (i.e. per server) options exist.

.nf
.B newsrcFile
.B oldNewsrcFile
.fi
.RS
These specify the newsrc file and oldnewsrc file for this
server.  ~ pathnames and the same % expansions as for saving
are handled.  If oldnewsrc is set to an empty string, no
backup of the newsrc file will be created.

The default values for these are the values of the resources
Knews.newsrcTemplate and Knews.oldNewsrcTemplate, whose default
values are ~/.newsrc-%s and ~/.oldnewsrc-%s, respectively.

For a way of automatically using the standard file ~/.newsrc
for a specific server, see the resource Knews.configNntpServer
above.
.RE

.B killFile
.RS
The kill file. The default value is the value of the resource
Knews.killFileTemplate, whose default value is ~/.kill-%s.
.RE

.B cacheDir
.RS
This directory is used for storing cached articles and thread
data for groups.  The default is ~/.knews/cache-%s.
.RE

.B readActiveFile
.RS
Setting this to False will stop knews from reading the active
file when connecting, using the groups in the newsrc file instead.
This will speed up connection on slow lines if you don't have too
many subscribed groups.  The default is the value of the
resource Knews.readActiveFile, whose default is True.
.RE

.B retrieveDescriptions
.RS
A boolean option indicating whether to retrieve newsgroup
descriptions from the server. The default is the value of the
resource Knews.retrieveDescriptions, whose default is True.
Setting this to False may slightly speed up connection time.
.RE

.B descriptionsFile
.RS
If this is set, the given file will be used to cache group
descriptions: when retrieveDescriptions is True, knews saves
the descriptions to this file and when retrieveDescriptions
is False, knews reads descriptions from this file instead
of from the server.
.RE

.B fillNewsrcFile
.RS
Setting this to True will make knews write all groups it knows
about to the newsrc file, which may be a good idea if the option
readActiveFile is set to False.  The default is the value of the
resource Knews.fillNewsrcFile, whose default is False, which means
only put information in the newsrc file.
.RE

.B tryListActive
.RS
When this is True (the default) and readActiveFile is False,
knews will try the "LIST ACTIVE wildmat" nntp extension.  If this
fails knews will complain and fall back to the old "GROUP" stuff.
.RE

.B checkForNewGroups
.RS
This is a boolean option indicating whether to check for
new groups when connecting to this server. The default is True.
The atime (time of last access) of the config file will be
used for the check.
.RE

.B threadAheadGroups
.RS
This is a white-space separated list of groups to be automatically
scheduled for thread ahead when connecting.  The special values 'all'
and 'All' may be used to designate all subscribed groups with
unread articles and all subscribed groups, respectively.
.RE

.B saveThreadInfo
.RS
Setting this to True will allow 'thread ahead' data to be saved between
sessions: knews will not remove the files with this data when quitting,
and when connecting knews will check for these files for all subscribed
groups.  If this is set, the options threadAheadGroups and keepThreadInfo
will be ignored.
.RE

.B rescanTimeout
.RS
This indicates the time in minutes between automatic rescans.
The default is 60 minutes, 0 means no automatic rescans.
Regardless of this, rescans will only be performed at special
points, to prevent a 'rescan-idle-rescan' loop.
.RE

.B groupNameColumns
.RS
The width of the group name in the group list, default is 42.
.RE

.B askHowMany
.RS
Setting this to True will make knews ask at which article
the threading of a group should start.  A hack.
.RE

.B postingAgent
.RS
If this is specified, knews will use this for posting, instead
of posting via NNTP.  If your server requires some kind of
authentication that only inews understands, you could set this
to 'inews -h'.  Note that inews appends the signature, so you
don't want knews to add one too.

Also see the resource Knews.configPostingAgent above.
.RE

.nf
.B authInfoPass
.B authInfoUser
.fi
.RS
These are used to implement the NNTP AUTHINFO USER/PASS protocol
if required by the server.  These exist mostly for backward
compatibility; authentication is usually only required when posting,
and then it is better to use inews for postingAgent, since
presumably inews knows all about the required authentication.
.RE

Here is an example of some settings that will improve things
over a slow network connection:

.nf
readActiveFile:          False
retrieveDescriptions:    False
descriptionsFile:        ~/.knews/cache-%s/descriptions
fillNewsrcFile:          True
.fi

but note that you will probably want to read the active file
and group descriptions at least the first time you connect to
a server.


The following resources may be set on a per group basis; they
should be prefixed with the name of the group they apply to.

.B keepThreadInfo
.RS
This tells knews whether to keep thread information in memory
after the group is exited.  This will make reentering the group
fast. Legal values are: True, Subscribed and False. 'Subscribed'
means only do it if the group is subscribed, and exists to allow
settings such as:

.nf
*keepThreadInfo:    Subscribed
.fi

to keep thread info for all subscribed groups.  The default value
for this option is 'Subscribed' if the resource Knews.keepThreadInfo
is set to True and 'False' otherwise.
.RE

.nf
.B cacheAheadSize
.B cacheTrailSize
.fi
.RS
These two set the sizes of the two article caches, the defaults
are 0.  The 'ahead cache' is used to prefetch articles from the
server in the background using a second connection.  The 'trail
cache' is used to keep articles that you have already read, so
that going back, saving or uudecoding will be faster.  The
maximum values for these are 32.
.RE

.B sortThreads
.RS
This indicates how the threads should be sorted.  A thread consists
of several subjects.  These are sorted within the thread according
to the order they occur.  Then the threads are sorted according
to the setting of this option.  The legal values and their meanings are:

.nf
subject       Alphabetically by the first subject in the thread.
size          Number of unread articles in the thread.
full-size     Number of articles in the thread.
hot           Number of hot articles in the thread.
date          The date of the first unread article.
average-date  The average date of unread articles in the thread.
author        Alphabetically by the first From: line in the thread.
none          No sorting.
.fi

All these values may be prefixed with a minus sign to indicate
a reversal of the order, or a plus sign which is a no-op.
The default value is none.
.RE

.B expireKills
.RS
Setting this to False will stop expirations from the kill file.
The default is True, which means that Message-id kills will
expire when you enter a group where the kill entry would
have been applicable, but the article with that message-id
was not found.
.RE

.B attribution
.RS
This string is used to attribute quotations when you post
a followup. The default is

.nf
In article %m,\\n     %f writes:
.fi

where \\n is a newline.  The following %'s are expanded:

.nf
%%    %
%d    The date of the quoted article in the form 01 Jan.
%f    The From: line of the article replied to.
%i    The initials of the previous poster.
%I    The initials of the previous poster, capitalized.
%m    The message-id of the article replied to.
%n    The current newsgroup.
%r    The real name of the previous poster.
%s    The subject of the quoted article.
%t    The time of the quoted article in the form 18:24:02.
%w    The week day of the quoted article.
%y    The year of the quoted article.
.fi

Thus '%w, %d %y %t GMT' will give the date in standard rfc822 format.
.RE

.B fullName
.RS
This is the full name used in the 'From:' header in the articles
you post. The default is $NAME, if set, otherwise the gecos field
from the password file, suitably truncated.
.RE

.B headerFormat
.RS
A colon and white-space separated list specifying which headers
to show in the article window, and in what order. The default is

.nf
Subject:Newsgroups:Followup-To:Reply-To:\\
Content-Description:Date:Organization:From:
.fi

If the name of the header starts with a captial letter (From: as
opposed to from:), knews will decode rfc1522 encoded words
encountered in this header.  (Those are the weird things that
look like =?iso-8859-1?q?stuff_here?=.)  Encoded 16-bit charsets
are not decoded in headers yet.
.RE

.B assemblePartials
.RS
This boolean tells whether message/partial articles will be
remembered and offered for assembly.
.RE

.B quoteRegexp
.RS
Lines in an article matching this regular expression will be
considered quoted lines, and may be marked with a different color
and font. The default is

.nf
^[ \\t]*[:>|]
.fi

which matches lines beginning with an arbitrary amount of white
space (the \\t denotes a tab, note that \\t won't actually work)
followed by a >, : or | character.

You will probably want to have this expression anchored...
.RE

.B defaultCharset
.RS
The fonts for this charset will be used to display articles that
lack MIME-headers.  If this is not set, us-ascii will be assumed.

Also, rfc1522 encodings of this charset in the From and Subject
header will be decoded when displayed in the article tree and the
thread list.  In this case, iso-8859-1 is the default.
.RE

.B showNumberLines
.RS
A boolean option indicating whether to show the number of lines
in articles in the thread tree.  The default is the value
of the resource Knews.showNumberLines, whose default is False.
.RE

.B signatureFile
.RS
The contents of this file will be used to sign the articles you
post (before editing). The default is ~/.signature.
.RE

.B subjectColumns
.RS
The width of the subject in the thread list, default is 56.
.RE

.nf
.B quoteString
.B quoteQuoteString
.fi
.RS
These strings are used for quoting when posting a followup
article; the first one are used to quote lines that were not
quoted in the original article, and the second one is used
for lines that were already quoted.  What lines are considered
quoted is determined by the quoteRegexp.  The defaults are "> "
and ">" respectively.  In these strings, %i is expanded to the
initials of the previous author and %I to the initials, capitalized.
.RE

.B postedAndMailed
.RS
This string will be instered into articles that are also mailed
to the previous author.  The default is "[posted and mailed]".
.RE

.B distribution
.RS
If this is set, it will be used as the content of a 'Distribution'
header.  The default value is the value of the environment variable
DEFNEWSDIS if set, otherwise empty.
.RE

.B fullHeader
.RS
A boolean specifying whether to show all headers in the article
window. It also means turn off all MIME transformations. The
default is False.
.RE

.B replyTo
.RS
A string used to construct the 'Reply-To:' header in the articles
you post. The default is the value of the environment variable
REPLYTO if set, otherwise empty.
.RE

.B organization
.RS
A string used to construct the 'Organization:' header in the
articles you post. The default is $NEWSORG if set, otherwise
$ORGANIZATION if set, otherwise nothing.
.RE

.B processXrefs
.RS
If this boolean is True, as it is by default, articles that are
crossposted will be marked read in all groups when you read them,
mark them read, kill them or catch them up.

Note that this only applies to subscribed groups, and will only
work if the server's overview file contains the Xref: headers.
.RE

.B extraHeaders
.RS
This string is inserted into the head of all articles you
post (before editing). The default is empty.  This could be
used to put in Mime headers, like this:

.nf
*extraHeaders:   Content-Type: text/plain; charset=iso-8859-1
.fi
.RE

.B followupHeaders
.RS
This is a combination of extraHeaders and attribution: it
is inserted in the headers of replies and followups and the
same %'s as in attribution are expanded.  An example:

.nf
*followupHeaders:	X-Comment-To: %r
.fi
.RE

.B uuDir
.RS
Uudecoded files will end up in this directory.  Or rather, the
forked off uudecoding process will be given this as its current
working directory.  The default is ~/News.
.RE

.B uuProgram
.RS
This program will be used to uudecode files: it will be given the
bodies of the relevant articles on standard input.  The default
is NULL, which means that knews will do its best to filter out
garbage and then pipe the rest to 'uudecode'.
.RE

Here is an example of how to set different signatures for
different newsgroups:

.nf
swnet*signatureFile:     ~/.signature-svensk
de*signatureFile:        ~/.signature-deutsch
*linux*signatureFile:    ~/.signature-linux
.fi

The first sets the file ~/.signature-svensk for all groups in the
swnet hierarchy, the second one sets the file ~/.signature-deutsch
for the de hierarchy, and the last one sets the file ~/.signature-linux
for any group containing linux as a component (not merely a substring).
The file ~/.signature will be used for all other groups.


.SH ACTIONS
Knews defines a number of actions that can be tied to keys and buttons
via translations.  For the default translations, see the application
defaults file.

.B do-the-right-thing()
.RS
Does the right thing.
.RE

.nf
.B kill-append(field, scope [, color])
.B kill-prepend(field, scope [, color])
.fi
.RS
These action procedures append and prepend respectively entries to
the kill file for the current group according to the currently
selected article.

Valid values for the 'field' parameter are "From", "Subject"
and "Message-Id", and valid values for 'scope' are "Thread", "Subthread"
and "Subject".  If the color parameter is present, the entry
added is a hot-entry with that color, otherwise it is a kill-entry.

It is probably a good idea to use these with field = "message-id",
since message-id kills are very efficient and expire with the
corresponding article.
.RE

.B popup-kill([group])
.RS
This will popup a kill file editor for the supplied group.  If no
group is given, the editor for the global kill file is popped up.
.RE

.B mime-hack(content-type, content-transfer-encoding)
.RS
This action procedure reloads the current article, pretending it had
the specified Content-Type and Content-Transfer-Encoding headers.
For example mime-hack(image/jpeg, uue) reloads the current article
pretending it has Content-Type image/jpeg and is uuencoded, thus
makeing knews display it as an inline image.

The default key-bindings have the following:
.nf
ctrl-J      mime-hack(image/jpeg, uue)
ctrl-G      mime-hack(image/gif, uue)
ctrl-P      mime-hack(image/png, uue)
.fi
.RE

.nf
.B tree-up(arg)
.B tree-down(arg)
.B tree-left(arg)
.B tree-right(arg)
.B tree-down-right(arg)
.fi
.RS
These move around in the thread tree. If the arg is 'read', they will
also read in the relevant article, if arg is 'fake', they will also try
to read 'fake' articles.
.RE

.nf
.B list-up(arg)
.B list-down(arg)
.fi
.RS
These move up and down in the lists. If arg is given, it is the number
of steps, or if it contains a '.', the fraction of the window to move.
.RE

.nf
.B enter-mode()
.B exit-mode()
.fi
.RS
These two actions moves between modes.
.RE

.nf
.B tree-or-list-up(arg)
.B tree-or-list-down(arg)
.B tree-left-or-exit-mode(arg)
.B tree-right-or-enter-mode(arg)
.fi
.RS
These are combination actions.  E.g. tree-or-list-up(arg) does tree-up or
list-up(1), depending on which is relevant.
.RE

.B read-article(arg)
.RS
This rereads the current article. If arg is given, the article is displayed
with full header and no MIME transformations.
.RE

.B view-thread(arg)
.RS
This moves between the subject list and the thread tree. If arg is 'toggle',
it toggles, if arg is 'yes' it goes to the tree, and if arg is 'no', it goes
to the subject list.
.RE

.nf
.B followup(arg)
.B reply(arg)
.B followup-and-reply(arg)
.B post-new()
.fi
.RS
These correspond to the options on the post menu. If arg is given as 'yes'
or 'no', it indicates whether to include quoted text.
.RE

.nf
.B uudecode()
.B clear-tagged()
.B mark-read-article()
.B mark-read-subject()
.B mark-read-thread()
.B mark-read-subthread()
.B mark-read-to-current()
.B mark-read-all()
.B mark-read-tagged()
.B mark-read-non-tagged()
.B mark-read-cold()
.B mark-unread-article()
.B mark-unread-subject()
.B mark-unread-thread()
.B mark-unread-subthread()
.B mark-unread-all()
.B mark-unread-tagged()
.B mark-unread-killed()
.fi
.RS
These perform the corresponding functions on the misc menu.
.RE

.nf
.B pipe(command, parts [, scope])
.B save(filename, parts [, scope])
.fi
.RS
Pipe and save actions.  The argument 'parts' is a combination of the
characters 'f', 's', 'h', 'b', 'e', corresponding to the 'bogus
from', 'bogus subject', 'head', 'body' and 'empty line' options on
the save popup window.  The 'scope' parameter is optional, and is
one of 'window', 'article', 'subject', 'thread', 'subthread' and 'tagged',
corresponding to those options on the save popup.
.RE

.nf
.B tag-thread([all])
.B tag-subject([all])
.fi
.RS
These tag the unread articles in a thread or subject.  If 'all' is specified,
they tag all articles in the thread or subject.
.RE

.nf
.B untag-thread()
.B untag-subject()
.fi
.RS
These untag the tagged articles in a thread or subject.
.RE

.B tag-hot()
.RS
This action tags all unread hot articles, same as on the misc menu.
.RE

.nf
.B catchup()
.B unsubscribe()
.B subscribe()
.fi
.RS
Guess what.
.RE

.B change-size(pixels)
.RS
Changes the size of the upper portion of the main window by the specified
number of pixels.
.RE

.B schedule-thread-ahead()
.RS
Causes a group to be scheduled for 'thread ahead'.
.RE

.B popup-find-group()
.RS
Popups the 'find group' popup, same as the 'find group' option on the
misc menu.
.RE

.SH WIDGETS
The X interface of knews is built with its own widget set plus the
Layout Widget. You are welcome to use it if you like. Unfortunately
there is no documentation.

.SH AUTHOR
This software is Copyright 1995, 1996 by Karl-Johan Johnsson
<su95-kjo@nada.kth.se>.

Permission is hereby granted to copy, reproduce, redistribute or otherwise
use this software as long as: there is no monetary profit gained
specifically from the use or reproduction of this software, it is not
sold, rented, traded or otherwise marketed, and this copyright notice is
included prominently in any copy made. 

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. ANY USE OF THIS
SOFTWARE IS AT THE USERS OWN RISK.

.SH ACKNOWLEDGMENTS

The threading algorithm was adapted from trn. Thanks to Wayne Davison.

Knews uses Keith Packard's Layout Widget.

The distribution includes Henry Spencer's regex package for
environments that do not have the POSIX.2 regular expression
functions.

Thanks to Mattias Jonsson for ardent testing.

.nf
From the gif89a spec:

"The Graphics Interchange Format(c) is the Copyright property of
 CompuServe Incorporated. GIF(sm) is a Service Mark property of
 CompuServe Incorporated."
.fi


Any problems are of course entirely due to me.
.SH "SEE ALSO"
egrep(1), knewsd(1), trn(1), uudecode(1), mailcap(5), newsrc(5), regex(7).

.SH "KNOWN PROBLEMS"
If the server doesn't support XOVER, threading will be very slow.

The uudecode function may not recognize or correctly handle all cases.

The dithering algorithm used for grayscale images and color
gifs (essentially 'closest match') is very poor.

AUTHINFO SIMPLE doesn't work for the second connection.

When the last article in a group has been cancelled, the number
of unread articles may be incorrect.

.SH BUGS
Send bug reports and comments to su95-kjo@nada.kth.se.
