OBJS = posix.o
LIBS = -lpthread -lposix4
DIR_CPPFLAGS = $(OMNITHREAD_CPPFLAGS) $(OMNITHREAD_POSIX_CPPFLAGS)

all:: libomnithread.so.1.0

libomnithread.so.1.0: $(OBJS)
	(set -x; \
        $(RM) $@; \
        ld -shared -soname libomnithread.so.1  \
           -set_version libomnithread.so.1 -o $@ $(OBJS) \
           -lpthreads -lmach -lc_r -lcxxstd -lcxx -lexc -lots -lc; \
       )

clean::
	$(RM) *.o core
	$(RM) libomnithread.so.1.0

install:: libomnithread.so.1.0
	@(set -x; \
          $(MKDIRHIER) $(LIBDIR); \
          $(CP) libomnithread.so.1.0 $(LIBDIR); \
          cd $(LIBDIR); \
          $(RM) libomnithread.so; \
          ln -s libomnithread.so.1 libomnithread.so; \
          $(RM) libomnithread.so.1; \
          ln -s libomnithread.so.1.0 libomnithread.so.1; \
         )


posix.o: ../posix.cc
	$(CXX) -c $< $(CXXFLAGS) -o $@ ../posix.cc

