/*
 * defines for the error and message code.
 *
 * Copyright 1995 by Gray Watson
 *
 * This file is part of the dmalloc package.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * NON-COMMERCIAL purpose and without fee is hereby granted, provided
 * that the above copyright notice and this permission notice appear
 * in all copies, and that the name of Gray Watson not be used in
 * advertising or publicity pertaining to distribution of the document
 * or software without specific, written prior permission.
 *
 * Please see the PERMISSIONS file or contact the author for information
 * about commercial licenses.
 *
 * Gray Watson makes no representations about the suitability of the
 * software described herein for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * The author may be contacted at gray.watson@letters.com
 *
 * $Id: error.h,v 1.32 1997/12/22 00:32:03 gray Exp $
 */

#ifndef __ERROR_H__
#define __ERROR_H__

#include <stdarg.h>				/* for ... */

#include "conf.h"				/* up here for _INCLUDE */

/* for timeval type -- see conf.h */
#if STORE_TIMEVAL
#ifdef TIMEVAL_INCLUDE
#include TIMEVAL_INCLUDE
#endif
#endif

/*<<<<<<<<<<  The below prototypes are auto-generated by fillproto */

/* logfile for dumping dmalloc info, DMALLOC_LOGFILE env var overrides this */
extern
char		*dmalloc_logpath;

/* internal dmalloc error number for reference purposes only */
extern
int		dmalloc_errno;

/* address to look for.  when discovered call dmalloc_error() */
extern
DMALLOC_PNT	dmalloc_address;

/* global debug flags that are set my DMALLOC_DEBUG environ variable */
extern
unsigned int	_dmalloc_flags;

/* global iteration counter for activities */
extern
unsigned long	_dmalloc_iter_c;

#if STORE_TIMEVAL
/* overhead information storing when the library started up for elapsed time */
extern
struct timeval	_dmalloc_start;
#endif

#if STORE_TIMEVAL == 0
/* no comments found for this variable */
extern
long		_dmalloc_start;
#endif

/* global flag which indicates when we are aborting */
extern
int		_dmalloc_aborting_b;

#if STORE_TIMEVAL
/*
 * print the time into local buffer which is returned
 */
extern
char	*_dmalloc_ptimeval(const struct timeval *timeval_p,
			   const int elapsed_b);
#endif

#if STORE_TIMEVAL == 0
/*
 * print the time into local buffer which is returned
 */
extern
char	*_dmalloc_ptime(const long *time_p, const int elapsed_b);
#endif

/*
 * message writer with printf like arguments
 */
extern
void	_dmalloc_message(const char *format, ...);

/*
 * kill the program because of an internal malloc error
 */
extern
void	_dmalloc_die(const int silent_b);

/*
 * handler of error codes from procedure FUNC.  the procedure should
 * have set the errno already.
 */
extern
void	dmalloc_error(const char *func);

/*<<<<<<<<<<   This is end of the auto-generated output from fillproto. */

#endif /* ! __ERROR_H__ */
