/*
 * FILE:    codec.h
 * PROGRAM: RAT
 * AUTHOR:  Isidor Kouvelas + Colin Perkins
 *
 * $Revision: 1.12 $
 * $Date: 1997/05/16 12:38:31 $
 *
 * Copyright (c) 1995,1996 University College London
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, is permitted, for non-commercial use only, provided
 * that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Computer Science
 *      Department at University College London
 * 4. Neither the name of the University nor of the Department may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 * Use of this software for commercial purposes is explicitly forbidden
 * unless prior written permission is obtained from the authors.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _RAT_CODEC_H_
#define _RAT_CODEC_H_

/* Official RTP audio payload type assignments, from */
/* draft-ietf-avt-profile-new-00 (27 March 1997)     */
#define	PCMU			0
#define	FED_STD_1016		1
#define G721			2
#define	GSM			3
#define	G723_1			4
#define	DVI_8000		5
#define	DVI_16000		6
#define	LPC			7
#define	PCMA			8
#define G722			9
#define	L16_44100_STEREO	10
#define	L16_44100_MONO		11
#define	G723			12
#define	CN			13
#define	MPEG_AUDIO		14
#define	G728			15
#define	DVI_11025		16
#define	DVI_22050		17
#define G729			18
#define	REDUNDANCY		77

#define WBS			124	/* Temp dynamic */

#define	PCM			PCMU
#define DVI			DVI_8000

/* Internal IDs, should be out of payload range */
#define DVI_WITH_STATE		130
#define L16             	131
#define WBS_WITH_STATE		132
#define DUMMY			255

#define DVI_UNIT_SIZE		(SAMPLES_PER_UNIT >> 1)
#define DVI_STATE_SIZE		sizeof(struct adpcm_state)

#endif /* _RAT_CODEC_H_ */

