#include <stdlib.h>
#include <gtk/gtk.h>

#include "guiinterface.h"

#include "../history.h"
#include "../ai/aiinterface.h"
#include "../game.h"

extern GlobalOptions global_options;

void cb_dialog_destroy(GtkWidget *w, GtkWidget **window)
{
	(*window) = NULL;
}

void cb_dialog_create(GtkWidget *w, gpointer *data)
{
	if(data[1] != NULL)
		gdk_window_raise(((GtkWidget *)data[1])->window);
	else
		((DialogCreationFunc)data[0])((GtkWidget **)&data[1]);
}

void cb_board_clear(GtkWidget *W, gpointer *data)
{
	game_init_play();
}

void cb_undo(void)
{
	if(global_options.allow_undo)
		history_move_undo();	
}

void cb_redo(void)
{
	if(global_options.allow_undo)
		history_move_redo();
}
