#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>

#include "guimenu.h"

GtkWidget *_gui_menu_create(GuiMenuTree *gui_menu_tree, int level)
{
	GtkWidget *menu;
	GuiMenuTree *p;

	if(!level)
		menu = gtk_menu_bar_new();
	else
		menu = gtk_menu_new();
	for(p = gui_menu_tree->child; p; p = p->next) {
		if(p -> right_justify)
			gtk_menu_item_right_justify(GTK_MENU_ITEM(p->item));
		if(!level)
			gtk_menu_bar_append(GTK_MENU_BAR(menu), p->item);
		else
			gtk_menu_append(GTK_MENU(menu), p->item);
		if(p->child)
			gtk_menu_item_set_submenu(GTK_MENU_ITEM(p->item), _gui_menu_create(p, level+1));
	}

	return menu;
}

GtkWidget *gui_menu_create(GtkWidget *Window, GuiMenuTree *gui_menu_tree)
{
	return _gui_menu_create(gui_menu_tree, 0);
}

GuiMenuTree *gui_menu_tree_new(GtkWidget *item, gboolean right_justify, ...)
{
	GuiMenuTree *tree, **t;
	va_list args;

	va_start(args, right_justify);
	
	tree = malloc(sizeof(GuiMenuTree));
	tree->item = item;
	tree->right_justify = right_justify;
	tree->child = NULL;
	t = &(tree->child);

	while(((*t) = va_arg(args, GuiMenuTree *)) != NULL)
		t = &((*t)->next);

	va_end(args);

	return tree;
}

void gui_menu_tree_destroy(GuiMenuTree *p, gboolean destroy)
{
	if(p->child)
		gui_menu_tree_destroy(p->child, destroy);
	if(p->next)
		gui_menu_tree_destroy(p->next, destroy);
	if(p->item && destroy)
		gtk_widget_destroy(p->item);
	free(p);
}

GtkWidget *gui_menu_item_new_with_label(char *str, GtkSignalFunc func, gpointer data)
{
	GtkWidget *menu_item, *accel_label;

	menu_item = gtk_menu_item_new();
	accel_label = gtk_accel_label_new(str);
	gtk_label_parse_uline(GTK_LABEL(accel_label), str);
	gtk_misc_set_alignment(GTK_MISC(accel_label), 0.0, 0.5);

	gtk_container_add(GTK_CONTAINER(menu_item), accel_label);
	gtk_accel_label_set_accel_widget(GTK_ACCEL_LABEL(accel_label), menu_item);
	gtk_widget_show(accel_label);

	gtk_signal_connect(GTK_OBJECT(menu_item), "activate", func, data);

	return menu_item;
}

GtkWidget *gui_menu_item_hseparator_new(void)
{
	GtkWidget *menu_item;

	menu_item = gtk_menu_item_new();
	gtk_container_add(GTK_CONTAINER(menu_item), gtk_hseparator_new());

	return menu_item;
}
