#include <gtk/gtk.h>
#include <stdio.h>

#include "guiscore.h"

#include "../game.h"

extern GlobalOptions global_options;
extern PlayerOptions player_options[2];
extern GtkWidget *status_bar;

void gui_score_into_statusbar(void)
{
	char text[1024];

	sprintf(text, "%s: %d  %s: %d",
		player_options[0].name, player_options[0].score,
		player_options[1].name, player_options[1].score);
	gtk_statusbar_push(GTK_STATUSBAR(status_bar), 1, text);
}

void gui_score_update(void)
{
	gtk_statusbar_pop(GTK_STATUSBAR(status_bar), 1);
	gui_score_into_statusbar();
}

void gui_score_init(void)
{
	gui_score_into_statusbar();
}
