/*
 * afosmain.c
 *
 * This module contains the initialization routines for afosd
 *
 * $Id: afosmain.c,v 1.14 1996/09/18 18:14:26 ron Exp $
 *
 */
#include <termios.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
#include <stdio.h>

#include "afos.h"

int debugfd ;
int ttyfd ;

main(int argc, char **argv)
{
	int ret ;

#ifdef STDERR_REDIRECT
	/* 
		This is the Beta version.  Redirect stderr to file for now.
	*/
	debugfd = open (WXD_LOG_FILE, O_CREAT|O_WRONLY|O_APPEND, 0664 ) ;
	if ( debugfd < 0 ) {
		debugfd = open ("/tmp/afosd.log", O_CREAT|O_WRONLY|O_APPEND, 0664 ) ;
		if ( debugfd < 0 ) {
			/* give up */
			goto skip_redirect;
		}
	}
	dup2 ( debugfd, 2 ) ;

	/* If detached, don't write to stdout either, redirect to file */
	if (  (argc > 1)  && ( argv[1][0] == '-' )  &&  (argv[1][1] == 'd')  )
		dup2 (debugfd, 1 ) ;
skip_redirect:
#endif

	printf("KD9KX AFOS Daemon \"afosd\"\n"
		   "Linked: %s %s\n",
		af_link_time, af_link_date );
	printf( "Copyright 1996  Ron Luse, KD9KX\n"
			"All rights reserved.\n"
			"See accompanying documentation for licensing information.\n\n"
			"Limited license in non-commercial use for data "
			"distribution\nto amateur radio environments granted.\n\n" );
	sleep(2);


	/*
		Initialize data structures: timers, port lists, unit lists, etc.
	*/
	afloop_init();
	filter_init();
	afhist_init();
	afconfig_init();
	afaprs_init();
	aftcp_init();

	/*
		Read the port configuration file, tentatively named
		 "/usr/local/etc/afos.ports".
	*/
	printf("Reading channel configuration file...\n");
	afconfigports(PORT_CONFIG_FILE);


	/* Open the afos input channel */
	afio_init();

	/*
		Open the specified serial devices with the specified radio types 
		and baudrates.
	*/
	printf("Initializing channels...\n");
	afconfig_port_init();

	/* 	
		Read the radio alias file, tentatively named
		  "/usr/local/etc/radiod.alias".
	*/

	/*
		Initialize and fill out the alias/name table with entries
		from the alias table
	*/

	/*
		Read the permission configuration file, tentatively named
			"/usr/local/etc/radiod.perms"
	*/

	/*
		Open the network ports (UDP and TCP) for listening
	*/

	/* 
		Read the AFOS descriptor-to-port configuration file.
		"/usr/local/etc/afos.filter"
	*/
	printf("Reading filter/routing configuration file...\n");
	afconfigfilter(PORT_FILTER_FILE);

	if (  (argc > 1)  && ( argv[1][0] == '-' )  &&  (argv[1][1] == 'd')  ) {
		ttyfd = open ("/dev/tty", O_RDWR ) ;
		/*
		fprintf(stderr, "ttyfd=%d\n", ttyfd ) ;
		*/
		ret = ioctl ( ttyfd, TIOCNOTTY, NULL ) ;
		/*
		fprintf(stderr, "ioctl returned %d\n", ret ) ;
		*/
		close (ttyfd);
		setpgid( 0, 0 );
	}
	else {
	/* If debuging (and not detached from terminal, init the user interface */
		afui_init();
	}

	/*
		Start the main (select loop)
	*/
	afloop() ;
}
