// $Id: Cxx.hh,v 1.30 1998/10/09 13:05:23 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "Tag.hh"
#include "File.hh"
#include "Naming.hh"
#include "Writer.hh"

class Cxx : Naming
{  	File h,gh,gc,c,main,autogen,makefile_am,configure_in,makefile;
	Tag *top;

	// changes Tag tree
	void ApplyPreferences(Widget &w);
	
	void DefineRequirements(const Widget &w,int &value);
	void WriteTree(const Widget &w);
	void PrintWidget(const Widget &w);
	void CreateSupportFiles();
	// write a first header
	void WriteHeader(File &f);
	// now we know about requirements
	void WriteHeader2(File &f);
	void WriteFooter(File &f);
	void WriteCreation(File &f);
	
	bool TestSubwidgetsForCtor(const Writer &wr,const Widget &w,bool is_member);
	void TestSubwidgetsAndDo(const Writer &wr,const Widget &w,
					void (Cxx::*memfunc)(const Widget&));
	void TestSubwidgetsAndDo(const Writer &wr,const Widget &w,
		void (Cxx::*memfunc)(const Widget&,const string),const string t);		
	void TestSubwidgetsAndDo(const Writer &wr,const Widget &w,
		void (Cxx::*memfunc)(const Widget&,bool,bool*),bool t,bool *u);		
	void Declare_GH(const Widget &w);
	void InitPointer_GC(const Widget &w);
	void DestroyPointer_GC(const Widget &w);
	void Construct_GC(const Widget &w,bool is_member,bool *first);
	void CustomizeSub_GC(const Widget &w);
	bool TestSubwidgetsForPointer(const Writer &wr,const Widget &w);
	void ConnectSignal_Csub(const Widget &w);
	void ConnectSignal_C(const Widget &w,const string instance="");
	void DefineSignalHandler_C(const Widget &w,const string name_space);
	void DeclareSignalHandler_H(const Widget &w);
	void DeclareSignalHandler_Hsub(const Widget &w);
	void SampleCodeDefinition_C(const Widget &w,const string name_space);
	void SampleCodeCtor_C(const Widget &w);
	void SampleCodeDtor_C(const Widget &w);
	void SampleCodePrivate_H(const Widget &w);
	void SampleCodePublic_H(const Widget &w);
	void SampleCodeMembCtion_Csub(const Widget &w);
	void SampleCodeMembCtion_C(const Widget &w,bool init=false);
public:
	Cxx(Tag *top);
	void WriteTags();
};
