// $Id: Writer.hh,v 1.39 1998/10/09 09:28:22 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "File.hh"
#include "Widget.hh"
#include <vector>
#include <string>
#include "writers/standard.hh"

struct WriterType
{  enum Subwidget 
   { no_Subwidgets, not_Subwidget, IgnoreButAcceptChildren, 
     IgnoreTree, IgnoreButTestChildren };
   enum CodePosition
   { ContainingConstructor, ContainingPrivateMember, ContainingPublicMember,
     ContainingDefinition, ContainingDestructor, ContainingMemberConstruction,

     Constructor, Destructor, PrivateMember, PublicMember, Definition,
     MemberConstruction };

   typedef void (*WriterFunc)(File &f,const Widget &w);
   typedef bool (*SampleCodeFunc)(File &f,const Widget &w,enum CodePosition pos,const string misc);
   typedef void (*ConstructFunc)(File &f,const Widget &w,bool is_member);
   typedef void (*CustomizeFunc)(File &f,const Widget &w,const string instance);
   typedef bool (*TestFunc)(const Widget &w);
   typedef bool (*NeedCtorFunc)(const Widget &w,bool is_member);
   typedef Subwidget (*IsSubWidgetFunc)(const Widget &w,const Widget &child);
   typedef const string (*CbArgsFunc)(const Widget &w,const string signal,string &rettype);

   const char *type;

   // for the type
   TestFunc is_basic;
   WriterFunc include;
   TestFunc is_derived;
   WriterFunc derive;
   
   // parent's class member
   WriterFunc declare_needed;
   WriterFunc declare;
   
   // parent's/own constructor
   ConstructFunc construct;
   WriterFunc construct_pointer;
   WriterFunc destruct_pointer;
   NeedCtorFunc need_construct;

   // parent's constructor
   CustomizeFunc customize;
   
   IsSubWidgetFunc is_subwidget;
   
   SampleCodeFunc sample_code;
   
   CbArgsFunc callback_args;
};

#ifdef WITH_STRUCT_FILLING
#define STRUCT_BASIC(Class,Namespace) \
{ Class,&ReturnTrue,&Namespace::Include,&ReturnFalse, \
	0,0,&Namespace::Declare,&Namespace::Construct,0,0, \
	&Namespace::NeedConstruct,&Namespace::Customize,0,0,\
	&Gtk_Widget::CallbackArgs }
#define STRUCT_BASIC_SAMP(Class,Namespace) \
{ Class,&ReturnTrue,&Namespace::Include,&ReturnFalse, \
	0,0,&Namespace::Declare,&Namespace::Construct,0,0, \
	&Namespace::NeedConstruct,&Namespace::Customize,0, \
	&Namespace::SampleCode, \
	&Gtk_Widget::CallbackArgs }
#define STRUCT_BASIC_NEED_SAMP(Class,Namespace) \
{ Class,&ReturnTrue,&Namespace::Include,&ReturnFalse, \
	0,&Namespace::DeclareNeeded,&Namespace::Declare, \
	&Namespace::Construct,&Namespace::ConstructPointer,&Namespace::DestructPointer, \
	&Namespace::NeedConstruct,&Namespace::Customize,0, \
	&Namespace::SampleCode, \
	&Gtk_Widget::CallbackArgs }
#define STRUCT_BASIC_NEED(Class,Namespace) \
{ Class,&ReturnTrue,&Namespace::Include,&ReturnFalse, \
	0,&Namespace::DeclareNeeded,&Namespace::Declare, \
	&Namespace::Construct,&Namespace::ConstructPointer,&Namespace::DestructPointer, \
	&Namespace::NeedConstruct,&Namespace::Customize,0,0,\
	&Gtk_Widget::CallbackArgs }
#define STRUCT_BASIC_SUBW_SAMP(Class,Namespace) \
{ Class,&ReturnTrue,&Namespace::Include,&ReturnFalse, \
	0,0,&Namespace::Declare,&Namespace::Construct,0,0, \
	&Namespace::NeedConstruct,&Namespace::Customize, \
	&Namespace::IsSubwidget,&Namespace::SampleCode,\
	&Gtk_Widget::CallbackArgs }
#define STRUCT_AMBIG(Class,Namespace) \
{ Class,&Namespace::IsBasic,&Namespace::Include,&ReturnTrue, \
	&Namespace::Derive,&Gtk_Container::DeclareNeeded, \
	&Namespace::Declare,&Namespace::Construct,\
	&StandardWriter::ConstructPointer,&StandardWriter::DestructPointer, \
	&Namespace::NeedConstruct,&Namespace::Customize,0,0,\
	&Gtk_Widget::CallbackArgs }
#define STRUCT_CONTAINER(Class,Namespace) \
{ Class,&ReturnFalse,&Namespace::Include,&ReturnTrue, \
	&Namespace::Derive,&Gtk_Container::DeclareNeeded, \
	&Namespace::Declare,&Namespace::Construct,\
	&StandardWriter::ConstructPointer,&StandardWriter::DestructPointer, \
	&Namespace::NeedConstruct,&Namespace::Customize,0,0,\
	&Gtk_Widget::CallbackArgs }
#define STRUCT_CONTAINER_SAMP(Class,Namespace) \
{ Class,&ReturnFalse,&Namespace::Include,&ReturnTrue, \
	&Namespace::Derive,&Gtk_Container::DeclareNeeded, \
	&Namespace::Declare,&Namespace::Construct, \
	&StandardWriter::ConstructPointer,&StandardWriter::DestructPointer, \
	&Namespace::NeedConstruct,&Namespace::Customize,0, \
	&Namespace::SampleCode,\
	&Gtk_Widget::CallbackArgs }
#define STRUCT_CONTAINER_NEED(Class,Namespace) \
{ Class,&ReturnFalse,&Namespace::Include,&ReturnTrue, \
	&Namespace::Derive,&Namespace::DeclareNeeded,\
	&Namespace::Declare, &Namespace::Construct, \
	&Namespace::ConstructPointer,&Namespace::DestructPointer, \
	&Namespace::NeedConstruct,&Namespace::Customize,0,0,\
	&Gtk_Widget::CallbackArgs }
#define STRUCT_CONTAINER_NEED_SAMP(Class,Namespace) \
{ Class,&ReturnFalse,&Namespace::Include,&ReturnTrue, \
	&Namespace::Derive,&Namespace::DeclareNeeded, \
	&Namespace::Declare,&Namespace::Construct, \
	&Namespace::ConstructPointer,&Namespace::DestructPointer, \
	&Namespace::NeedConstruct,&Namespace::Customize,0, \
	&Namespace::SampleCode,\
	&Gtk_Widget::CallbackArgs }
#define STRUCT_CONTAINER_SUBW(Class,Namespace) \
{ Class,&ReturnFalse,&Namespace::Include,&ReturnTrue, \
	&Namespace::Derive,&Gtk_Container::DeclareNeeded,\
	&Namespace::Declare,&Namespace::Construct, \
	&StandardWriter::ConstructPointer,&StandardWriter::DestructPointer, \
	&Namespace::NeedConstruct,&Namespace::Customize, \
	&Namespace::IsSubwidget, 0,\
	&Gtk_Widget::CallbackArgs }
#endif

// 2do: include widget into Write so it's a member
class Writer
{  static const WriterType writers[];
   static const int maxindex;
   int index;
   const Widget &widget;
   static vector<string> _warned_types;
   // whether widget is compound type
   bool compound;
public:
   bool IsCompound() throw()
   {  return compound; }
   Writer(const Widget &w) throw();
   bool valid() const
   {  return writers[index].type!=0; }
   void Declare(File &f) const;
   void DeclareNeeded(File &f) const;
   void Construct(File &f,bool is_member) const;
   void ConstructPointer(File &f) const;
   void DestructPointer(File &f) const;
   bool NeedConstruct(bool is_member) const;
   void Customize(File &f,const string instance,bool nested) const;
   void Derive(File &f) const;
   bool IsDerived() const;
   void Include(File &f) const;
   bool IsBasic() const;
   WriterType::Subwidget IsSubwidget(const Widget &child) const;
   bool SampleCode(File &f,WriterType::CodePosition pos,const string misc) const;
   const string CallbackArgs(const string signal,string &rettype) const;
};
