// $Id: adjustment.cc,v 1.6 1998/09/24 13:19:43 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"

void Gtk_Adjustment::Include(File &f,const Widget &w)
{  f.include("gtk--/adjustment.h");
}

void Gtk_Adjustment::Declare(File &f,const Widget &w)
{  StandardWriter::Declare(f,w,"Gtk_Adjustment");
}

void Gtk_Adjustment::Construct(File &f,const Widget &w,bool is_member)
{  Construct_hv(f,w,is_member,'h');
}

void Gtk_Adjustment::Construct_hv(File &f,const Widget &w,bool is_member,char h_or_v)
{  int value=w.getInt(h_or_v+string("value"),0);
   int lower=w.getInt(h_or_v+string("lower"),0);
   int upper=w.getInt(h_or_v+string("upper"),100);
   int step=w.getInt(h_or_v+string("step"),1);
   int page=w.getInt(h_or_v+string("page"),10);
   int page_size=w.getInt(h_or_v+string("page_size"),10);
      
   f << StandardWriter::ConstructName(f,w,is_member,"Gtk_Adjustment")
     << "(" << value << ", " << lower << ", " << upper << ", " << step
     << ", " << page << ", " << page_size << ")";
}

void Gtk_Adjustment::ConstructPointer(File &f,const Widget &w)
{  ConstructPointer_hv(f,w,'h');
}

void Gtk_Adjustment::ConstructPointer_hv(File &f,const Widget &w,char h_or_v)
{  f << "\t";
   Construct_hv(f,w,false,h_or_v);
   f << ";\n";
}

void Gtk_Adjustment::DestructPointer(File &f,const Widget &w)
{  f << "\tdelete " << f.InstanceName(w.Name()) << ";\n";
}

bool Gtk_Adjustment::NeedConstruct(const Widget &w,bool is_member)
{  return true;
}

void Gtk_Adjustment::Customize(File &f,const Widget &w,const string instance)
{  
}

void Gtk_Adjustment::DeclareNeeded(File &f,const Widget &w)
{  
}
