// $Id: frame.cc,v 1.4 1998/09/24 13:19:45 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"

void Gtk_Frame::Include(File &f,const Widget &w)
{  f.include("gtk--/frame.h");
   Gtk_Container::Include(f,w);
}

void Gtk_Frame::Declare(File &f,const Widget &w)
{  StandardWriter::Declare(f,w,"Gtk_Frame");
}

void Gtk_Frame::Derive(File &f,const Widget &w)
{  f << "Gtk_Frame";
}

void Gtk_Frame::Construct(File &f,const Widget &w,bool is_member)
{  f << StandardWriter::ConstructName(f,w,is_member,"Gtk_Frame");
   if (w.hasTag("label"))
      f << "(\"" << w.getString("label","") << "\")";
   else f << "()";
}

bool Gtk_Frame::NeedConstruct(const Widget &w,bool is_member)
{  return w.hasTag("label");
}

void Gtk_Frame::Customize(File &f,const Widget &w,const string instance)
{  Gtk_Container::Customize(f,w,instance);
   float label_xalign(w.getFloat("label_xalign",0));
   float label_yalign(w.getFloat("label_yalign",0));
   string shadow_type(w.getString("shadow_type","GTK_SHADOW_ETCHED_IN"));
   f << instance << "set_label_align(" << label_xalign 
   	<< ", " << label_yalign << ");\n\t";
   f << instance << "set_shadow_type(" << shadow_type << ");\n\t";
   StandardWriter::AddChildren(f,w,instance);
}
