// $Id: menubar.cc,v 1.19 1998/10/09 14:28:31 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

// the whole file became an ugly hack since Item/MenuFactory can't fill an
// existing Gtk_MenuBar, and we use fake pointer stuff on sample code 
// generation

#include "writers.hh"
#include "../Configuration.hh"

void Gtk_MenuBar::Include(File &f,const Widget &w)
{  f.include("gtk--/menubar.h");
   if (Configuration.sample_code && !w.hasChildren())
   {  ((Widget)w).markPointer(); // this is an _ugly_ hack ... but it's the only way ?

      if (Configuration.gtk11)
      {  f.include("gtk--/accelgroup.h");
         f.include("gtk--/itemfactory.h");
      }
      else
         f.include("gtk--/menufactory.h");
   }
}

void Gtk_MenuBar::Declare(File &f,const Widget &w)
{  StandardWriter::Declare(f,w,"Gtk_MenuBar");
}

void Gtk_MenuBar::Derive(File &f,const Widget &w)
{  f << "Gtk_MenuBar";
}

void Gtk_MenuBar::Construct(File &f,const Widget &w,bool is_member)
{  if (!Configuration.sample_code || w.hasChildren())
   {  f << StandardWriter::ConstructName(f,w,is_member,"Gtk_MenuBar");
      f << "()";
   }
}

bool Gtk_MenuBar::NeedConstruct(const Widget &w,bool is_member)
{  return false;
}

void Gtk_MenuBar::DeclareNeeded(File &f,const Widget &w)
{  if (!Configuration.sample_code  || w.hasChildren()) return;
   const string name(f.InstanceName(w.Name()));
   if (Configuration.gtk11)
   {  f << "Gtk_AccelGroup *" << name << "_accel;\n";
      f << "\tGtk_ItemFactory *" << name << "_fact;";
   }
   else
      f << "Gtk_MenuFactory *" << name << "_fact;";
}

void Gtk_MenuBar::ConstructPointer(File &f,const Widget &w)
{  if (!Configuration.sample_code || w.hasChildren())
      f << f.InstanceName(w.Name()) << " = new Gtk_MenuBar()";
   else
   {  const string name(f.InstanceName(w.Name()));
      if (Configuration.gtk11)
      {  f << "\t" << name << "_accel = new Gtk_AccelGroup();\n";
         f << "\t" << name << "_fact = new Gtk_ItemFactory(GTK_TYPE_MENU_BAR, \"<" << name    
                    << ">\", " << name << "_accel);\n";
         f << "\textern const GtkItemFactoryEntry "<< name << "_items[];\n"
      	      "\textern const int "<< name <<"_nitems;\n\t";
         f << name << "_fact.create_items("<< name << "_nitems, "
                << name << "_items, "
            	<< name << "_fact);\n\t";
         f << "//" << name << "_accel->attach(<Window>);\n\t";
         f << name << " = " << name << "_fact->get_menubar_widget();\n";
      }
      else 
      {  f << "\t" << name << "_fact = new Gtk_MenuFactory(GTK_MENU_FACTORY_MENU_BAR);\n";
         f << "\textern GtkMenuEntry "<< name << "_items[];\n\t"
      	      "extern const int "<< name << "_nitems;\n\t";
         f << name << "_fact->add_entries("<< name << "_items, "
                << name << "_nitems);\n\t";
         f << name << " = " << name << "_fact->get_menubar_widget();\n";
      }
   }
}

void Gtk_MenuBar::DestructPointer(File &f,const Widget &w)
{  if (!Configuration.sample_code || w.hasChildren())
      f << "\tdelete " << f.InstanceName(w.Name()) << ";\n";
   else
   {  f << "\tdelete " << f.InstanceName(w.Name()) << "_fact;\n";
      if (Configuration.gtk11)
         f << "\tdelete " << f.InstanceName(w.Name()) << "_accel;\n";
      f << "\t" << f.InstanceName(w.Name()) << " = 0;\n";
   }
}

void Gtk_MenuBar::Customize(File &f,const Widget &w,const string instance)
{  Gtk_Widget::Customize(f,w,instance);
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  if ((*i).Class()=="Placeholder") continue;
      f << instance << "append(" << f.Pointer((*i)) << ");\n\t";
   }
}

bool Gtk_MenuBar::SampleCode(File &f,const Widget &w,enum WriterType::CodePosition pos,const string misc)
{  const string name(f.InstanceName(w.Name()));

   if (w.hasChildren()) return false;
   if (Configuration.gtk11) switch(pos)
   {  case WriterType::ContainingDefinition:
         {  f << 
   "void "<< name << "_def_cb(GtkWidget *widget, gpointer data)\n"
   "{  cout << \""<< name << "_def_cb with data=\" << data << \"\\n\";\n"
   "}\n\n";
            f << 
   "extern const GtkItemFactoryEntry "<< name <<"_items[] =\n"
   "{{ \"/_File\",\t0,\t&"<<name<<"_def_cb,\t0,\t\"<Branch>\" },\n"
   " { \"/File/tearoff1\",\t0,\t&"<<name<<"_def_cb,\t0,\t\"<Tearoff>\" },\n"
   " { \"/File/_New\",\t\"<control>N\",\t&"<<name<<"_def_cb,\t0 },\n"
   " { \"/File/_Open\",\t\"<control>O\",\t&"<<name<<"_def_cb,\t0 },\n"
   " { \"/File/_Save\",\t\"<control>S\",\t&"<<name<<"_def_cb,\t0 },\n"
   " { \"/File/Save _As...\",\t0,\t&"<<name<<"_def_cb,\t0 },\n"
   " { \"/File/sep1\",\t0,\t&"<<name<<"_def_cb,\t0,\t\"<Separator>\" },\n"
   " { \"/File/_Quit\",\t\"<control>Q\",\t&"<<name<<"_def_cb,\t0 },\n"
   "\n"
   " { \"/_Preferences\",\t0,\t&"<<name<<"_def_cb,\t0,\t\"<Branch>\" },\n"
   " { \"/_Preferences/_Color\",\t0,\t&"<<name<<"_def_cb,\t0,\t\"<Branch>\" },\n"
   " { \"/_Preferences/Color/_Red\",\t0,\t&"<<name<<"_def_cb,\t0,\t\"<RadioItem>\" },\n"
   " { \"/_Preferences/Color/_Green\",\t0,\t&"<<name<<"_def_cb,\t0,\t\"<RadioItem>\" },\n"
   " { \"/_Preferences/Color/_Blue\",\t0,\t&"<<name<<"_def_cb,\t0,\t\"<RadioItem>\" },\n"
   " { \"/_Preferences/_Shape\",\t0,\t&"<<name<<"_def_cb,\t0,\t\"<Branch>\" },\n"
   " { \"/_Preferences/Shape/_Square\",\t0,\t&"<<name<<"_def_cb,\t0,\t\"<RadioItem>\" },\n"
   " { \"/_Preferences/Shape/_Rectangle\",\t0,\t&"<<name<<"_def_cb,\t0,\t\"<RadioItem>\" },\n"
   " { \"/_Preferences/Shape/_Oval\",\t0,\t&"<<name<<"_def_cb,\t0,\t\"<RadioItem>\" },\n"
   "\n"
   " { \"/_Help\",\t0,\t&"<<name<<"_def_cb,\t0,\t\"<LastBranch>\" },\n"
   " { \"/Help/_About\",\t0,\t&"<<name<<"_def_cb,\t0 },\n"
   "};\n"
   "\n"
   "extern const int "<<name<<"_nitems = sizeof ("<<name<<"_items) / sizeof ("<<name<<"_items[0]);\n"
   "\n";
   	 }
   	 break;
      default: break;
   }
   else switch(pos)
   {  case WriterType::ContainingDefinition:
         {  f << 
   "void "<< name << "_def_cb(GtkWidget *widget, gpointer data)\n"
   "{  cout << \""<< name << "_def_cb with data=\" << (const char*)data << \"\\n\";\n"
   "}\n\n";
            f << 
   "GtkMenuEntry "<< name <<"_items[] =\n"
   "{{ \"File/New\",\t\"<control>N\",\t&"<<name<<"_def_cb,\t\"New\" },\n"
   " { \"File/Open\",\t\"<control>O\",\t&"<<name<<"_def_cb,\t\"Open\" },\n"
   " { \"File/Save\",\t\"<control>S\",\t&"<<name<<"_def_cb,\t0 },\n"
   " { \"File/Save As...\",\t0,\t&"<<name<<"_def_cb,\t\"Save as\" },\n"
   " { \"File/<separator>\",\t0,\t&"<<name<<"_def_cb,\t0 },\n"
   " { \"File/Quit\",\t\"<control>Q\",\t&"<<name<<"_def_cb,\t0 },\n"
   "\n"
   " { \"Help/About\",\t0,\t&"<<name<<"_def_cb,\t0 },\n"
   "};\n"
   "\n"
   "extern const int "<<name<<"_nitems = sizeof ("<<name<<"_items) / sizeof ("<<name<<"_items[0]);\n"
   "\n";
   	 }
   	 break;
      default: break;
   }
   return false;
}
