// $Id: paned.cc,v 1.5 1998/09/24 13:19:46 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"

void Gtk_Paned::Include(File &f,const Widget &w)
{  f.include("gtk--/paned.h");
   Gtk_Container::Include(f,w);
}

void Gtk_Paned::Declare(File &f,const Widget &w)
{  StandardWriter::Declare(f,w,w.Class()[3]=='H' ?"Gtk_HPaned":"Gtk_VPaned");
}

void Gtk_Paned::Derive(File &f,const Widget &w)
{  f << "Gtk_Paned";
}

void Gtk_Paned::Construct(File &f,const Widget &w,bool is_member)
{  f << StandardWriter::ConstructName(f,w,is_member,w.Class()[3]=='H' ?"Gtk_HPaned":"Gtk_VPaned");
   f << "()";
}

bool Gtk_Paned::NeedConstruct(const Widget &w,bool is_member)
{  return false;
}

void Gtk_Paned::Customize(File &f,const Widget &w,const string instance)
{  Gtk_Container::Customize(f,w,instance);
   int handle_size(w.getInt("handle_size",10));
   int gutter_size(w.getInt("gutter_size",6));
   f << instance << "handle_size(" << handle_size << ");\n\t";
   f << instance << "gutter_size(" << gutter_size << ");\n\t";
   // add1, add2
   Widget::const_iterator i=w.begin();
   if (i!=w.end())
   {  if ((*i).Class()=="Placeholder") return; // dirty hack
      f << instance << "add1(" << f.Pointer(*i) << ");\n\t";
   }
   ++i;
   if (i!=w.end())
   {  if ((*i).Class()=="Placeholder") return; // dirty hack
      f << instance << "add2(" << f.Pointer(*i) << ");\n\t";
   }
   ++i;
   if (i!=w.end()) 
      cerr << "Paned Window " << w.Name() << " has more than 2 children\n";
}
