// $Id: range.cc,v 1.4 1998/09/24 13:19:47 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"

void Gtk_Range::Include(File &f,const Widget &w)
{  f.include("gtk--/range.h");
}

void Gtk_Range::DeclareNeeded(File &f,const Widget &w)
{  Gtk_Adjustment::Declare(f,Widget(w,f.InstanceName(w.Name())+"_adj"));
}

void Gtk_Range::Declare(File &f,const Widget &w)
{  StandardWriter::Declare(f,w,"Gtk_Range");
}

void Gtk_Range::Construct(File &f,const Widget &w,bool is_member)
{  cerr << "Gtk_Range::Construct: there is no constructor for Gtk_Range!\n";
   const Widget adj(w,f.InstanceName(w.Name())+"_adj");
   if (is_member)
   {  Gtk_Adjustment::Construct(f,adj,true);
      f << ", "
        << StandardWriter::ConstructName(f,w,is_member,"Gtk_Range")
        << "(&" << (f.InstanceName(w.Name())+"_adj") << ")";
   }
   else
   {  f << StandardWriter::ConstructName(f,w,is_member,"Gtk_Range") << "()";
      Gtk_Adjustment::Construct(f,adj,true);
   }
}

void Gtk_Range::ConstructPointer(File &f,const Widget &w)
{  Gtk_Adjustment::ConstructPointer(f,Widget(w,f.InstanceName(w.Name())+"_adj"));
   f << ";\n\t" << f.InstanceName(w.Name()) << " = new Gtk_Range"
     << "(" << (f.InstanceName(w.Name())+"_adj") << ")";
}


void Gtk_Range::DestructPointer(File &f,const Widget &w)
{  f << "\tdelete " << f.InstanceName(w.Name()) << ";\n";
   Gtk_Adjustment::DestructPointer(f,Widget(w,f.InstanceName(w.Name())+"_adj"));
}

bool Gtk_Range::NeedConstruct(const Widget &w,bool is_member)
{  return false; // we can't construct
}

void Gtk_Range::Customize(File &f,const Widget &w,const string instance)
{  Gtk_Widget::Customize(f,w,instance);
   string update_policy=w.getString("update_policy","GTK_UPDATE_ALWAYS");
   if (update_policy!="GTK_UPDATE_ALWAYS")
      f << instance << "set_update_policy(" << update_policy << ");\n\t";
   // find out if we must set Adjustment and do so
}
