// $Id: ruler.cc,v 1.2 1998/09/24 13:19:47 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"

void Gtk_Ruler::Include(File &f,const Widget &w)
{  f.include("gtk--/ruler.h");
}

void Gtk_Ruler::Declare(File &f,const Widget &w)
{  StandardWriter::Declare(f,w,w.Class()[3]=='H' ?"Gtk_HRuler":"Gtk_VRuler");
}

void Gtk_Ruler::Construct(File &f,const Widget &w,bool is_member)
{  f << StandardWriter::ConstructName(f,w,is_member,w.Class()[3]=='H' ?"Gtk_HRuler":"Gtk_VRuler") 
     << "()";
}

bool Gtk_Ruler::NeedConstruct(const Widget &w,bool is_member)
{  return false;
}

void Gtk_Ruler::Customize(File &f,const Widget &w,const string instance)
{  Gtk_Widget::Customize(f,w,instance);
   string metric=w.getString("metric","GTK_PIXELS");
   f << instance << "set_metric(" << metric << ");\n\t";

   float lower=w.getFloat("lower",0);
   float upper=w.getFloat("upper",10);
   float position=w.getFloat("position",5);
   float max_size=w.getFloat("max_size",10);
   f << instance << "set_range(" << lower << ", " << upper << ", "
     << position << ", " << max_size << ");\n\t";
}
