// $Id: scrolledwindow.cc,v 1.1 1998/09/24 13:57:03 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"

void Gtk_ScrolledWindow::Include(File &f,const Widget &w)
{  f.include("gtk--/scrolledwindow.h");
   Gtk_Container::Include(f,w);
}

void Gtk_ScrolledWindow::Declare(File &f,const Widget &w)
{  StandardWriter::Declare(f,w,"Gtk_ScrolledWindow");
}

void Gtk_ScrolledWindow::Derive(File &f,const Widget &w)
{  f << "Gtk_ScrolledWindow";
}

void Gtk_ScrolledWindow::Construct(File &f,const Widget &w,bool is_member)
{  f << StandardWriter::ConstructName(f,w,is_member,"Gtk_ScrolledWindow")
     << "()";
}

bool Gtk_ScrolledWindow::NeedConstruct(const Widget &w,bool is_member)
{  return false;
}

void Gtk_ScrolledWindow::Customize(File &f,const Widget &w,const string instance)
{  Gtk_Container::Customize(f,w,instance);
//   string shadow_type(w.getString("shadow_type","GTK_SHADOW_NONE"));
//   and what to do with this?
//   f << instance << "set_shadow_type(" << shadow_type << ");\n\t";
   string hscrollbar_policy(w.getString("hscrollbar_policy","GTK_POLICY_AUTOMATIC"));
   string vscrollbar_policy(w.getString("vscrollbar_policy","GTK_POLICY_AUTOMATIC"));
   f << instance << "set_policy(" << hscrollbar_policy
   	<< ", " << vscrollbar_policy << ");\n\t";
   string hupdate_policy(w.getString("hupdate_policy","GTK_UPDATE_CONTINUOUS"));
   f << instance << "hscrollbar.set_update_policy(" << hupdate_policy << ");\n\t";
   string vupdate_policy(w.getString("vupdate_policy","GTK_UPDATE_CONTINUOUS"));
   f << instance << "vscrollbar.set_update_policy(" << vupdate_policy << ");\n\t";
   StandardWriter::AddChildren(f,w,instance);
}
