// $Id: togglebutton.cc,v 1.8 1998/09/24 13:19:50 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"

void Gtk_ToggleButton::Include(File &f,const Widget &w)
{  f.include("gtk--/togglebutton.h");
}

void Gtk_ToggleButton::Declare(File &f,const Widget &w)
{  StandardWriter::Declare(f,w,"Gtk_ToggleButton");
}

void Gtk_ToggleButton::Construct(File &f,const Widget &w,bool is_member)
{  // 2do if !found("label")
   f << StandardWriter::ConstructName(f,w,is_member,"Gtk_ToggleButton");
   f << "(\"" << f.CString(w.getString("label"))
	<< "\")";
}

bool Gtk_ToggleButton::NeedConstruct(const Widget &w,bool is_member)
{  return w.hasTag("label");
}

void Gtk_ToggleButton::Customize(File &f,const Widget &w,const string instance)
{  Gtk_Button::Customize(f,w,instance);
   bool draw_indicator=w.getBool("draw_indicator",true);
   if (!draw_indicator)
      f << instance << "set_mode(" << (draw_indicator?"true":"false") << ");\n\t";
   bool active=w.getBool("active",true);
   if (!draw_indicator)
      f << instance << "set_state(" << (active?"true":"false") << ");\n\t";
}
