.TH sane-microtek2 5 "30 May 1998"
.IX sane-microtek2
.SH NAME
sane-microtek2 - SANE backend for Microtek scanners with SCSI-II interface
.SH DESCRIPTION
The
.B sane-microtek2
library implements a SANE (Scanner Access Now Easy) backend that
provides access to some Microtek scanners with a SCSI-II interface.
This backend should be considered alpha.
.br 
There exists a different backend for Microtek scanners with a SCSI-I
interface. Refer to sane-microtek(5) for details. At present, the following
scanners are known positively to work with this backend:
.PP
.RS
Vendor     Product id:     Remark:
.br
--------   --------------  -----------
.br
Microtek   ScanMaker 630   all modes ok
.br
Vobis      HighScan        all modes ok
.RE
.PP
If you own a Microtek scanner with SCSI-II interface other than the ones
listed above, it may or may not work with SANE!
If the scanner gives enough information to the driver,
there is only a warning printed and you may continue, BUT AT
YOUR OWN RISK! If the scanner does not give enough information
then it will not work and an error-message is printed!

.SH "FRONTEND OPTIONS"
This backend dynamically enables the options for the frontend,
that are supported by the scanner in dependence of the scanning-mode
and other options. Not supported options are disabled.
.PP
The following otions are supported by the Microtek2-driver:
.PP
Color, grayscale, halftone and lineart scans.
.PP
Highlight, midtone, shadow, contrast, brightness, scalar
gamma correction, threshold (dependent of the scan mode)

.SH "DEVICE NAMES"
This backend expects device names of the form:
.PP
.RS
.IR special
.RE
.PP
Where
.I special
is the UNIX path-name for the special device that corresponds to the
scanner.  The special device name must be a generic SCSI device or a
symlink to such a device.  Under Linux, such a device name could be
.IR /dev/sga
or
.IR /dev/sge ,
for example.
.SH CONFIGURATION
The configuration file for this backend resides in
.IR @CONFIGDIR@/microtek2.conf .
Its contents is a list of device names that correspond to Microtek
scanners with SCSI-II interface. Empty lines and lines starting with 
a hash mark (#) are ignored.
.PP
The configuration file may contain a line "option dump n".
.PP
If n=1 the contents of the command blocks
and the results for the INQUIRY and READ SCANNER ATTRIBUTES command are 
printed to stderr.
.PP
If n=2 the contents of the command blocks for all other SCSI commands are
printed to stderr, too. If n=3 the contents of the gamma table is 
printed, too. If n=4 all scan data are additionally printed to stderr.
.PP
A sample configuration file is shown below:
.PP
.RS
option dump 1
.br
/dev/scanner
.br
# this is a comment
.br
/dev/sge
.RE

This backend also supports the new configuration file format which makes
it easier to detect scanners under Linux. If you have only one scanner it
would be best to use the configuration file for this backend, that
is distributed with SANE. This file is shown below:
.PP
.RS
option dump 1
.br
scsi * * Scanner
.RE

In this case all SCSI-Scanners should be detected automatically.

.SH FILES
.TP
.I @CONFIGDIR@/microtek2.conf
The backend configuration file.
.TP
.I @LIBDIR@/libsane-microtek2.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane-microtek2.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.SH ENVIRONMENT
.TP
.B SANE_DEBUG_MICROTEK2
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend.  E.g.,
a value of 128 requests all debug output to be printed.  Smaller
levels reduce verbosity. To see error messages on stderr set
SANE_DEBUG_MICROTEK2 to 1 (Remark: The whole debugging levels should
be better revised).
.br
E.g. just say:
.br
export SANE_DEBUG_MICROTEK2=128
.SH "SEE ALSO"
sane-scsi(5)
.SH AUTHOR
Bernd Schroeder
