#ifndef _SEQPTRN_

#define _SEQPTRN_

#ifndef _NCBI_Seqres_
#include <objres.h>
#endif

#ifndef _NCBI_Seq_
#include <objseq.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* defines */

#define NA_PATTERN           0
#define NA_PATTERN_HR        1
#define NA_PATTERN_ATAAG     2
#define NA_PATTERN_P_ATG     3
#define NA_PATTERN_P_K_ATG   4

#define AA_PATTERN           100

/* structures */

typedef struct compilepattern
{
  Int4    min;
  Int4    max;
  Char    res[32];
  struct  compilepattern PNTR next;
} ComPat, PNTR ComPatPtr;

/* prototypes */

extern ComPatPtr ComPatFree (ComPatPtr headcpp);
extern ComPatPtr InvertPattern (ComPatPtr cpp);
extern ComPatPtr CompilePattern (CharPtr pattern, Int2 moltype);
extern void CleanPattern  (CharPtr inbuff);
extern Boolean ResidueMatch (CharPtr seq, ComPatPtr cpp, Int2 moltype,
                             Int4Ptr patlen);

extern SeqGraphPtr PatternSeq (BioseqPtr bsp, Int4Ptr window,
                               Uint1 patterntype, SeqGraphPtr sgp,
                               CharPtr pattern, Int2 moltype);

#ifdef __cplusplus
}
#endif

#endif
