/*   gpattern.c
* ===========================================================================
*
*                            PUBLIC DOMAIN NOTICE
*               National Center for Biotechnology Information
*
*  This software/database is a "United States Government Work" under the
*  terms of the United States Copyright Act.  It was written as part of
*  the author's official duties as a United States Government employee and
*  thus cannot be copyrighted.  This software/database is freely available
*  to the public for use. The National Library of Medicine and the U.S.
*  Government have not placed any restriction on its use or reproduction.
*
*  Although all reasonable efforts have been taken to ensure the accuracy
*  and reliability of the software and data, the NLM and the U.S.
*  Government do not and cannot warrant the performance or results that
*  may be obtained by using this software or data. The NLM and the U.S.
*  Government disclaim all warranties, express or implied, including
*  warranties of performance, merchantability or fitness for any particular
*  purpose.
*
*  Please cite the author in any work or product based on this material.
*
* ===========================================================================
*
* File Name:  gpattern.c
*
* Author:  Epstein
*
* Version Creation Date:   1/4/94
*
* $Revision: 6.0 $
*
* File Description:
*       Generic pattern matching
*
* Modifications:
* --------------------------------------------------------------------------
* Date     Name        Description of modification
* -------  ----------  -----------------------------------------------------
*
* $Log: gpattern.c,v $
* Revision 6.0  1997/08/25 18:53:19  madden
* Revision changed to 6.0
*
* Revision 1.2  1996/06/21 14:10:55  epstein
* add boilerplate and run 'indent'
*
*
* ==========================================================================
*/

#include <ncbi.h>
#include <regex.h>
#include <gpattern.h>

static void
InitPatternMatch (void)
{
    static          Boolean inited = FALSE;

    if (!inited) {
	inited = TRUE;
	re_syntax_options = RE_SYNTAX_SED;
    }
}

/* returns a compiled pattern given a SED-style regular expression */
CompiledPattern LIBCALL 
CompilePattern (CharPtr pattern)
{
    struct patstuff *pts;

    InitPatternMatch ();

    pts = (struct patstuff *) MemNew (sizeof (*pts));

    re_set_registers (&pts->patbuf, &pts->regs, 0, 0, 0);
    pts->patbuf.translate = NULL;
    pts->patbuf.fastmap = 0;
    pts->patbuf.buffer = NULL;
    pts->patbuf.allocated = 0;

    if (re_compile_pattern (pattern, StrLen (pattern), &pts->patbuf) != 0) {
	return NULL;
    }
    return ((CompiledPattern) pts);
}


void LIBCALL 
FreeCompiledPattern (CompiledPattern compPat)
{
    struct patstuff *pts = (struct patstuff *) compPat;

    regfree (&pts->patbuf);
    MemFree (pts);
}
