/* AMCL - A simple Mud CLient
 * Copyright (C) 1998 Robin Ericsson <lobbin@lobbin.ml.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <glib.h>

#include "amcl.h"
#include "config.h"

/*
 * Local Functions
 */
gushort convert_color (guint color);
void    extract_color (GdkColor *color,
                       guint red,
                       guint green,
                       guint blue);

/*
 * Global Variables
 */
GtkWidget *text_field;
GtkWidget *text_entry;
GtkWidget *entry_host;
GtkWidget *entry_port;
GtkWidget *menu_main_wizard;
GtkWidget *menu_main_connect;
GtkWidget *menu_main_disconnect;
GtkWidget *menu_option_prefs;
GtkWidget *menu_option_alias;

/*
 * Colors...
 */
GdkColormap *cmap;
GdkColor color_white;
GdkColor color_black;
GdkColor color_blue;
GdkColor color_green;
GdkColor color_red;
GdkColor color_brown;
GdkColor color_purple;
GdkColor color_orange;
GdkColor color_yellow;
GdkColor color_lightgreen;
GdkColor color_cyan;
GdkColor color_lightcyan;
GdkColor color_lightblue;
GdkColor color_pink;
GdkColor color_grey;
GdkColor color_lightgrey;

GdkFont  *font_normal;
GdkFont  *font_bold;

/* from bezerk */
gushort convert_color (guint c)
{
    if ( c == 0 )
        return 0;
    c *= 257;

    return (c > 0xffff) ? 0xffff : c;
}

/* from bezerk */
void extract_color (GdkColor *color, guint red, guint green, guint blue)
{
    color->red   = convert_color (red);
    color->green = convert_color (green);
    color->blue  = convert_color (blue);
}

/* from bezerk */
void init_colors ()
{
    cmap = gdk_colormap_get_system ();
    
    extract_color(&color_white, 255, 255, 255);
    if (!gdk_color_alloc(cmap, &color_white)) {
        g_error("couldn't allocate color");
    }

    extract_color(&color_black, 0, 0, 0);
    if (!gdk_color_alloc(cmap, &color_black)) {
        g_error("couldn't allocate color");
    }

    extract_color(&color_blue, 0, 100, 255);
    if (!gdk_color_alloc(cmap, &color_blue)) {
        g_error("couldn't allocate color");
    }

    extract_color(&color_green, 0, 255, 0);
    if (!gdk_color_alloc(cmap, &color_green)) {
        g_error("couldn't allocate color");
    }

    extract_color(&color_red, 255, 0, 0);
    if (!gdk_color_alloc(cmap, &color_red)) {
        g_error("couldn't allocate color");
    }

    extract_color(&color_brown, 165, 42, 42);
    if (!gdk_color_alloc(cmap, &color_brown)) {
        g_error("couldn't allocate color");
    }

    extract_color(&color_purple, 160, 32, 240);
    if (!gdk_color_alloc(cmap, &color_purple)) {
        g_error("couldn't allocate color");
    }

    extract_color(&color_orange, 255, 165, 0);
    if (!gdk_color_alloc(cmap, &color_orange)) {
        g_error("couldn't allocate color");
    }

    extract_color(&color_yellow, 255, 255, 0);
    if (!gdk_color_alloc(cmap, &color_yellow)) {
        g_error("couldn't allocate color");
    }

    extract_color(&color_lightgreen, 144, 238, 144);
    if (!gdk_color_alloc(cmap, &color_lightgreen)) {
        g_error("couldn't allocate color");
    }

    extract_color(&color_cyan, 0, 255, 255);
    if (!gdk_color_alloc(cmap, &color_cyan)) {
        g_error("couldn't allocate color");
    }

    extract_color(&color_lightcyan, 224, 255, 255);
    if (!gdk_color_alloc(cmap, &color_lightcyan)) {
        g_error("couldn't allocate color");
    }

    extract_color(&color_lightblue, 173, 216, 230);
    if (!gdk_color_alloc(cmap, &color_lightblue)) {
        g_error("couldn't allocate color");
    }

    extract_color(&color_pink, 255, 192, 203);
    if (!gdk_color_alloc(cmap, &color_pink)) {
        g_error("couldn't allocate color");
    }

    extract_color(&color_grey, 190, 190, 190);
    if (!gdk_color_alloc(cmap, &color_grey)) {
        g_error("couldn't allocate color");
    }

    extract_color(&color_lightgrey, 211, 211, 211);
    if (!gdk_color_alloc(cmap, &color_lightgrey)) {
        g_error("couldn't allocate color");
    }

    font_normal = gdk_font_load ("fixed");
    font_bold   = gdk_font_load ("fixed-bold");
}

void close_window (GtkWidget *widget, gpointer data)
{
    gtk_widget_destroy (GTK_WIDGET (data));
}

void destroy (GtkWidget *widget)
{
    gtk_main_quit ();
}

void connect_window (GtkWidget *widget, gpointer data)
{
    GtkWidget *window;
    GtkWidget *label;
    GtkWidget *vbox;
    GtkWidget *hbox, *hbox2, *hbox3;
    GtkWidget *button;
    GtkWidget *button_close;
    GtkWidget *separator;

    if ( connected )
    {
        textfield_add ("\n*** Already connected!\n", MESSAGE_ERR);
        return;
    }

    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title (GTK_WINDOW (window),"Connect...");

    vbox = gtk_vbox_new (FALSE, 5);
    gtk_container_border_width (GTK_CONTAINER (vbox), 5);
    gtk_container_add (GTK_CONTAINER (window), vbox);
    gtk_widget_show (vbox  );
    
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (vbox), hbox);
    gtk_widget_show (hbox  );

    label = gtk_label_new ("Host:");
    gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, FALSE, 5);
    gtk_widget_show (label);

    entry_host = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (hbox), entry_host, FALSE, FALSE, 0);
    gtk_widget_show (entry_host);

    hbox2 = gtk_hbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (vbox), hbox2);
    gtk_widget_show (hbox2);

    label = gtk_label_new ("Port:");
    gtk_box_pack_start (GTK_BOX (hbox2), label, TRUE, FALSE, 5);
    gtk_widget_show (label);

    entry_port = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (hbox2), entry_port, FALSE, FALSE, 0);
    gtk_widget_show (entry_port);
    
    separator = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (vbox), separator, FALSE, TRUE, 5);
    gtk_widget_show (separator);
    
    hbox3 = gtk_hbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (vbox), hbox3);
    gtk_widget_show (hbox3);
    
    button       = gtk_button_new_with_label (" connect ");
    button_close = gtk_button_new_with_label ("  close  ");
    gtk_signal_connect (GTK_OBJECT (button), "clicked",
                        GTK_SIGNAL_FUNC (make_connection), NULL );
    gtk_signal_connect (GTK_OBJECT (button), "clicked",
                        GTK_SIGNAL_FUNC (close_window), window);
    gtk_signal_connect (GTK_OBJECT (button_close), "clicked",
                        GTK_SIGNAL_FUNC (close_window), window);
    gtk_box_pack_start (GTK_BOX (hbox3), button, TRUE, TRUE, 5);
    gtk_box_pack_start (GTK_BOX (hbox3), button_close, TRUE, TRUE, 5);
    gtk_widget_show (button);
    gtk_widget_show (button_close);

    if ( port != NULL && host != NULL )
    {
        gtk_entry_set_text ((GtkEntry *) entry_host, host);
        gtk_entry_set_text ((GtkEntry *) entry_port, port);
    }
    gtk_widget_show (window);
}

void about_window (GtkWidget *widget, gpointer data)
{
    GtkWidget *label;
    GtkWidget *button;
    GtkWidget *main_box;
    GtkWidget *box2;
    GtkWidget *a_window;
    GtkWidget *separator;

    a_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title (GTK_WINDOW (a_window),"About");

    main_box = gtk_vbox_new (FALSE, 0);
    gtk_container_border_width (GTK_CONTAINER (main_box), 5);
    gtk_container_add (GTK_CONTAINER (a_window), main_box);

    label = gtk_label_new ("AMCL version "VERSION"");
    gtk_box_pack_start (GTK_BOX (main_box), label, FALSE, FALSE, 5);
    gtk_widget_show (label);

    label = gtk_label_new ("Copyright  1998 Robin Ericsson");
    gtk_box_pack_start (GTK_BOX (main_box), label, FALSE, FALSE, 0);
    gtk_widget_show (label);

    label = gtk_label_new ("lobbin@lobbin.ml.org");
    gtk_box_pack_start (GTK_BOX (main_box), label, FALSE, FALSE, 0);
    gtk_widget_show (label);

    label = gtk_label_new ("   Licensed under GNU GENERAL PUBLIC LICENSE (GPL)    ");
    gtk_box_pack_start (GTK_BOX (main_box), label, FALSE, FALSE, 5);
    gtk_widget_show (label);

    label = gtk_label_new ("Homepage: http://lobbin.ml.org/stuff/");
    gtk_box_pack_start (GTK_BOX (main_box), label, FALSE, FALSE, 5);
    gtk_widget_show (label);

    separator = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (main_box), separator, FALSE, TRUE, 5);
    gtk_widget_show (separator);

    box2 = gtk_hbox_new (FALSE, 5);
    gtk_box_pack_start (GTK_BOX (main_box), box2, FALSE, FALSE, 0);

    button = gtk_button_new_with_label ( " close ");
    gtk_signal_connect (GTK_OBJECT (button), "clicked",
                        GTK_SIGNAL_FUNC (close_window), a_window);
    gtk_box_pack_start (GTK_BOX (box2), button, TRUE, TRUE, 5);

    gtk_widget_show (button  );
    gtk_widget_show (box2    );
    gtk_widget_show (main_box);
    gtk_widget_show (a_window);

}

void init_window ()
{
    GtkWidget *window;
    GtkWidget *box_main;
    GtkWidget *box_main2;
    GtkWidget *box_h_low;
    GtkWidget *menu_bar;
    GtkWidget *menu_main;
    GtkWidget *menu_help;
    GtkWidget *menu_option;
    GtkWidget *menu_main_menu;
    GtkWidget *menu_help_menu;
    GtkWidget *menu_option_menu;
    GtkWidget *separator;
    GtkWidget *menu_main_quit;
    GtkWidget *menu_help_about;
    GtkWidget *menu_help_contents;
    GtkWidget *v_scrollbar;

    /* init widgets */
    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title (GTK_WINDOW (window), "AMCL "VERSION"");
    gtk_signal_connect_object (GTK_OBJECT (window), "destroy",
                               GTK_SIGNAL_FUNC(destroy), NULL );

    box_main = gtk_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (window), box_main);

    menu_bar = gtk_menu_bar_new ();
    gtk_box_pack_start (GTK_BOX( box_main), menu_bar, FALSE, FALSE, 0);

    menu_main = gtk_menu_item_new_with_label ("Main");
    gtk_menu_bar_append (GTK_MENU_BAR (menu_bar), menu_main);

    menu_main_menu = gtk_menu_new ();
    gtk_menu_item_set_submenu (GTK_MENU_ITEM (menu_main), menu_main_menu);

    menu_main_wizard = gtk_menu_item_new_with_label ("Connection Wizard");
    gtk_menu_append (GTK_MENU (menu_main_menu), menu_main_wizard);
    gtk_signal_connect_object (GTK_OBJECT (menu_main_wizard), "activate",
                               GTK_SIGNAL_FUNC (window_wizard), NULL);
    gtk_widget_show (menu_main_wizard);

    separator = gtk_menu_item_new ();
    gtk_menu_append (GTK_MENU (menu_main_menu), separator);
    gtk_widget_show (separator);


    menu_main_connect = gtk_menu_item_new_with_label ("Connect");
    gtk_menu_append (GTK_MENU (menu_main_menu), menu_main_connect );
    gtk_signal_connect_object (GTK_OBJECT (menu_main_connect), "activate",
                               GTK_SIGNAL_FUNC (connect_window), NULL );

    menu_main_disconnect = gtk_menu_item_new_with_label ("Disconnect");
    gtk_menu_append (GTK_MENU (menu_main_menu), menu_main_disconnect );
    gtk_signal_connect_object (GTK_OBJECT (menu_main_disconnect), "activate",
                               GTK_SIGNAL_FUNC (disconnect), NULL );
    gtk_widget_set_sensitive (menu_main_disconnect, FALSE);
    
    separator = gtk_menu_item_new ();
    gtk_menu_append (GTK_MENU (menu_main_menu), separator);
    gtk_widget_show (separator);

    menu_main_quit = gtk_menu_item_new_with_label ("Quit");
    gtk_menu_append (GTK_MENU (menu_main_menu), menu_main_quit );
    gtk_signal_connect_object (GTK_OBJECT (menu_main_quit), "activate",
                               GTK_SIGNAL_FUNC (destroy), NULL );

    menu_option = gtk_menu_item_new_with_label ("Options");
    gtk_menu_bar_append (GTK_MENU_BAR (menu_bar), menu_option);

    menu_option_menu = gtk_menu_new ();
    gtk_menu_item_set_submenu (GTK_MENU_ITEM (menu_option), menu_option_menu);

    menu_option_alias = gtk_menu_item_new_with_label ("Alias");
    gtk_menu_append (GTK_MENU (menu_option_menu), menu_option_alias);
    gtk_signal_connect_object (GTK_OBJECT (menu_option_alias), "activate",
                               GTK_SIGNAL_FUNC (window_alias), NULL);

    menu_option_prefs = gtk_menu_item_new_with_label ("Preferences");
    gtk_menu_append (GTK_MENU (menu_option_menu), menu_option_prefs);
    gtk_signal_connect_object (GTK_OBJECT (menu_option_prefs), "activate",
                               GTK_SIGNAL_FUNC (window_prefs), NULL);

    menu_help = gtk_menu_item_new_with_label ("Help");
    gtk_menu_item_right_justify (GTK_MENU_ITEM (menu_help ));
    gtk_menu_bar_append (GTK_MENU_BAR (menu_bar), menu_help);

    menu_help_menu = gtk_menu_new ();
    gtk_menu_item_set_submenu (GTK_MENU_ITEM (menu_help), menu_help_menu);

    menu_help_contents = gtk_menu_item_new_with_label ("Contents");
    gtk_menu_append (GTK_MENU (menu_help_menu), menu_help_contents);

    separator = gtk_menu_item_new ();
    gtk_menu_append (GTK_MENU (menu_help_menu), separator);
    gtk_widget_show (separator);

    menu_help_about = gtk_menu_item_new_with_label ("About");
    gtk_menu_append (GTK_MENU (menu_help_menu), menu_help_about );
    gtk_signal_connect_object (GTK_OBJECT (menu_help_about),"activate",
                               GTK_SIGNAL_FUNC (about_window), NULL);

    box_main2 = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (box_main), box_main2, TRUE, TRUE, 5);

    box_h_low = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (box_main2), box_h_low, TRUE, TRUE, 10);

    text_field = gtk_text_new (NULL, NULL);
    gtk_box_pack_start (GTK_BOX (box_h_low), text_field, TRUE, TRUE, 0);
    gtk_widget_set_usize (text_field,500,320);
    foreground = &color_white;
    gtk_widget_show (text_field);

    v_scrollbar = gtk_vscrollbar_new (GTK_TEXT(text_field)->vadj);
    gtk_box_pack_start (GTK_BOX (box_h_low), v_scrollbar, FALSE, FALSE, 0);

    text_entry = gtk_entry_new ();
    gtk_signal_connect_object (GTK_OBJECT (text_entry), "activate",
                               GTK_SIGNAL_FUNC (send_to_connection), NULL);
    gtk_box_pack_start (GTK_BOX(box_main), text_entry, TRUE, TRUE, 0);
    gtk_widget_grab_focus (text_entry);
    gtk_widget_show (text_entry);

    /* show them */
    gtk_widget_show (v_scrollbar         );
    gtk_widget_show (box_h_low           );
    gtk_widget_show (box_main2           );
    gtk_widget_show (menu_help_contents  );
    gtk_widget_show (menu_help_about     );
    gtk_widget_show (menu_main_disconnect);
    gtk_widget_show (menu_main_connect   );
    gtk_widget_show (menu_main_quit      );
    gtk_widget_show (menu_option_alias   );
    gtk_widget_show (menu_option_prefs   );
    gtk_widget_show (menu_option         );
    gtk_widget_show (menu_help           );
    gtk_widget_show (menu_main           );
    gtk_widget_show (menu_bar            );
    gtk_widget_show (box_main            );
    gtk_widget_show (window              );
    gdk_window_set_background (GTK_TEXT (text_field)->text_area, &color_black);
}
