!**************************************************************************
!*
!* Boot-ROM-Code to load an operating system across a TCP/IP network.
!*
!* Module:  bcc_lbool.S
!* Purpose: Routines required by bcc
!* Entries: landl, lcoml, leorl, lorl, ltstl, landul, lcomul, leorul,
!*          lorul, ltstul
!*
!**************************************************************************
!*
!* Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
!*
!*  This program is free software; you can redistribute it and/or modify
!*  it under the terms of the GNU General Public License as published by
!*  the Free Software Foundation; either version 2 of the License, or
!*  any later version.
!*
!*  This program is distributed in the hope that it will be useful,
!*  but WITHOUT ANY WARRANTY; without even the implied warranty of
!*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!*  GNU General Public License for more details.
!*
!*  You should have received a copy of the GNU General Public License
!*  along with this program; if not, write to the Free Software
!*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
!*


!
!**************************************************************************
!
! Include assembler macros:
!
#include <macros.inc>
#include <memory.inc>
#include "./libpriv.inc"


!
!**************************************************************************
!
! Start code segment.
!
	.text


! If we are using the peephole optimizer for BCC all routines in this
! file should be unnecessary, so prevent it from getting included by
! disabling all public definitions.
#ifndef OPT386
	public	landl		! define entry points
	public	lcoml
	public	leorl
	public	lorl
	public	ltstl
	public	landul
	public	lcomul
	public	leorul
	public	lorul
	public	ltstul
#endif


!
!**************************************************************************
!
! Define BCC support functions
!
! AND
landl:
landul:	and	ax,[di]
	and	bx,2[di]
	ret


! XOR
leorl:
leorul:	xor	ax,[di]
	xor	bx,2[di]
	ret


! OR
lorl:
lorul:	or	ax,[di]
	or	bx,2[di]
	ret


! NOT
lcoml:
lcomul:	not	ax
	not	bx
	ret


! TEST
ltstl:
ltstul:	test	bx,bx
	jne	ltstl9
	test	ax,ax
	jns	ltstl9
	inc	bx
ltstl9:	ret


!
!**************************************************************************
!
	end

