/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.CompositeFactory;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.Transformation;
import de.hunsicker.jalopy.language.TransformationException;
import de.hunsicker.jalopy.language.TreeWalker;
import de.hunsicker.jalopy.language.antlr.ExtendedToken;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.language.antlr.Node;
import de.hunsicker.jalopy.storage.Loggers;
import de.hunsicker.util.Helper;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

final class SerializableTransformation
extends TreeWalker
implements Transformation {
    private static final String SERIAL_VERSION_UID = "serialVersionUID";
    private static final String SERIALIZABLE = "Serializable";
    private static final String EXTERNALIZABLE = "Externalizable";
    private ClassDefInfo _curClassDef;
    private List _classDefs = new ArrayList(5);
    private String _packageName;
    private CompositeFactory _factory = null;

    public SerializableTransformation(CompositeFactory factory) {
        this._factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(AST tree) throws TransformationException {
        try {
            this.walkNode(tree);
            int i = 0;
            int size = this._classDefs.size();
            while (i < size) {
                ClassDefInfo info = (ClassDefInfo)this._classDefs.get(i);
                if (info.serializable && !info.serialver) {
                    try {
                        Class clazz = Helper.loadClass(info.name, this);
                        ObjectStreamClass oclazz = ObjectStreamClass.lookup(clazz);
                        long serialVersionUID = oclazz.getSerialVersionUID();
                        this.insertSerialVer(tree, info, serialVersionUID);
                    }
                    catch (ClassNotFoundException ex) {
                        Object[] args = new Object[]{tree.getText(), info.name};
                        Loggers.TRANSFORM.l7dlog((Priority)Level.WARN, "TRANS_SERIALIZABLE_CLASS_NOT_FOUND", args, (Throwable)ex);
                    }
                }
                ++i;
            }
            Object var10_9 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.cleanup();
            throw throwable;
        }
    }

    public void visit(AST node) {
        AST child = node.getFirstChild();
        block3: while (child != null) {
            switch (child.getType()) {
                case 79: {
                    if (!child.getText().equals(SERIAL_VERSION_UID)) break block3;
                    this._curClassDef.serialver = true;
                    break block3;
                }
                default: {
                    child = child.getNextSibling();
                }
            }
        }
    }

    protected void walkNode(AST node) {
        if (node != null) {
            switch (node.getType()) {
                case 11: 
                case 67: {
                    this.walkNode(node.getFirstChild());
                    break;
                }
                case 21: {
                    this._packageName = JavaNodeHelper.getDottedName(node.getFirstChild());
                }
                case 7: 
                case 10: 
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 20: 
                case 23: 
                case 24: 
                case 35: 
                case 79: {
                    this.walkNode(node.getNextSibling());
                    break;
                }
                case 19: {
                    this._curClassDef = this.addToClassList(node);
                    if (this._curClassDef.serializable) {
                        this.walkNode(node.getFirstChild());
                    }
                    this.walkNode(node.getNextSibling());
                    break;
                }
                case 15: {
                    if (this._curClassDef.serializable && !this._curClassDef.serialver) {
                        this.visit(node);
                    }
                    this.walkNode(node.getNextSibling());
                    break;
                }
            }
        }
    }

    static boolean isClassSerializable(AST node) {
        AST clauses = JavaNodeHelper.getFirstChild(node, 24);
        AST clause = clauses.getFirstChild();
        while (clause != null) {
            String name = clause.getText();
            if (SERIALIZABLE.equals(name) || EXTERNALIZABLE.equals(name)) {
                return true;
            }
            clause = clause.getNextSibling();
        }
        return false;
    }

    private ClassDefInfo addToClassList(AST node) {
        int count = this._classDefs.size();
        String ident = null;
        ident = this._packageName + "." + JavaNodeHelper.getFirstChild(node, 79).getText();
        if (count > 0) {
            int i = 0;
            int size = this._classDefs.size();
            while (i < size) {
                ClassDefInfo previousInfo = (ClassDefInfo)this._classDefs.get(i);
                if (previousInfo.node.contains((JavaNode)node)) {
                    ident = previousInfo.name + "$" + JavaNodeHelper.getFirstChild(node, 79).getText();
                    break;
                }
                ++i;
            }
        }
        ClassDefInfo info = new ClassDefInfo(node, ident);
        this._classDefs.add(info);
        return info;
    }

    private void cleanup() {
        this._classDefs.clear();
        this._curClassDef = null;
        this._packageName = null;
        this._curClassDef = null;
    }

    private void insertSerialVer(AST tree, ClassDefInfo info, long serialverUID) {
        JavaNode serialver = this._factory.getJavaNodeFactory().create(Integer.MAX_VALUE, 1, Integer.MAX_VALUE, 1);
        serialver.setType(15);
        serialver.setText("VARIABLE_DEF");
        AST modifiers = this._factory.getJavaNodeFactory().create(10, "MODIFIERS");
        AST privatemod = this._factory.getJavaNodeFactory().create(99, "private");
        AST finalmod = this._factory.getJavaNodeFactory().create(44, "final");
        AST staticmod = this._factory.getJavaNodeFactory().create(76, "static");
        modifiers.addChild(privatemod);
        modifiers.addChild(finalmod);
        modifiers.addChild(staticmod);
        AST type = this._factory.getJavaNodeFactory().create(18, "TYPE");
        AST typevalue = this._factory.getJavaNodeFactory().create(96, "long");
        type.addChild(typevalue);
        AST ident = this._factory.getJavaNodeFactory().create(79, SERIAL_VERSION_UID);
        AST assign = this._factory.getJavaNodeFactory().create(110, "=");
        AST expr = this._factory.getJavaNodeFactory().create(33, "EXPR");
        AST assignvalue = this._factory.getJavaNodeFactory().create(173, serialverUID + "L");
        expr.addChild(assignvalue);
        assign.addChild(expr);
        JavaNode semi = (JavaNode)this._factory.getJavaNodeFactory().create(74, ";");
        serialver.addChild(modifiers);
        serialver.addChild(type);
        serialver.addChild(ident);
        serialver.addChild(assign);
        serialver.addChild(semi);
        Node description2 = (Node)this._factory.getNodeFactory().create();
        description2.setType(42);
        description2.setText("Use serialVersionUID for interoperability.");
        Node comment = (Node)this._factory.getNodeFactory().create(6, "/** Use serialVersionUID for interoperability. */");
        comment.addChild(description2);
        ExtendedToken token = this._factory.getExtendedTokenFactory().create(6, "/** Use serialVersionUID for interoperability. */");
        token.setComment(comment);
        serialver.setHiddenBefore(token);
        JavaNode objblock = (JavaNode)JavaNodeHelper.getFirstChild(info.node, 11);
        JavaNode lcurly = (JavaNode)objblock.getFirstChild();
        JavaNode next = (JavaNode)lcurly.getNextSibling();
        lcurly.setNextSibling(serialver);
        serialver.setParent(objblock);
        serialver.setPreviousSibling(lcurly);
        serialver.setNextSibling(next);
        if (next != null) {
            next.setPreviousSibling(serialver);
        }
        Object[] args = new Object[]{tree.getText(), info.name};
        Loggers.TRANSFORM.l7dlog((Priority)Level.INFO, "TRANS_SERIALIZABLE_ADD", args, null);
    }

    private static final class ClassDefInfo {
        public JavaNode node;
        public String name;
        public boolean serializable;
        public boolean serialver;

        public ClassDefInfo(AST node, String name) {
            this.node = (JavaNode)node;
            this.name = name;
            this.serializable = SerializableTransformation.isClassSerializable(node);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append('[');
            buf.append(this.node);
            buf.append(", name=");
            buf.append(this.name);
            buf.append(", hasField=");
            buf.append(this.serialver);
            buf.append(']');
            return buf.toString();
        }
    }
}

