// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000, 2001 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

///////////////////////////////////////////////////////////////
// globals.h - global variable declarations
//
// Changes:
//   22-04-2001 - added DISPLAY_BPP and DATA_BPP
///////////////////////////////////////////////////////////////

#ifndef _INCLUDE_GLOBALS_H
#define _INCLUDE_GLOBALS_H

#define PROGRAMNAME "Crimson Fields"

// data paths and files
// symbols PACKAGE and VERSION should be defined externally (usually 'crimson')
// symbol CF_LIB_PATH may be defined externally to define the location
//        of data files. If it is not defined the program will try to
//        locate the files at runtime.

#ifndef PACKAGE
# define PACKAGE "crimson"
#endif
#ifndef VERSION
# define VERSION "0.2.2"
#endif

#define CF_DATFILE	"cf.dat"

// global vars
extern class Game *Gam;
extern class Color ColLight, ColDark;
extern class Surface *Icons;
extern class Image *Images[];

#define DISPLAY_BPP	16	// display depth
#define DATA_BPP	8	// depth of images in data files

#define ICON_WIDTH	32
#define ICON_HEIGHT	32
#define XP_ICON_WIDTH	12
#define XP_ICON_HEIGHT	14

#define ICON_SPEED	0
#define ICON_DEFENCE	1
#define ICON_GROUND	2
#define ICON_AIRCRAFT	3
#define ICON_SHIP	4
#define ICON_CRYSTALS	5
#define ICON_HEX_BG	6
#define ICON_XP_BASE	7	// XP icons are 7 through 13

#define NUM_IMAGES	14

#ifdef WIN32
# define strcasecmp stricmp
# define strncasecmp strnicmp
#endif

#endif	/* _INCLUDE_GLOBALS_H */

