// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000, 2001 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

///////////////////////////////////////////////////////////////////////
// history.h - constructs to record the important events during a turn
//             and replay them on the next
//
// Changes:
///////////////////////////////////////////////////////////////////////

#ifndef _INCLUDE_HISTORY_H
#define _INCLUDE_HISTORY_H

#include "combat.h"

enum {  HIST_MOVE = 0,
        HIST_ATTACK,
        HIST_COMBAT,
        HIST_TILE,      // map tile change
        HIST_TILE_INTERNAL,
        HIST_DONE
};

class HistEvent : public Node {
public:
  HistEvent( void );
  HistEvent( SDL_RWops *file );
  int Save( SDL_RWops *file ) const;

  unsigned char type;
  short data[4];
};


class History {
public:
  History( void );
  History( SDL_RWops *file, unsigned short num );
  ~History( void );
  int Save( SDL_RWops *file ) const;

  int RecordMoveEvent( const Unit &u, Direction dir );
  int RecordAttackEvent( const Unit &u, const Unit &target );
  int RecordCombatEvent( const Combat &combat, unsigned char loss1,
                         unsigned char loss2 );
  int RecordTileEvent( unsigned short tile, unsigned short old,
                       short dx, short dy );

  void Replay( void );

private:
  List events;
  List units;
};

#endif	/* _INCLUDE_HISTORY_H */

