// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000, 2001 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

///////////////////////////////////////////////////////////////
// listselect.h - list widget class
//
// Changes:
//   03-04-2001 - ListHook::Activate() now takes a pointer to
//                the issuing ListWidget instead of its
//                identifier
///////////////////////////////////////////////////////////////

#ifndef _INCLUDE_LISTSELECT_H
#define _INCLUDE_LISTSELECT_H

#include "widget.h"
#include "list.h"
#include "slider.h"

class ListHook;

class ListWidget : public Widget, public Scrollable {
public:
  ListWidget( short id, short x, short y, unsigned short w,
    unsigned short h, List *list, short selected,
    unsigned short flags, const char *title, Window *window );

  virtual void Draw( void );
  virtual void DrawNodes( void ) = 0;
  void Update( void );			// call after modifying the list

  GUI_Status Select( short item );	// highlight a list item
  void SwitchList( List *newlist, short select );
  virtual void Set( short row );	// make row the top row
  void SetHook( ListHook *hook ) { this->hook = hook; }

  virtual GUI_Status MouseDown( const SDL_MouseButtonEvent &button );
  virtual GUI_Status KeyDown( const SDL_keysym &key );

  Node *Selected( void ) const { return list->GetNode(current); }
  virtual unsigned short ItemHeight( void ) const = 0;

protected:
  List *list;
  unsigned short nodes;
  unsigned short rows;
  unsigned short toprow;
  unsigned short visrows;
  short spacing;

  SliderWidget *slider;
  Window *window;

  ListHook *hook;               // hook object activated whenever
                                // a node is selected
};

// hook class for list node selection
class ListHook {
public:
  ListHook( void ) {}

  virtual GUI_Status Activate( ListWidget *widget, Node *node, Window *win ) = 0;
};

#endif	/* _INCLUDE_LISTSELECT_H */

