// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000, 2001 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

//////////////////////////////////////////////////////////////////////
// textbox.h - StringWidget, TextWidget, TextScrollWidget, and
//             TextListWidget
//
// Changes:
//////////////////////////////////////////////////////////////////////

#ifndef _INCLUDE_TEXTBOX_H
#define _INCLUDE_TEXTBOX_H

#include "widget.h"
#include "slider.h"
#include "listselect.h"

class TextWidget : public Widget {
public:
  TextWidget( short id, short x, short y, unsigned short w,
        unsigned short h, const char *str, unsigned short flags,
        const char *title, Window *window );
  ~TextWidget( void );

  virtual void SetText( const char *str );
  unsigned short SetRow( unsigned short top );
  unsigned short Rows( void ) const { return rows; }
  unsigned short RowsVisible( void ) const { return visrows; }

  void Draw( void );

private:
  char *text;
  char **lineptr;
  unsigned short lines;		// lines of text
  unsigned short rows;		// rows of pixels
  unsigned short visrows;	// rows visible at one time
  unsigned short toprow;	// first visible row
  unsigned short spacing;
};


class TextScrollWidget : public TextWidget, public Scrollable {
public:
  TextScrollWidget( short id, short x, short y, unsigned short w,
         unsigned short h, const char *str, unsigned short flags,
         const char *title, Window *window );

  void Set( short level );
  void SetText( const char *str );

private:
  SliderWidget *slider;
};


class TextListWidget : public ListWidget {
public:
  TextListWidget( short id, short x, short y, unsigned short w,
    unsigned short h, List *list, short selected,
    unsigned short flags, const char *title, Window *window ) :
    ListWidget( id, x, y, w, h, list, selected, flags, title, window )
             { itemh = font->Height() + spacing; Update(); }

  virtual void DrawNodes( void );
  virtual unsigned short ItemHeight( void ) const { return itemh; }

private:
  unsigned short itemh;
};

// node type used by the TextListWidget
class TLWNode : public Node {
public:
  char *name;
  void *user_data;
};


class StringWidget : public Widget {
public:
  StringWidget( short id, short x, short y, unsigned short w, unsigned short h,
                short key, const char *str, unsigned short maxlen,
                unsigned short flags, const char *title, Window *window );
  ~StringWidget( void );
  virtual void Draw( void );

  const char *String( void ) const;
  void SetString( const char *newstr, bool upd = true );
  GUI_Status SetFocus( void );

  virtual GUI_Status MouseDown( const SDL_MouseButtonEvent &button );
  virtual GUI_Status KeyDown( const SDL_keysym &key );

private:
  GUI_Status InputLoop( void );
  void CharInput( short sym, unsigned short unicode );

  char *buffer;
  unsigned short cursor;
  unsigned short len;
  unsigned short maxlen;
  unsigned short cursorpix;
};

#endif	/* _INCLUDE_TEXTBOX_H */

