// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000, 2001 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

//////////////////////////////////////////////////////////////////////////
// unitwindow.h - the window classes used for getting unit specifications
//                and showing contents of buildings and transports
//
// Changes:
//   03-04-2001 - added HandleEvent(), removed select button
//   08-11-2001 - ContainerWindow is now a subclass of ButtonHook and
//                ListHook; this allows us to get rid of the separate hooks
//////////////////////////////////////////////////////////////////////////

#ifndef _INCLUDE_UNITWINDOW_H
#define _INCLUDE_UNITWINDOW_H

#include "window.h"
#include "button.h"
#include "listselect.h"
#include "textbox.h"
#include "container.h"
#include "building.h"

class Game;
class MapWindow;
class UnitListWidget;
class TransferScrollable;
class ULWNode;

// the same window class is used for buildings and transports, but
// the layout will look slightly different

#define CW_MODE_NORMAL		0
#define CW_MODE_PRODUCTION	1
#define CW_MODE_TRANSFER	2

#define CH_NUM_BUTTONS		4

class ContainerWindow : public Window, public ButtonHook, public ListHook {
public:
  ContainerWindow( Transport *transport, Building *building, View *view );
  ~ContainerWindow( void );

  GUI_Status HandleEvent( const SDL_Event &event );
  void SwitchMode( unsigned short newmode );
  GUI_Status SelectNode( ULWNode *node );

  unsigned short Mode( void ) const { return mode; }

  void Draw( void );
  void DrawCrystals( void );

  GUI_Status Activate( ButtonWidget *button, Window *win );
  GUI_Status Activate( ListWidget *widget, Node *node, Window *win );

private:
  UnitContainer *c;

  bool unit;                          // true if transport, false if building
  unsigned short mode;

  List normal;
  List build;
  Rect unitinfo;

  UnitListWidget *listwidget;
  ButtonWidget *buttons[CH_NUM_BUTTONS];
  SliderWidget *slider;
  StringWidget *stringwidgets[2];
  TransferScrollable *transferscroll;
};


// unit type information window
class UnitInfoWindow : public Window {
public:
  UnitInfoWindow( const UnitType *type, MapWindow *mapwin, View *view );
};

#endif	/* _INCLUDE_UNITWINDOW_H */

