"
" $Id: indexgen.vim,v 1.2 2002/09/08 19:22:56 howama Exp $
" Ben Secrest <blsecres@users.sourceforge.net>
"	simple vim script for syntax highlighting IndexGenerator project files
"
"	to enable:
"	- place this file in ${HOME}/.vim/syntax
"	- add an entry for the IndexGenerator file type to
"	  ${HOME}/.vim/filetype.vim :
"		au BufRead,BufNewFile *.ig		setfiletype indexgen
"

syntax match igLongVarStart ")$" contained
syntax match igLongVarEnd "^;;" contained


syntax include @igHTML $VIMRUNTIME/syntax/html.vim

syntax region	igShortVar oneline start="^" end="="me=e-1
syntax region	igLongVar oneline start="^" end=")$"me=e-1 contains=igLongVarStart
syntax match	igComment	"%.*$" contains=NONE

syntax region igInsertText start=")$" end="^;;$" keepend contains=@igHTML,igComment,igLongVarStart,igLongVarEnd

syn match   IGSection   "^%%%.*"
highlight def link igComment		Comment
highlight def link igShortVar		Keyword
highlight def link igLongVar		Keyword
highlight def link igLongVarStart	Delimiter
highlight def link igLongVarEnd		Delimiter
highlight def link igError		Error
hi def link IGSection   PreProc
