# -*- coding: utf-8 -*-

# Copyright (c) 2006 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the Interface (Part 1) configuration page.
"""

import glob
import os

from PyQt4.QtCore import pyqtSignature, QVariant, QTranslator, QString
from PyQt4.QtGui import QStyleFactory

from E4Gui.E4Completers import E4FileCompleter

from ConfigurationPageBase import ConfigurationPageBase
from Ui_Interface1Page import Ui_Interface1Page

from KdeQt import KQFileDialog
import KdeQt

import Preferences
import Utilities

from eric4config import getConfig

class Interface1Page(ConfigurationPageBase, Ui_Interface1Page):
    """
    Class implementing the Interface (Part 1) configuration page.
    """
    def __init__(self):
        """
        Constructor
        """
        ConfigurationPageBase.__init__(self)
        self.setupUi(self)
        self.setObjectName("Interface1Page")
        
        self.styleSheetCompleter = E4FileCompleter(self.styleSheetEdit)
        
        # set initial values
        self.__populateStyleCombo()
        
        self.uiBrowsersListFoldersFirstCheckBox.setChecked(\
            Preferences.getUI("BrowsersListFoldersFirst"))
        self.uiBrowsersHideNonPublicCheckBox.setChecked(\
            Preferences.getUI("BrowsersHideNonPublic"))
        self.uiCaptionShowsFilenameGroupBox.setChecked(\
            Preferences.getUI("CaptionShowsFilename"))
        self.filenameLengthSpinBox.setValue(\
            Preferences.getUI("CaptionFilenameLength"))
        self.uiKdeDialogsCheckBox.setChecked(\
            Preferences.getUI("UseKDEDialogs"))
        self.uiKdeDialogsCheckBox.setEnabled(KdeQt.isKDEAvailable())
        # disable the icon provider checkbox because Qt4 isn't supporting
        # custom icon providers yet
        self.iconProviderCheckBox.setEnabled(False)
        self.styleSheetEdit.setText(Preferences.getUI("StyleSheet"))
        
        if Preferences.getUI("TopLeftByLeft"):
            self.tlLeftButton.setChecked(True)
        else:
            self.tlTopButton.setChecked(True)
        if Preferences.getUI("BottomLeftByLeft"):
            self.blLeftButton.setChecked(True)
        else:
            self.blBottomButton.setChecked(True)
        if Preferences.getUI("TopRightByRight"):
            self.trRightButton.setChecked(True)
        else:
            self.trTopButton.setChecked(True)
        if Preferences.getUI("BottomRightNyRight"):
            self.brRightButton.setChecked(True)
        else:
            self.brTopButton.setChecked(True)
        
    def save(self):
        """
        Public slot to save the Interface configuration.
        """
        # save the style settings
        styleIndex = self.styleComboBox.currentIndex()
        style = self.styleComboBox.itemData(styleIndex).toString()
        Preferences.setUI("Style", style)
        
        # save the other UI related settings
        Preferences.setUI("BrowsersListFoldersFirst",
            int(self.uiBrowsersListFoldersFirstCheckBox.isChecked()))
        Preferences.setUI("BrowsersHideNonPublic",
            int(self.uiBrowsersHideNonPublicCheckBox.isChecked()))
        Preferences.setUI("CaptionShowsFilename",
            int(self.uiCaptionShowsFilenameGroupBox.isChecked()))
        Preferences.setUI("CaptionFilenameLength",
            self.filenameLengthSpinBox.value())
        Preferences.setUI("UseKDEDialogs",
            int(self.uiKdeDialogsCheckBox.isChecked()))
        Preferences.setUI("StyleSheet",
            self.styleSheetEdit.text())
        
        # save the dockarea corner settings
        Preferences.setUI("TopLeftByLeft", 
            int(self.tlLeftButton.isChecked()))
        Preferences.setUI("BottomLeftByLeft", 
            int(self.blLeftButton.isChecked()))
        Preferences.setUI("TopRightByRight", 
            int(self.trRightButton.isChecked()))
        Preferences.setUI("BottomRightNyRight", 
            int(self.brRightButton.isChecked()))
        
    def __populateStyleCombo(self):
        """
        Private method to populate the style combo box.
        """
        curStyle = Preferences.getUI("Style")
        styles = QStyleFactory.keys()
        styles.sort()
        self.styleComboBox.addItem(self.trUtf8('System'), QVariant("System"))
        for style in styles:
            self.styleComboBox.addItem(style, QVariant(style))
        currentIndex = self.styleComboBox.findData(QVariant(curStyle))
        if currentIndex == -1:
            currentIndex = 0
        self.styleComboBox.setCurrentIndex(currentIndex)
        
    @pyqtSignature("")
    def on_styleSheetButton_clicked(self):
        """
        Private method to select the style sheet file via a dialog.
        """
        file = KQFileDialog.getOpenFileName(\
            self,
            self.trUtf8("Select style sheet file"),
            self.styleSheetEdit.text(),
            self.trUtf8("Qt Style Sheets (*.qss);;Cascading Style Sheets (*.css);;"
                        "All files (*)"),
            None)
        
        if not file.isEmpty():
            self.styleSheetEdit.setText(Utilities.toNativeSeparators(file))
    
def create(dlg):
    """
    Module function to create the configuration page.
    
    @param dlg reference to the configuration dialog
    """
    page = Interface1Page()
    return page
