/*
 * Copyright (C) 2000-2001 Chris Ross and Evan Webb
 * Copyright (C) 1999-2000 Chris Ross
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *   
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity 
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *    
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef __BUIDLER_H__
#define __BUIDLER_H__

typedef struct __builder_module {
   char  name[1024];
   FILE *core;
   FILE *general;
   FILE *header;
   FILE *Makefile;
   FILE *flags;
   FeriteStack *name_stack;
   FeriteStack *current_state;
} BuilderModule;

#define MakefileTemplate \
  "## Process this file with automake to produce Makefile.in\n"                      \
  "\n"                                                                               \
  "AUTOMAKE_OPTIONS     = 1.4 foreign\n\n"                                           \
  "# A list of all the files in the current directory which can be regenerated\n"    \
  "MAINTAINERCLEANFILES = Makefile.in %s*.h %s*.c %s*~\n\n"                          \
  "CLEANFILES       = \n"                                                            \
  "\n"                                                                               \
  "LDFLAGS          = -L${libdir} -L${top_builddir}/src @%s_LIBS@\n"                 \
  "INCLUDES         = -I$(top_srcdir)/include -I$(prefix)/include -I. @%s_CFLAGS@\n" \
  "\n"                                                                               \
  "EXTRA_DIST       = %s.fec\n"                                                      \
  "pkgdir           = $(libdir)/ferite/modules\n"                                    \
  "pkg_LTLIBRARIES  = %s.la\n"                                                       \
  "\n"                                                                               \
  "%s_la_SOURCES    = %s %s\n"                                                       \
  "%s_la_LDFLAGS    = -no-undefined -module -avoid-version\n"                        \
  "%s_la_LIBADD     =\n"                                                             \
  "\n"                                                                               \
  "$(top_srcdir)/modules/%s/%s_core.c: $(top_srcdir)/modules/%s/%s\n"                \
  "\t$(top_builddir)/builder/builder -m %s $(top_srcdir)/modules/%s/%s\n"    
  
  /* modulename, modulename, modulefiles, modulename, modulename */

#define ConfigM4Template \
   "%s_LIBS=\"\"\n" \
   "%s_CFLAGS=\"\"\n" \
   "AC_SUBST(%s_LIBS)\n" \
   "AC_SUBST(%s_CFLAGS)\n" \
   "\nmodules=\"$modules %s\"\n"
   
#endif /* __BUIDLER_H__ */
