/*
   The Ferite library loader, ltdl edition. Uses ltdl as the lib loader
   */

#include "../config.h"

#ifdef USE_LTDL

#include "triton.h"
#define HAVE_CONFIG_H
#include "./libltdl/config.h"
#undef HAVE_CONFIG_H
#ifndef LTDL_SHLIB_EXT
#define LTDL_SHLIB_EXT ".so"
#endif

LIB_INIT {
   return lt_dlinit();
}

LIB_DEINIT { }

LIB_EXT {
   return LTDL_SHLIB_EXT;
}

LIB_OPEN {
   lt_dlhandle *h = malloc( sizeof( lt_dlhandle ) );
   *h = lt_dlopen(path);
   return h;
}

LIB_SYM {
   void *h;
   h = lt_dlsym(*handle, symbol);
   if(h == NULL) {
      printf("LOADER: '%s' not found!\n",symbol);
   }
   return h;
}

LIB_CLOSE {
   int r = lt_dlclose(*h);
   free(h);
   return r;
}

LIB_ERROR {
   return lt_dlerror();
}

#endif
