/* This file has been automatically generated by builder part of the ferite distribution */
/* file:  network_ServerSocket.c */
/* class: ServerSocket */

#include <ferite.h>       /* we need this without a doubt */
#include "network_header.h"  /* this is the module header */

FE_NS_FUNCTION( network_ServerSocket_bind )
{
   char *host = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   double port;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 4, host, &port, &super, &self );

   { /* Main function body. */
 
	  struct sockaddr_in   bind_addr;
	  struct hostent      *hostent_ptr;	  
	  
	  memset( (char*)&bind_addr, '\0', sizeof(bind_addr) );
	  bind_addr.sin_port   = htons( (int)port );
	  bind_addr.sin_family = AF_INET;
	  if( strcmp( host, "" ) == 0 ){
		 bind_addr.sin_addr.s_addr = htonl(INADDR_ANY);
	  } else {
		 hostent_ptr = gethostbyname(host);
		 if(!hostent_ptr)
		 {
			ferite_error( script,"Couldn't lookup host %s.", SelfObj->hostname);
			FE_RETURN_VOID;
		 }
		 memcpy( &bind_addr.sin_addr, hostent_ptr->h_addr, sizeof(bind_addr.sin_addr) );
	  }
	  if( bind( SelfObj->sockfd, (struct sockaddr*)&bind_addr, sizeof(bind_addr)) < 0 ){
		 ferite_error( script, "Unable to bind to %s:%d", (strcmp( host, "" ) == 0 ? "local machine" : host ), (long)port );
	  }	  
	  SelfObj->hostname = (strcmp( host, "" ) == 0 ? fstrdup("local machine") : host );
	  SelfObj->port = (long)port;
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( network_ServerSocket_setAcceptTimeouts )
{
   double seconds;
   double uSeconds;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 4, &seconds, &uSeconds, &super, &self );

   { /* Main function body. */
 
	  SelfObj->seconds = (long)seconds;
	  SelfObj->uSeconds = (long)uSeconds;
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( network_ServerSocket_accept )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	  struct sockaddr_in  cli_addr;
	  struct timeval      wait_for_info;
	  FeriteVariable     *newSocket;
	  FeriteVariable    **newSocketParams;
	  fd_set              readfds;
	  int                 newfd, clientLen, result;
	  
      wait_for_info.tv_sec = SelfObj->seconds;
      wait_for_info.tv_usec = SelfObj->uSeconds; /* wait only for a uSec */
      
      FD_ZERO( &readfds );
      FD_SET( SelfObj->sockfd, &readfds );
      result = select( SelfObj->sockfd+1, &readfds, NULL, NULL, &wait_for_info );
      if( result >= 0 ){
		 if( FD_ISSET( SelfObj->sockfd, &readfds ) )/* wh00p we have some data */
		 {
			newfd = accept( SelfObj->sockfd, (struct sockaddr*)&cli_addr, &clientLen );
			if( newfd < 0 ){
			   ferite_error( script, "Accept failed in ServerSocket.accept() (%s:%d)", SelfObj->hostname, SelfObj->port );
			   newSocket = __ferite_create_object_variable( "newSocket" );
			   FE_RETURN_VAR(newSocket);			   
			}
			newSocketParams = fmalloc( sizeof( FeriteVariable * ) * 5 );
			memset( newSocketParams, '\0', sizeof( FeriteVariable * ) * 5 );
			newSocket = __ferite_new_object( script, __ferite_find_class( script, script->mainns, "Socket" ), newSocketParams );
			__ferite_delete_parameter_list( script, newSocketParams );
			OAS(VAO(newSocket))->sockfd = newfd;
			if( getpeername( newfd, (struct sockaddr*)&cli_addr, &clientLen ) >= 0 ){ 
			   OAS(VAO(newSocket))->hostname = fstrdup(inet_ntoa( (struct in_addr)cli_addr.sin_addr ));
			   OAS(VAO(newSocket))->port = ntohs( cli_addr.sin_port );
			}
			OAS(VAO(newSocket))->connected = 1;
			FE_RETURN_VAR( newSocket );
		 } else { /* no socket incoming so we just create a void variable */
			newSocket = __ferite_create_object_variable( "newSocket" );
			FE_RETURN_VAR(newSocket);			   
		 }
      } else { 
		 ferite_error( script, "Select failed in ServerSocket.accept() (%s:%d)", SelfObj->hostname, SelfObj->port );
      }
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( network_ServerSocket_close )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
      SelfObj->connected = 0;
      close( SelfObj->sockfd );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( network_ServerSocket_ServerSocket )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
      SelfObj = fmalloc( sizeof(SocketData) );
      SelfObj->sockfd = 0;
      SelfObj->buffer = memset( fmalloc( 1024 ), '\0', 1024 );
      SelfObj->buffer_size = 1024;
      SelfObj->hostname = NULL;
      SelfObj->port = 0;      
      SelfObj->transport = AF_INET;
      SelfObj->domain = PF_INET;
      SelfObj->type = SOCK_STREAM;
      SelfObj->protocol = 0;
      SelfObj->connected = 0;
      SelfObj->seconds = 0;
      SelfObj->uSeconds = 1;
  
	  SelfObj->sockfd = socket( SelfObj->domain, SelfObj->type, SelfObj->protocol );
	  if( SelfObj->sockfd < 0 ){
		 ferite_error( script, "Unable to allocate server socket" );
	  }
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( network_ServerSocket_listen )
{
   double backlog;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &backlog, &super, &self );

   { /* Main function body. */
 
      if( listen( SelfObj->sockfd, (int)backlog ) < 0 )
      {
		 ferite_error( script,"Listen on ServerSocket failed (%s:%d)", SelfObj->hostname, SelfObj->port);
      }
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( network_ServerSocket_Destructor )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
      close( SelfObj->sockfd );
      if( SelfObj->buffer != NULL )
        ffree( SelfObj->buffer );
      if( SelfObj->hostname != NULL )
        ffree( SelfObj->hostname );
      ffree( SelfObj );
   
   }
   FE_RETURN_VOID;
}

