/*
 * Copyright (C) 2000-2001 Chris Ross and Evan Webb
 * Copyright (C) 1999-2000 Chris Ross
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *   
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity 
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *    
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef __db_mysql_HEADER__
#define __db_mysql_HEADER__

void db_mysql_init( DbModuleInterface *smi );
void db_mysql_deinit( DbModuleInterface *smi );   
FeriteVariable *db_mysql_connect( DbModuleInterface *smi, char *database, char *hostname, char *username, char *password );
FeriteVariable *db_mysql_close( DbModuleInterface *smi );
FeriteVariable *db_mysql_query( DbModuleInterface *smi, char *query );
FeriteVariable *db_mysql_result_count( DbModuleInterface *smi );
FeriteVariable *db_mysql_column_count( DbModuleInterface *smi );
FeriteVariable *db_mysql_result_reset( DbModuleInterface *smi );
FeriteVariable *db_mysql_next_record( DbModuleInterface *smi );
FeriteVariable *db_mysql_get_row( DbModuleInterface *smi );
FeriteVariable *db_mysql_fetch_field( DbModuleInterface *smi, char *name );
FeriteVariable *db_mysql_fetch_field_type( DbModuleInterface *smi, int index );
FeriteVariable *db_mysql_fetch_field_name( DbModuleInterface *smi, int index );
FeriteVariable *db_mysql_fetch_field_length( DbModuleInterface *smi, int index );

#endif /* __db_mysql_HEADER__ */
