/*
 * Copyright (C) 2000-2001 Chris Ross and Evan Webb
 * Copyright (C) 1999-2000 Chris Ross
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *   
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity 
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *    
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "ferite.h"

/*
 * this is to get huge amounts (well a fair amount) of debug info....
 * #define SUPER_VERBOSE
*/

int __ferite_classic_malloc_count = 0;
int __ferite_classic_calloc_count = 0;
int __ferite_classic_realloc_count = 0;
int __ferite_classic_free_count = 0;

int __ferite_classic_end_freeup = -1;
int __ferite_total_freeup = 0;

#define rmalloc(s)          malloc(s)
#define rcalloc(s,bs)       calloc(s,bs)
#define rrealloc(p,s)       realloc(p,s)
#define rfree(p)            free(p)

struct __ferite_memory_block *mem_rootblk = NULL;

void  __ferite_classic_memory_init(void)
{
   FE_ENTER_FUNCTION;
#ifdef FERITE_MEM_DEBUG
   FUD(("Internal Memory Deubgging On.\n"));
   mem_rootblk = malloc(sizeof( struct __ferite_memory_block ));
   mem_rootblk->data = NULL;
   mem_rootblk->size = 0;
   mem_rootblk->file = strdup( "ROOTMEMBLK" );
   mem_rootblk->next = NULL;
#endif
   FE_LEAVE_FUNCTION( NOWT );
}

void __ferite_classic_memory_clear_block( struct __ferite_memory_block *ptr )
{
   if( ptr != NULL )
   {
      if( ptr->next )
		__ferite_classic_memory_clear_block( ptr->next );
	  if( !hide_mem_use && ptr->line != 0 )
		printf( "Freeing block[%p] [%d bytes] allocated on file: %s, line %d\n", ptr->data, ptr->size, ptr->file, ptr->line );
	  __ferite_total_freeup += ptr->size;
      /* this is just here so i can see what string it is allocated */
      if( ptr->line == 190 )
		printf( "%s\n", (char *)ptr->data );
      free( ptr->data );
      free( ptr->file );
      free( ptr );
      __ferite_classic_end_freeup++;
   }
}

void __ferite_classic_memory_deinit(void)
{
   FE_ENTER_FUNCTION;
   if( ! hide_mem_use )
   {
#ifdef FERITE_MEM_DEBUG
	  __ferite_classic_memory_dump();
#endif
      printf( "Ferite Memory Usage Statistics\n" );
      printf( " |-> %d mallocs, %d callocs, %d reallocs - %d frees\n", __ferite_classic_malloc_count, __ferite_classic_calloc_count, __ferite_classic_realloc_count, __ferite_classic_free_count );
      printf( " `-> ( %d block(s) still allocated )\n", (__ferite_classic_malloc_count + __ferite_classic_calloc_count) - __ferite_classic_free_count );
   }
#ifdef FERITE_MEM_DEBUG
   if( !hide_mem_use ) 
	 printf("Freeeing Up Unallocated Memory\n");
   __ferite_classic_memory_clear_block( mem_rootblk );
   if( !hide_mem_use )
	 printf("Free'd %d [%d bytes] allocations\n", __ferite_classic_end_freeup, __ferite_total_freeup );
#endif
   FE_LEAVE_FUNCTION( NOWT );
}

void *__ferite_classic_malloc( size_t size, char *file, int line )
{
#ifdef FERITE_MEM_DEBUG
   struct __ferite_memory_block *ptr;
#endif
   
   __ferite_classic_malloc_count++;

#ifdef FERITE_MEM_DEBUG
   for( ptr = mem_rootblk; ptr->next != NULL; ptr = ptr->next )
     ;
   ptr->next = malloc(sizeof( struct __ferite_memory_block ));
   ptr->next->data = rmalloc( size );
   ptr->next->size = size;
   ptr->next->file = strdup( file );
   ptr->next->line = line;
   if( !ptr->next->data )
     FUD(("ERROR: Unable to allocate %d bytes.\n", size ));
   ptr->next->next = NULL;
   FUD(( "Allocating %p\n", ptr->next->data ));
   return ptr->next->data;
#else
   return rmalloc( size );
#endif
}

void *__ferite_classic_calloc( size_t size, size_t blk_size, char *file, int line )
{
#ifdef FERITE_MEM_DEBUG
   struct __ferite_memory_block *ptr;
#endif
   
   __ferite_classic_calloc_count++;

#ifdef FERITE_MEM_DEBUG
   for( ptr = mem_rootblk; ptr->next != NULL; ptr = ptr->next )
     ;
   ptr->next = malloc(sizeof( struct __ferite_memory_block ));
   ptr->next->data = rcalloc( size, blk_size );
   ptr->next->size = size;
   ptr->next->file = strdup( file );
   ptr->next->line = line;
   if( !ptr->next->data )
     FUD(("ERROR: Unable to (c)allocate %d bytes.\n", size ));
   ptr->next->next = NULL;
   return ptr->next->data;
#else
   return rcalloc( size, blk_size );
#endif
}

void *__ferite_classic_realloc( void *targetptr, size_t size )
{
#ifdef FERITE_MEM_DEBUG
   struct __ferite_memory_block *ptr;
#endif
   
   if( targetptr == NULL )
   {
      return __ferite_classic_malloc( size, "ferite_mem.c", 125 );
   }
   else
   {
      __ferite_classic_realloc_count++;

#ifdef FERITE_MEM_DEBUG
      for( ptr = mem_rootblk; ptr->next != NULL; ptr = ptr->next )
      {
		 if( ptr->next->data == targetptr )
		 {
			ptr->next->data = rrealloc( ptr->next->data, size );
			ptr->next->size = size;
			return ptr->next->data;
		 }
      }
#endif
      targetptr = rrealloc( targetptr, size );
      return targetptr;
   }
}

void __ferite_classic_free( void *targetptr, char *file, int line )
{
#ifdef FERITE_MEM_DEBUG
   struct __ferite_memory_block *ptr, *temp_ptr;

   if( targetptr == NULL )
     printf( "Trying to free NULL ptr on %s:%d\n", file, line );

   for( ptr = mem_rootblk; ptr->next != NULL; ptr = ptr->next )
   {
      if( ptr->next->data == targetptr )
      {
# ifdef SUPER_VERBOSE
		 FUD(("INFO: Found memory block (%p). Freeing.\n", ptr->next->data));
# endif
		 __ferite_classic_free_count++;

		 temp_ptr = ptr->next;
		 ptr->next = temp_ptr->next;
# ifdef SUPER_VERBOSE
		 FUD(("INFO: Freeing %p\n", temp_ptr->data ));
# endif
		 rfree( temp_ptr->data );
# ifdef SUPER_VERBOSE
		 FUD(("  * Free'd data\n"));
# endif
		 free( temp_ptr->file );
# ifdef SUPER_VERBOSE
		 FUD(("  * Free'd filename\n"));
# endif
		 free( temp_ptr );
# ifdef SUPER_VERBOSE
		 FUD(("  * Free'd memory block\n"));
# endif
		 return;
      }
   }
   FUD(("* URGH. Can't find block(%p) in memory list. Freeing Anyways.\n", targetptr));
   free( targetptr );
#else
   if( targetptr == NULL )
     printf( "Trying to free null in %s at %d\n", file, line );
   else
     __ferite_classic_free_count++;
   rfree( targetptr );
#endif
}

void __ferite_classic_memory_dump()
{
   long memory_allocated = 0;
   struct __ferite_memory_block *ptr;

   if( mem_rootblk != NULL && mem_rootblk->next != NULL )
   {
	  fprintf( stderr, "Currently Allocated Memory:\n" );
      fprintf( stderr, "+-----------+---------+----------------------------------------------------------------+-------+\n");
      fprintf( stderr, "| Address   |  Amount | File                                                           |  Line |\n");
      fprintf( stderr, "+-----------+---------+----------------------------------------------------------------+-------+\n");
      for (ptr = mem_rootblk->next; ptr != NULL; ptr = ptr->next)
      {
		 fprintf(stderr, "| %9p | %7d | %-62.62s | %5d |\n", ptr->data, ptr->size, ptr->file, ptr->line);
		 memory_allocated += ptr->size;
      }
      fprintf( stderr, "+-----------+---------+----------------------------------------------------------------+-------+\n");
      fprintf( stderr, "Total Memory Allocated = %ld bytes ( ~%ld kb ).\n", memory_allocated, (memory_allocated / 1024) + 1);
   }
}
