/*
 *  Freeplane - mind map editor
 *  Copyright (C) 2012 Dimitry
 *
 *  This file author is Dimitry
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.freeplane.main.headlessmode;

import java.awt.Component;
import java.awt.Rectangle;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.freeplane.core.ui.components.FreeplaneMenuBar;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.ui.FrameController;
import org.freeplane.features.ui.IMapViewManager;

/**
 * @author Dimitry Polivaev
 * 24.12.2012
 */
public class HeadlessUIController extends FrameController {	
	
	final private AtomicLong workingThreadId = new AtomicLong();
	final private ExecutorService worker = Executors.newSingleThreadExecutor(new ThreadFactory() {
		public Thread newThread(Runnable r) {
			final Thread thread = Executors.defaultThreadFactory().newThread(r);
			workingThreadId.set(thread.getId());
			return thread;
		}
	}) ;
	
	public HeadlessUIController(Controller controller, IMapViewManager mapViewManager, String propertyKeyPrefix) {
		super(controller, mapViewManager, propertyKeyPrefix);		
	}

	public Rectangle getFrameSize() {
		throw methodNotImplementedException();
	}

	public void setFrameSize(Rectangle frameSize) {
		throw methodNotImplementedException();
	}

	public void changeNoteWindowLocation() {
		throw methodNotImplementedException();
	}

	public void err(String msg) {
		throw methodNotImplementedException();
	}

	public FreeplaneMenuBar getFreeplaneMenuBar() {
		throw methodNotImplementedException();
	}

	public JFrame getJFrame() {
		throw methodNotImplementedException();
	}

	public JComponent getStatusBar() {
		throw methodNotImplementedException();
	}

	public void init(Controller controller) {
		throw methodNotImplementedException();
	}

	public void insertComponentIntoSplitPane(JComponent noteViewerComponent) {
		throw methodNotImplementedException();
	}

	public boolean isApplet() {
		return false;
	}

	public boolean isMenubarVisible() {
		throw methodNotImplementedException();
	}

	public void openDocument(URI uri) throws IOException {
		throw methodNotImplementedException();
	}

	public void openDocument(URL fileToUrl) throws Exception {
		throw methodNotImplementedException();
	}

	public void out(String msg) {
		throw methodNotImplementedException();
	}

	public void addStatusInfo(String key, String info) {
		throw methodNotImplementedException();
	}

	public void addStatusInfo(String key, Icon icon) {
		throw methodNotImplementedException();
	}

	public void addStatusInfo(String key, String info, Icon icon) {
		throw methodNotImplementedException();
	}

	public void addStatusInfo(String key, String info, Icon icon, String tooltip) {
		throw methodNotImplementedException();
	}

	public void addStatusComponent(String key, Component component) {
		throw methodNotImplementedException();
	}

	public void removeStatus(String key) {
		throw methodNotImplementedException();
	}

	public void removeSplitPane() {
		throw methodNotImplementedException();
	}

	public void saveProperties() {
		throw methodNotImplementedException();
	}

	public void selectMode(ModeController oldModeController, ModeController newModeController) {
		throw methodNotImplementedException();
	}

	public void setMenubarVisible(boolean visible) {
		throw methodNotImplementedException();
	}

	public void setTitle(String frameTitle) {
		throw methodNotImplementedException();
	}

	public void setWaitingCursor(boolean b) {
		throw methodNotImplementedException();
	}

	public void viewNumberChanged(int number) {
		throw methodNotImplementedException();
	}

	public String completeVisiblePropertyKey(JComponent toolBar) {
		throw methodNotImplementedException();
	}

	public void addObjectTypeInfo(Object value) {
		throw methodNotImplementedException();
	}

	public boolean quit() {
		throw methodNotImplementedException();
	}

	public boolean isDispatchThread() {
		return workingThreadId.get() == Thread.currentThread().getId();
    }

	public void invokeLater(Runnable runnable) {
		worker.execute(runnable);
    }

	public void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
	    try {
			worker.submit(runnable).get();
		} catch (ExecutionException e) {			
		}	    
    }

	public boolean isHeadless() {
	    return true;
    }

	public boolean areScrollbarsVisible() {
	    return false;
    }

	public void setScrollbarsVisible(boolean b) {
    }

	public boolean isFullScreenEnabled() {
	    return false;
    }

	@Override
	protected void setFreeplaneMenuBar(FreeplaneMenuBar menuBar) {
		throw methodNotImplementedException();
	}

	public void previousMapView() {
		throw methodNotImplementedException();
		
	}

	public void nextMapView() {
		throw methodNotImplementedException();
	}

	@Override
	public Component getCurrentRootComponent() {
		throw methodNotImplementedException();
	}

	@Override
	public Component getMenuComponent() {
		throw methodNotImplementedException();
	}
	
	@Override
	protected boolean isMenuComponentInFullScreenMode() {
		return false;
	}

	private RuntimeException methodNotImplementedException() {
		return new RuntimeException("Method not implemented");
	}	
	
}
