#include <string.h>
#include <stdio.h>
#include <signal.h>
#include <sys/wait.h>

#include <gtk/gtklabel.h>
#include <gtk/gtkfilesel.h>
#include <gtk/gtkentry.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtkbutton.h>
#include <gtk/gtkdrawingarea.h>
#include <gtk/gtkmessagedialog.h>

#include <gdk/gdk.h>
#include <gdk/gdkx.h>

#include <panel-applet.h>
#include <panel-applet-gconf.h>

#include <libgnomeui/gnome-about.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>

struct AppletConfigure
{
    PanelApplet *applet;
    GtkWidget *parentWidget;
    GtkWidget* program_entry;
    GtkWidget* applet_name_entry;
    GtkWidget* filesel;
    GtkWidget* window;
    char* program;
    char* applet_name;
    int width;
    int height;
    pid_t pid;
};

gboolean swallow(char* wantedWindow, Display* display, Screen* screen, Window hunger, int* width, int* height)
{
    int dummy=0;
    int ready = FALSE, number_of_subkids,number_of_kids,number_of_subsubkids,i,j,k,l;
    Window root, parent, *children=NULL,*subchildren=NULL,*subsubchildren=NULL;
    Window victim;
    char *windowname;
    XWMHints *leader_change;
    int x, y, junk;
    double start, now;
    struct timeval tv;
    char ret;

    if(! display) return; /* WTF? */

    XSync (display, FALSE);

    gettimeofday(&tv);
    now = start = (double)tv.tv_sec + ((double)tv.tv_usec / 1000000.0);

    while (ready == FALSE && now < (start + 10.0))
    {
        if (children != (Window *) NULL) XFree (children);

        XQueryTree (display, RootWindowOfScreen (screen), &root,
                    &parent, &children, &number_of_kids);
        for (i = 0; i < number_of_kids; i++)
        {
            if (0 != XFetchName (display, children[i], &windowname))
            {
                if (!strcmp (windowname, wantedWindow))
                {
                    ready = TRUE;
                    victim = children[i];
                    fprintf(stderr,"Found It\n");
                }
                else
                    fprintf(stderr,"Found %s\n",windowname);
                XFree (windowname);
            }
            /*for each of these toplevel windows check their children*/
            /*if it wasnt found*/
            if (ready == FALSE)
            {
                if (subchildren != (Window *) NULL)
                    XFree (subchildren);
                XQueryTree (display, children[i], &root,
                            &parent, &subchildren, &number_of_subkids);
                for (k = 0; k < number_of_subkids; k++)
                {
                    if (0 != XFetchName (display, subchildren[k], &windowname))
                    {
                        if (!strcmp (windowname, wantedWindow))
                        {
                            ready = TRUE;
                            victim = subchildren[k];
                            fprintf(stderr,"Found %s!!!\n",windowname);
                        }
                        else
                            fprintf(stderr,"Found %s\n",windowname);
                        XFree (windowname);
                    }
                    /**/
                    /*for each of these sublevel windows check their children*/
                    /*if it wasnt found*/
                    if (ready == FALSE)
                    {
                        if (subsubchildren != (Window *) NULL)
                            XFree (subsubchildren);
                        XQueryTree (display, subchildren[k], &root,
                                    &parent, &subsubchildren, &number_of_subsubkids);
                        for (l = 0; l < number_of_subsubkids; l++)
                        {
                            if (0 != XFetchName (display, subsubchildren[l], &windowname))
                            {
                                if (!strcmp (windowname, wantedWindow))
                                {
                                    ready = TRUE;
                                    victim = subsubchildren[l];
                                    fprintf(stderr,"Found %s!!!\n",windowname);
                                }
                                else
                                    fprintf(stderr,"Found %s\n",windowname);
                                XFree (windowname);
                            }
                        }
                    }
                }
            }
        }
        fprintf(stderr,"Loop");
        gtk_main_iteration_do(FALSE);

        gettimeofday(&tv);
        now = (double)tv.tv_sec + ((double)tv.tv_usec / 1000000.0);
    }

    if(ready) {
        XSync (display, FALSE);
        XUnmapWindow (display, victim);
        XIconifyWindow (display, victim, XScreenNumberOfScreen (screen));
        XWithdrawWindow (display, victim, XScreenNumberOfScreen (screen));
        XMoveWindow (display, victim, -9999, -9999);

        leader_change = XGetWMHints(display, victim);
        if(leader_change) {
            leader_change->flags = (leader_change->flags | WindowGroupHint);
            leader_change->window_group = RootWindowOfScreen(screen);
        }
        XSetWindowBorderWidth (display, victim, 0);

        XSync (display, FALSE);

        sleep(1);

        XReparentWindow (display, victim, hunger, -9999, -9999);

        XGetGeometry (display, victim, &root, &x, &y, width, height, &junk, &junk);
        XMoveWindow (display, victim, 0, 0);
        if(leader_change) XSetWMHints(display, victim, leader_change);
        XMapWindow (display, victim);
        XSync (display, FALSE);

        ret = TRUE;
    } else {
        ret = FALSE;
    }

    if (children != (Window *) NULL)
        XFree (children);
    if (subchildren != (Window *) NULL)
        XFree (subchildren);
    if (subsubchildren != (Window *) NULL)
        XFree (subsubchildren);

    return ret;
}

void orientChanged(GtkWidget* w, int unused, struct AppletConfigure* ap)
{
    PanelAppletOrient po;

    po = panel_applet_get_orient(ap->applet);

    if(po == PANEL_APPLET_ORIENT_UP || po == PANEL_APPLET_ORIENT_DOWN) {
        gtk_widget_set_size_request (ap->parentWidget, ap->width + 4, ap->height);
    } else {
        gtk_widget_set_size_request (ap->parentWidget, ap->width, ap->height + 4);
    }
}

gboolean swallowIt(gpointer data)
{
    GdkDisplay* gdkdisplay = gdk_display_get_default ();
    GdkScreen* gdkscreen = gdk_screen_get_default ();

    struct AppletConfigure* ap = (struct AppletConfigure*)data;

    if(swallow(ap->applet_name,
            GDK_DISPLAY_XDISPLAY(gdkdisplay),
            GDK_SCREEN_XSCREEN(gdkscreen),
            GDK_WINDOW_XWINDOW (GTK_WIDGET (ap->parentWidget)->window),
               &ap->width, &ap->height))
    {
        panel_applet_gconf_set_string(ap->applet, "program", ap->program, NULL);
        panel_applet_gconf_set_string(ap->applet, "applet_name", ap->applet_name, NULL);

        orientChanged(GTK_WIDGET(ap->applet), 0, ap);
    } else {
        GtkWidget* dialog = gtk_message_dialog_new(0, 0, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
                                                   "Swallower Applet: Could not find a window named \"%s\" (ran program \"%s\")", ap->applet_name, ap->program);
        g_signal_connect_swapped (GTK_OBJECT(dialog), "response",
                                  G_CALLBACK(gtk_widget_destroy),
                                  GTK_OBJECT(dialog));
        gtk_widget_show(dialog);
    }

    return FALSE;
}

void store_filename(GtkWidget* widget, struct AppletConfigure* ap)
{
    gtk_entry_set_text(GTK_ENTRY(ap->program_entry), gtk_file_selection_get_filename(GTK_FILE_SELECTION(ap->filesel)));
    gtk_widget_hide(ap->filesel);
}

void openFileDialog(GtkWidget* widget, struct AppletConfigure* ap)
{
    GtkFileSelection* gf;
    if(!ap->filesel) {
        ap->filesel = gtk_file_selection_new("Select program to run");
        g_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(ap->filesel)->ok_button),
                         "clicked",
                         G_CALLBACK(store_filename),
                         ap);
        g_signal_connect_swapped(GTK_OBJECT(GTK_FILE_SELECTION(ap->filesel)->cancel_button),
                         "clicked",
                         G_CALLBACK(gtk_widget_hide),
                         ap->filesel);
    }
    gtk_widget_show(ap->filesel);
}

void exitProgram(GtkWidget* w, gpointer d)
{
    gtk_main_quit();
}

void forkApplet(struct AppletConfigure* ap)
{
    if(ap->pid > -1) {
        /* Kill the old process and wait for it to die (if the process
           is already dead then it will be a zombie anyway).
         */
        kill(ap->pid, SIGTERM);
        sleep(1);
        kill(ap->pid, SIGKILL);
        int s;
        waitpid(ap->pid, &s, WNOHANG);
    }

    ap->pid = fork();

    if(ap->pid == -1) {
        /* ouch, fork() failed */
        perror("fork");
        exit(-1);
    } else if(ap->pid == 0) {
        /* child */
        char* prog = strdup(ap->program);
        char* args[256];
        int i = 0, n = 0;

        args[0] = strdup(ap->applet_name);
        while(prog[i]) {
            while(prog[i] != ' ' && prog[i] != 0) i++;
            if(! prog[i]) break;
            prog[i] = 0;
            i++;
            while(prog[i] == ' ') i++;
            args[++n] = &prog[i];
        }
        args[++n] = 0;

        execvp(prog, args);

        _exit(0);
    } else {
        gtk_timeout_add (1000, swallowIt, ap);
    }
}

void okClicked(GtkWidget* w, struct AppletConfigure* ap)
{
    gtk_widget_hide(ap->window);

    ap->program = strdup(gtk_entry_get_text(GTK_ENTRY(ap->program_entry)));
    ap->applet_name = strdup(gtk_entry_get_text(GTK_ENTRY(ap->applet_name_entry)));
    if(ap->applet_name[0] == 0) {
        int i = strlen(ap->program);
        while(ap->program[i] != '/' && i > 0) i--;
        if(ap->program[i] == '/') i++;
        ap->applet_name = strdup(ap->program + i);
    }
    forkApplet(ap);
}

gboolean openDialog(struct AppletConfigure* ap)
{
    GtkWidget* vbox;
    GtkWidget* hbox;
    GtkWidget* program_label;
    GtkWidget* window_label;
    GtkWidget* window_note_label;
    GtkWidget* label;
    GtkWidget* browsebutton;
    GtkWidget* okbutton;
    GtkWidget* cancelbutton;

    ap->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

    g_signal_connect_swapped(ap->window, "delete_event", G_CALLBACK(gtk_widget_destroy), ap->window);

    /* Labels */
    program_label = gtk_label_new("Program to run: ");
    window_label = gtk_label_new("Window name to swallow: ");

    vbox = gtk_vbox_new(TRUE, 5);
    hbox = gtk_hbox_new(TRUE, 5);
    gtk_container_add(GTK_CONTAINER(vbox), program_label);
    gtk_container_add(GTK_CONTAINER(vbox), window_label);

    /* Add first column */
    gtk_container_add(GTK_CONTAINER(hbox), vbox);

    /* Entry Boxes */
    ap->program_entry = gtk_entry_new();
    ap->applet_name_entry = gtk_entry_new();
    if(ap->program) gtk_entry_set_text(GTK_ENTRY(ap->program_entry), ap->program);
    if(ap->applet_name) gtk_entry_set_text(GTK_ENTRY(ap->applet_name_entry), ap->applet_name);

    vbox = gtk_vbox_new(TRUE, 5);
    gtk_container_add(GTK_CONTAINER(vbox), ap->program_entry);
    gtk_container_add(GTK_CONTAINER(vbox), ap->applet_name_entry);
    gtk_container_add(GTK_CONTAINER(hbox), vbox);

    /* Browse Button */
    browsebutton = gtk_button_new_with_label("Browse...");
    window_note_label = gtk_label_new("(may be blank)");

    g_signal_connect(browsebutton, "clicked", G_CALLBACK(openFileDialog), ap);

    vbox = gtk_vbox_new(TRUE, 5);
    gtk_container_add(GTK_CONTAINER(vbox), browsebutton);
    gtk_container_add(GTK_CONTAINER(vbox), window_note_label);

    /* Add third column */
    gtk_container_add(GTK_CONTAINER(hbox), vbox);

    /* Last row for buttons */
    vbox = gtk_vbox_new(FALSE, 5);
    gtk_container_add(GTK_CONTAINER(vbox), hbox);

    /* Ok, Cancel */
    okbutton = gtk_button_new_with_label("Ok");
    cancelbutton = gtk_button_new_with_label("Cancel");

    g_signal_connect(okbutton, "clicked", G_CALLBACK(okClicked), ap);
    g_signal_connect_swapped(cancelbutton, "clicked", G_CALLBACK(gtk_widget_destroy), ap->window);

    hbox = gtk_hbox_new(FALSE, 5);
    gtk_container_add(GTK_CONTAINER(hbox), okbutton);
    gtk_container_add(GTK_CONTAINER(hbox), cancelbutton);
    gtk_container_add(GTK_CONTAINER(vbox), hbox);

    /* Done */
    gtk_container_add(GTK_CONTAINER(ap->window), vbox);
    gtk_widget_show_all (ap->window);

    return FALSE;
}

void reconfigure(BonoboUIComponent* gw, struct AppletConfigure* ap, const char* cname)
{
    openDialog(ap);
}

void changeBackground(PanelApplet *panelapplet,
                      PanelAppletBackgroundType type,
                      GdkColor* color,
                      GdkPixmap *pixmap,
                      struct AppletConfigure* ap)
{
    GtkStyle* style = gtk_style_copy(gtk_widget_get_style(ap->parentWidget));

    switch (type) {
    case PANEL_NO_BACKGROUND:
        gtk_widget_modify_bg(ap->parentWidget, GTK_STATE_NORMAL, 0);
        break;
    case PANEL_COLOR_BACKGROUND:
        style->bg[0].red = color->red;
        style->bg[0].green = color->green;
        style->bg[0].blue = color->blue;
        gtk_widget_set_style(ap->parentWidget, style);
        break;
    case PANEL_PIXMAP_BACKGROUND:
        // This appears to be broken in Gnome 2.2!!!
        //style->bg_pixmap[0] = pixmap;
        //gtk_widget_set_style(ap->parentWidget, style);
        break;
    default:
        break;
    }
}

void display_about_dialog(BonoboUIComponent* gw, struct AppletConfigure* ap, const char* cname)
{
    const gchar* authors[2] = {"Peter Amstutz <tetron@interreality.org>", 0};
    char info[1024];
    GtkWidget* about;

    sprintf(info, "Swallow dock apps into the GNOME 2 panel\n  Currently running: \"%s\"\n  Grabbed window name is \"%s\"",
            ap->program, ap->applet_name);

    about = gnome_about_new("Swallower", VERSION,
                            "(c) 2003 Peter Amstutz, released under the GNU GPL",
                            info,
                            authors, 0, 0, 0);
    gtk_widget_show(about);
}

static const char swallow_menu_xml [] =
        "<popup name=\"button3\">\n"
        "   <menuitem name=\"Reconfigure or Reswallow\" verb=\"Reconfigure\" _label=\"Reconfigure ...\" />\n"
        "   <menuitem name=\"About Item\" verb=\"About\" _label=\"About ...\"\n"
        "             pixtype=\"stock\" pixname=\"gnome-stock-about\"/>\n"
        "</popup>\n";

static const BonoboUIVerb swallow_menu_verbs [] = {
    BONOBO_UI_UNSAFE_VERB ("Reconfigure", reconfigure),
    BONOBO_UI_UNSAFE_VERB ("About", display_about_dialog),
    BONOBO_UI_VERB_END
};

static gboolean swallow_applet_fill (PanelApplet *applet,
                                   const gchar *iid,
                                   gpointer     data)
{
    char c[256];
    struct AppletConfigure* ap = (struct AppletConfigure*)malloc(sizeof(struct AppletConfigure));
    memset(ap, 0, sizeof(struct AppletConfigure));

    if (strcmp (iid, "OAFIID:GNOME_Swallow") != 0){
        free(ap);
        return FALSE;
    }

    ap->pid = -1;
    ap->applet = applet;
    ap->parentWidget = gtk_drawing_area_new();
    ap->width = 16;
    ap->height = 16;
    gtk_widget_set_size_request (ap->parentWidget, ap->width, ap->height);

    gtk_container_add (GTK_CONTAINER (applet), ap->parentWidget);
    gtk_widget_show_all (GTK_WIDGET (applet));

    panel_applet_setup_menu (applet, swallow_menu_xml, swallow_menu_verbs, ap);

    panel_applet_add_preferences (applet, "/schemas/apps/swallow/prefs", NULL);

    ap->program = panel_applet_gconf_get_string(applet, "program", NULL);
    ap->applet_name = panel_applet_gconf_get_string(applet, "applet_name", NULL);

    if(! ap->program || !ap->applet_name) {
        openDialog(ap);
    } else {
        forkApplet(ap);
    }

    g_signal_connect(applet, "change-orient", G_CALLBACK(orientChanged), ap);
    g_signal_connect(applet, "change-background", G_CALLBACK(changeBackground), ap);

    {
        GdkColor color;
        GdkPixmap* pixmap;

        changeBackground(applet, panel_applet_get_background(applet, &color, &pixmap),
                         &color, pixmap, ap);
    }

    return TRUE;
}


PANEL_APPLET_BONOBO_FACTORY ("OAFIID:GNOME_Swallow_Factory",
                             PANEL_TYPE_APPLET,
                             "Swallow Meta-Applet",
                             "0",
                             swallow_applet_fill,
                             NULL);
