/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * This is GNU Go, a Go program. Contact gnugo@gnu.org, or see       *
 * http://www.gnu.org/software/gnugo/ for more information.          *
 *                                                                   *
 * Copyright 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 and 2007 *
 * by the Free Software Foundation.                                  *
 *                                                                   *
 * This program is free software; you can redistribute it and/or     *
 * modify it under the terms of the GNU General Public License as    *
 * published by the Free Software Foundation - version 3 or          *
 * (at your option) any later version.                               *
 *                                                                   *
 * This program is distributed in the hope that it will be useful,   *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of    *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *
 * GNU General Public License in file COPYING for more details.      *
 *                                                                   *
 * You should have received a copy of the GNU General Public         *
 * License along with this program; if not, write to the Free        *
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor,       *
 * Boston, MA 02111, USA.                                            *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* Compile Monte Carlo local pattern database. This produces mcpat.c. */

/* See also mc_*.db and engine/montecarlo.c. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "liberty.h"

/* Trim leading path, a possible mc_ prefix, and a possible .db suffix
 * from the filename. The caller has to free the returned pointer when
 * it's no longer needed.
 *
 * FIXME: This code is quite ugly and should be possible to clean up.
 */
static char *
copy_and_trim_name(const char *filename)
{
  int name_length = strlen(filename);
  char *name = malloc(name_length + 1);
  char *start = name;
  char *p;
  char *name2;
  
  strcpy(name, filename);

  p = strrchr(name, '/');
  if (p) {
    p++;
    name_length -= (p - name);
    start = p;
  }
  
  if (strncmp(start, "mc_", 3) == 0) {
    start += 3;
    name_length -= 3;
  }
  
  if (strncmp(start + name_length - 3, ".db", 3) == 0)
    start[name_length - 3] = '\0';

  name2 = malloc(name_length + 1);
  strcpy(name2, start);
  free(name);
  
  return name2;
}  

int
main(int argc, char *argv[])
{
  int N = mc_get_size_of_pattern_values_table();
  unsigned int *values;
  int i;
  int k;
  char *name;

  if (argc < 2) {
    fprintf(stderr, "Usage: ...\n");
    exit(EXIT_FAILURE);
  }

  printf("\
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\\\n\
 * This is GNU Go, a Go program. Contact gnugo@gnu.org, or see       *\n\
 * http://www.gnu.org/software/gnugo/ for more information.          *\n\
 *                                                                   *\n\
 * Copyright 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 and 2007 *\n\
 * by the Free Software Foundation.                                  *\n\
 *                                                                   *\n\
 * This program is free software; you can redistribute it and/or     *\n\
 * modify it under the terms of the GNU General Public License as    *\n\
 * published by the Free Software Foundation - version 3             *\n\
 * or (at your option) any later version                             *\n\
 *                                                                   *\n\
 * This program is distributed in the hope that it will be useful,   *\n\
 * but WITHOUT ANY WARRANTY; without even the implied warranty of    *\n\
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *\n\
 * GNU General Public License in file COPYING for more details.      *\n\
 *                                                                   *\n\
 * You should have received a copy of the GNU General Public         *\n\
 * License along with this program; if not, write to the Free        *\n\
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor,       *\n\
 * Boston, MA 02111, USA.                                            *\n\
\\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */\n\n");

  printf("/* This file is automatically generated by mkmcpat. Do not\n");
  printf(" * edit it directly. Instead, edit the pattern databases\n");
  printf(" * mc_*.db.\n");
  printf(" */\n\n");
  printf("#include <stdio.h> /* for NULL */\n");
  printf("#include \"liberty.h\"\n\n");
  printf("#include \"patterns.h\"\n\n");

  values = malloc(N * sizeof(*values));

  for (i = 1; i < argc; i++) {
    if (!mc_load_patterns_from_db(argv[i], values))
      exit(EXIT_FAILURE);

    name = copy_and_trim_name(argv[i]);

    printf("static const unsigned int %s_values[] = {\n", name);
    for (k = 0; k < N; k++) {
      printf("%u, ", values[k]);
      if (k % 8 == 7)
	printf("\n");
    }
    printf("\n};\n\n");

    free(name);
  }

  printf("struct mc_pattern_database mc_pattern_databases[] = {\n");
  for (i = 1; i < argc; i++) {
    name = copy_and_trim_name(argv[i]);
    printf("  {\"%s\", %s_values},\n", name, name);
    free(name);
  }
  printf("  {NULL, NULL}};\n");

  return 0;
}

/*
 * Local Variables:
 * tab-width: 8
 * c-basic-offset: 2
 * End:
 */
