/* XGGState - Implements graphic state drawing for Xlib

   Copyright (C) 1995 Free Software Foundation, Inc.

   Written by: Adam Fedor <fedor@boulder.colorado.edu>
   Date: Nov 1995
   
   This file is part of the GNU Objective C User Interface Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
   */

#ifndef _XGGState_h_INCLUDE
#define _XGGState_h_INCLUDE

#include <AppKit/NSGraphicsContext.h>   // needed for NSCompositingOperation
#include <Foundation/NSArray.h>
#include <Foundation/NSObject.h>
#include <SharedX/xrtools.h>

@class NSAffineTransform;
@class NSBezierPath;
@class NSFont;
@class XGContext;

@interface XGGState : NSObject
{
@public
  XGContext *xgcontext;
  RContext  *context;
  int       window;
  GC	    xgcntxt;
  XGCValues gcv;
  Drawable  draw;
  Drawable  alpha_buffer;
  NSFont    *font;
  id        saveObject;
  
  NSAffineTransform *ctm;
  NSPoint offset;       /* Offset from Drawable origin */
  Region clipregion;
  NSBezierPath    *path;	/* current path - FIFO stack */

  xr_device_color_t color;

  BOOL drawingAlpha;
  BOOL viewIsFlipped;
  BOOL sharedGC;  /* Do we own the GC or share it? */
}

- initWithDrawContext: (XGContext *)context;

- (void) setWindow: (int)number;
- (void) setDrawable: (Drawable)theDrawable;
- (void) setGraphicContext: (GC)xGraphicContext;
- (void) setGCValues: (XGCValues)values withMask: (int)mask;
- (void) setClipMask;
- (Region) xClipRegion;
- (void) setColor: (xr_device_color_t)acolor;
- (void) setOffset: (NSPoint)theOffset;
- (void) setSaveObject: save;

- (BOOL) hasDrawable;
- (BOOL) hasGraphicContext;
- (int) window;
- (Drawable) drawable;
- (GC) graphicContext;
- (NSPoint) offset;
- (NSRect) clipRect;
- saveObject;

- (void) setFont: (NSFont*)font;
- (NSFont*) currentFont;

- (void) compositeGState: (XGGState *)source
		fromRect: (NSRect)aRect 
		 toPoint: (NSPoint)aPoint
		      op: (NSCompositingOperation)op;

- (void) dissolveGState: (XGGState *)source
	       fromRect: (NSRect)aRect
		toPoint: (NSPoint)aPoint 
		  delta: (float)delta;

- (void) compositerect: (NSRect)aRect
		    op: (NSCompositingOperation)op;
		    
- (void) copyBits: (XGGState*)source
	 fromRect: (NSRect)aRect 
	  toPoint: (NSPoint)aPoint;

- (NSPoint) pointInMatrixSpace: (NSPoint)point;
- (NSPoint) deltaPointInMatrixSpace: (NSPoint)point;
- (NSRect) rectInMatrixSpace: (NSRect)rect;

- (XPoint) viewPointToX: (NSPoint)aPoint;
- (XRectangle) viewRectToX: (NSRect)aRect;
- (XPoint) windowPointToX: (NSPoint)aPoint;
- (XRectangle) windowRectToX: (NSRect)aRect;

@end

#include <gnustep/xgps/XGGStateOps.h>

#endif /* _XGGState_h_INCLUDE */

