module Hat.Data.Set
  (Set(),gemptySet,gmkSet,amkSet,hmkSet,gsetToList,asetToList,hsetToList
    ,gunitSet,aunitSet,hunitSet,gelementOf,aelementOf,helementOf,gisEmptySet
    ,aisEmptySet,hisEmptySet,gcardinality,acardinality,hcardinality,gunion
    ,aunion,hunion,gunionManySets,aunionManySets,hunionManySets,gminusSet
    ,aminusSet,hminusSet,gmapSet,amapSet,hmapSet,gintersect,aintersect
    ,hintersect,gaddToSet,aaddToSet,haddToSet,gdelFromSet,adelFromSet
    ,hdelFromSet) where

import qualified Prelude 
import qualified Hat.Hat as T 
import qualified Hat.PreludeBasic 
import Hat.Prelude 
import Hat.Data.FiniteMap 
import Hat.Data.Maybe 

newtype Set a = MkSet (T.R (FiniteMap a T.Tuple0))

instance T.WrapVal ((Set a))
  where
  
  T.wrapVal pwrapVal (kwrapVal@(MkSet (T.R _ z1wrapVal))) p =
    T.R kwrapVal (T.mkValueApp1 p pwrapVal aMkSet z1wrapVal)
  

gemptySet :: T.RefSrcPos -> T.RefExp -> T.R (Set a)

semptySet :: T.R (Set a)

gemptySet pemptySet p = T.uconstUse pemptySet p semptySet

semptySet =
  T.uconstDef T.mkRoot aemptySet
    (\ p -> T.con1 T.mkNoSrcPos p MkSet aMkSet (gemptyFM T.mkNoSrcPos p))

gunitSet :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (Set a))

hunitSet :: (T.R a) -> T.RefExp -> T.R (Set a)

gunitSet punitSet p = T.ufun1 aunitSet punitSet p hunitSet

hunitSet fx p =
  T.con1 T.mkNoSrcPos p MkSet aMkSet
    (T.uwrapForward p (hunitFM fx (T.con0 T.mkNoSrcPos p T.Tuple0 T.aTuple0) p))

gsetToList :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Set a) (T.List a))

hsetToList :: (T.R (Set a)) -> T.RefExp -> T.R (T.List a)

gsetToList psetToList p = T.ufun1 asetToList psetToList p hsetToList

hsetToList (T.R (MkSet fset) _) p =
  T.uwrapForward p (hkeysFM (gset T.mkNoSrcPos p) p)
  where
  
  gset pset p = T.uconstUse pset p sset
  
  sset = T.uconstDef p a0v0set (\ p -> T.projection T.mkNoSrcPos p fset)
  
hsetToList _ p = T.fatal p

gmkSet :: Ord a => T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.List a) (Set a))

hmkSet :: Ord a => (T.R (T.List a)) -> T.RefExp -> T.R (Set a)

gmkSet pmkSet p = T.ufun1 amkSet pmkSet p hmkSet

hmkSet fxs p =
  T.con1 T.mkNoSrcPos p MkSet aMkSet
    (T.uap1 T.mkNoSrcPos p (glistToFM T.mkNoSrcPos p)
      (T.uap1 T.mkNoSrcPos p
        (T.uap2 T.mkNoSrcPos p (Hat.Prelude.g_foldr T.mkNoSrcPos p)
          (T.ufun2 T.mkLambda T.mkNoSrcPos p
            (\ f_x f_y p ->
              T.uccase T.mkNoSrcPos p
                (let
                  v0v0v1 fx p =
                    T.uap1 T.mkNoSrcPos p
                      (T.pa1 T.Cons T.cn1 T.mkNoSrcPos p T.aCons
                        (T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2 fx
                          (T.con0 T.mkNoSrcPos p T.Tuple0 T.aTuple0))) f_y
                  v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y in (v0v0v1))
                f_x)) fxs) (T.fromExpList T.mkNoSrcPos p [])))

gunion ::
  Ord a =>
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Set a) (T.Fun (Set a) (Set a)))

hunion :: Ord a => (T.R (Set a)) -> (T.R (Set a)) -> T.RefExp -> T.R (Set a)

gunion punion p = T.ufun2 aunion punion p hunion

hunion (T.R (MkSet fset1) _) (T.R (MkSet fset2) _) p =
  T.con1 T.mkNoSrcPos p MkSet aMkSet
    (T.uwrapForward p (hplusFM (gset1 T.mkNoSrcPos p) (gset2 T.mkNoSrcPos p) p))
  where
  
  gset1 pset1 p = T.uconstUse pset1 p sset1
  
  sset1 = T.uconstDef p a0v0set1 (\ p -> T.projection T.mkNoSrcPos p fset1)
  
  gset2 pset2 p = T.uconstUse pset2 p sset2
  
  sset2 = T.uconstDef p a0v0set2 (\ p -> T.projection T.mkNoSrcPos p fset2)
  
hunion _ _ p = T.fatal p

gunionManySets ::
  Ord a => T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.List (Set a)) (Set a))

hunionManySets :: Ord a => (T.R (T.List (Set a))) -> T.RefExp -> T.R (Set a)

gunionManySets punionManySets p =
  T.ufun1 aunionManySets punionManySets p hunionManySets

hunionManySets fss p =
  T.uwrapForward p
    (hfoldr (gunion T.mkNoSrcPos p) (gemptySet T.mkNoSrcPos p) fss p)

gminusSet ::
  Ord a =>
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Set a) (T.Fun (Set a) (Set a)))

hminusSet :: Ord a => (T.R (Set a)) -> (T.R (Set a)) -> T.RefExp -> T.R (Set a)

gminusSet pminusSet p = T.ufun2 aminusSet pminusSet p hminusSet

hminusSet (T.R (MkSet fset1) _) (T.R (MkSet fset2) _) p =
  T.con1 T.mkNoSrcPos p MkSet aMkSet
    (T.uwrapForward p
      (hminusFM (gset1 T.mkNoSrcPos p) (gset2 T.mkNoSrcPos p) p))
  where
  
  gset1 pset1 p = T.uconstUse pset1 p sset1
  
  sset1 = T.uconstDef p a0v0set1 (\ p -> T.projection T.mkNoSrcPos p fset1)
  
  gset2 pset2 p = T.uconstUse pset2 p sset2
  
  sset2 = T.uconstDef p a0v0set2 (\ p -> T.projection T.mkNoSrcPos p fset2)
  
hminusSet _ _ p = T.fatal p

gintersect ::
  Ord a =>
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Set a) (T.Fun (Set a) (Set a)))

hintersect :: Ord a => (T.R (Set a)) -> (T.R (Set a)) -> T.RefExp -> T.R (Set a)

gintersect pintersect p = T.ufun2 aintersect pintersect p hintersect

hintersect (T.R (MkSet fset1) _) (T.R (MkSet fset2) _) p =
  T.con1 T.mkNoSrcPos p MkSet aMkSet
    (T.uwrapForward p
      (hintersectFM (gset1 T.mkNoSrcPos p) (gset2 T.mkNoSrcPos p) p))
  where
  
  gset1 pset1 p = T.uconstUse pset1 p sset1
  
  sset1 = T.uconstDef p a0v0set1 (\ p -> T.projection T.mkNoSrcPos p fset1)
  
  gset2 pset2 p = T.uconstUse pset2 p sset2
  
  sset2 = T.uconstDef p a0v0set2 (\ p -> T.projection T.mkNoSrcPos p fset2)
  
hintersect _ _ p = T.fatal p

gaddToSet ::
  Ord a => T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Set a) (T.Fun a (Set a)))

haddToSet :: Ord a => (T.R (Set a)) -> (T.R a) -> T.RefExp -> T.R (Set a)

gaddToSet paddToSet p = T.ufun2 aaddToSet paddToSet p haddToSet

haddToSet (T.R (MkSet fset) _) fa p =
  T.con1 T.mkNoSrcPos p MkSet aMkSet
    (T.uwrapForward p
      (haddToFM (gset T.mkNoSrcPos p) fa
        (T.con0 T.mkNoSrcPos p T.Tuple0 T.aTuple0) p))
  where
  
  gset pset p = T.uconstUse pset p sset
  
  sset = T.uconstDef p a0v0set (\ p -> T.projection T.mkNoSrcPos p fset)
  
haddToSet _ _ p = T.fatal p

gdelFromSet ::
  Ord a => T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Set a) (T.Fun a (Set a)))

hdelFromSet :: Ord a => (T.R (Set a)) -> (T.R a) -> T.RefExp -> T.R (Set a)

gdelFromSet pdelFromSet p = T.ufun2 adelFromSet pdelFromSet p hdelFromSet

hdelFromSet (T.R (MkSet fset) _) fa p =
  T.con1 T.mkNoSrcPos p MkSet aMkSet
    (T.uwrapForward p (hdelFromFM (gset T.mkNoSrcPos p) fa p))
  where
  
  gset pset p = T.uconstUse pset p sset
  
  sset = T.uconstDef p a0v0set (\ p -> T.projection T.mkNoSrcPos p fset)
  
hdelFromSet _ _ p = T.fatal p

gelementOf ::
  Ord a => T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun (Set a) Bool))

helementOf :: Ord a => (T.R a) -> (T.R (Set a)) -> T.RefExp -> T.R Bool

gelementOf pelementOf p = T.ufun2 aelementOf pelementOf p helementOf

helementOf fx (T.R (MkSet fset) _) p =
  T.uwrapForward p
    (hisJust (T.uwrapForward p (hlookupFM (gset T.mkNoSrcPos p) fx p)) p)
  where
  
  gset pset p = T.uconstUse pset p sset
  
  sset = T.uconstDef p a0v0set (\ p -> T.projection T.mkNoSrcPos p fset)
  
helementOf _ _ p = T.fatal p

gisEmptySet :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Set a) Bool)

hisEmptySet :: (T.R (Set a)) -> T.RefExp -> T.R Bool

gisEmptySet pisEmptySet p = T.ufun1 aisEmptySet pisEmptySet p hisEmptySet

hisEmptySet (T.R (MkSet fset) _) p =
  T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p)
    (T.uwrapForward p (hsizeFM (gset T.mkNoSrcPos p) p))
    (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
      (T.conInteger T.mkNoSrcPos p 0))
  where
  
  gset pset p = T.uconstUse pset p sset
  
  sset = T.uconstDef p a0v0set (\ p -> T.projection T.mkNoSrcPos p fset)
  
hisEmptySet _ p = T.fatal p

gmapSet ::
  Ord a =>
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.Fun b a) (T.Fun (Set b) (Set a)))

hmapSet ::
  Ord a => (T.R (T.Fun b a)) -> (T.R (Set b)) -> T.RefExp -> T.R (Set a)

gmapSet pmapSet p = T.ufun2 amapSet pmapSet p hmapSet

hmapSet ff (T.R (MkSet fset) _) p =
  T.con1 T.mkNoSrcPos p MkSet aMkSet
    (T.uap1 T.mkNoSrcPos p (glistToFM T.mkNoSrcPos p)
      (T.uap1 T.mkNoSrcPos p
        (T.uap2 T.mkNoSrcPos p (Hat.Prelude.g_foldr T.mkNoSrcPos p)
          (T.ufun2 T.mkLambda T.mkNoSrcPos p
            (\ f_x f_y p ->
              T.uccase T.mkNoSrcPos p
                (let
                  v0v0v1 fkey p =
                    T.uap1 T.mkNoSrcPos p
                      (T.pa1 T.Cons T.cn1 T.mkNoSrcPos p T.aCons
                        (T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
                          (T.uap1 T.mkNoSrcPos p ff fkey)
                          (T.con0 T.mkNoSrcPos p T.Tuple0 T.aTuple0))) f_y
                  v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y in (v0v0v1))
                f_x)) (T.uwrapForward p (hkeysFM (gset T.mkNoSrcPos p) p)))
        (T.fromExpList T.mkNoSrcPos p [])))
  where
  
  gset pset p = T.uconstUse pset p sset
  
  sset = T.uconstDef p a0v0set (\ p -> T.projection T.mkNoSrcPos p fset)
  
hmapSet _ _ p = T.fatal p

gcardinality :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Set a) Int)

hcardinality :: (T.R (Set a)) -> T.RefExp -> T.R Int

gcardinality pcardinality p = T.ufun1 acardinality pcardinality p hcardinality

hcardinality (T.R (MkSet fset) _) p =
  T.uwrapForward p (hsizeFM (gset T.mkNoSrcPos p) p)
  where
  
  gset pset p = T.uconstUse pset p sset
  
  sset = T.uconstDef p a0v0set (\ p -> T.projection T.mkNoSrcPos p fset)
  
hcardinality _ p = T.fatal p

instance Eq a => Eq ((Set a))
  where
  
  (!==) (%==) p =
    T.ufun2 (+^%=#^==) (%==) p (*==)
    where
    
    (*==) (T.R (MkSet fset_1) _) (T.R (MkSet fset_2) _) p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) (gset_1 T.mkNoSrcPos p)
        (gset_2 T.mkNoSrcPos p)
      where
      
      gset_1 pset_1 p = T.uconstUse pset_1 p sset_1
      
      sset_1 =
        T.uconstDef p a0v0set_1 (\ p -> T.projection T.mkNoSrcPos p fset_1)
      
      gset_2 pset_2 p = T.uconstUse pset_2 p sset_2
      
      sset_2 =
        T.uconstDef p a0v0set_2 (\ p -> T.projection T.mkNoSrcPos p fset_2)
      
    (*==) _ _ p = T.fatal p
    
  
  (!/=) (%/=) p =
    T.ufun2 (+^&=#^/=) (%/=) p (*/=)
    where
    
    (*/=) (T.R (MkSet fset_1) _) (T.R (MkSet fset_2) _) p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/= p) (gset_1 T.mkNoSrcPos p)
        (gset_2 T.mkNoSrcPos p)
      where
      
      gset_1 pset_1 p = T.uconstUse pset_1 p sset_1
      
      sset_1 =
        T.uconstDef p a0v0set_1 (\ p -> T.projection T.mkNoSrcPos p fset_1)
      
      gset_2 pset_2 p = T.uconstUse pset_2 p sset_2
      
      sset_2 =
        T.uconstDef p a0v0set_2 (\ p -> T.projection T.mkNoSrcPos p fset_2)
      
    (*/=) _ _ p = T.fatal p
    
  

tData_Set = T.mkModule "Data.Set" "Data/Set.hs" Prelude.False

aMkSet = T.mkConstructor tData_Set 270017 3 1 "MkSet"

aemptySet = T.mkVariable tData_Set 300001 3 0 "emptySet" Prelude.False

aunitSet = T.mkVariable tData_Set 330001 3 1 "unitSet" Prelude.False

asetToList = T.mkVariable tData_Set 360001 3 1 "setToList" Prelude.False

amkSet = T.mkVariable tData_Set 390001 3 1 "mkSet" Prelude.False

aunion = T.mkVariable tData_Set 420001 3 2 "union" Prelude.False

aunionManySets = T.mkVariable tData_Set 450001 3 1 "unionManySets" Prelude.False

aminusSet = T.mkVariable tData_Set 480001 3 2 "minusSet" Prelude.False

aintersect = T.mkVariable tData_Set 510001 3 2 "intersect" Prelude.False

aaddToSet = T.mkVariable tData_Set 540001 3 2 "addToSet" Prelude.False

adelFromSet = T.mkVariable tData_Set 570001 3 2 "delFromSet" Prelude.False

aelementOf = T.mkVariable tData_Set 600001 3 2 "elementOf" Prelude.False

aisEmptySet = T.mkVariable tData_Set 630001 3 1 "isEmptySet" Prelude.False

amapSet = T.mkVariable tData_Set 660001 3 2 "mapSet" Prelude.False

acardinality = T.mkVariable tData_Set 690001 3 1 "cardinality" Prelude.False

(+^%=#^==) = T.mkVariable tData_Set 730017 16 2 "==" Prelude.False

(+^&=#^/=) = T.mkVariable tData_Set 740017 16 2 "/=" Prelude.False

a0v0set = T.mkVariable tData_Set 0 3 0 "set" Prelude.True

a0v0set1 = T.mkVariable tData_Set 0 3 0 "set1" Prelude.True

a0v0set2 = T.mkVariable tData_Set 0 3 0 "set2" Prelude.True

a0v0set_1 = T.mkVariable tData_Set 0 3 0 "set_1" Prelude.True

a0v0set_2 = T.mkVariable tData_Set 0 3 0 "set_2" Prelude.True
