
#define _GNU_SOURCE

#include <stdlib.h>
#include <stdarg.h>
#include <stdio.h>
#include <unistd.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "log.h"

#ifdef LOGFILE
static const char *logfile = LOGFILE;
static int log_fd = -1;
#endif

static int loglevel =
#ifdef DEBUG
	LOG_NOISY;
#else
	LOG_NORMAL;
#endif

/* print a message to the log file */
static void __log_vprintf (int fd,int level,const char *file,const char *function,int line,const char *fmt,va_list ap)
{
   struct tm *tv;
   time_t tc;
   if (loglevel < level || level == LOG_QUIET) return;
   if (!isatty (fd))
	 {
		tc = time (NULL);
		tv = localtime (&tc);
		dprintf (fd,"%.2d/%.2d/%.4d %.2d:%.2d:%.2d ",tv->tm_mday,tv->tm_mon,tv->tm_year + 1900,tv->tm_hour,tv->tm_min,tv->tm_sec);
	 }
   vdprintf (fd,fmt,ap);
   fsync (fd);
}

#ifdef LOGFILE
static void __log_printf (int fd,int level,const char *file,const char *function,int line,const char *fmt, ...)
{
   va_list ap;
   va_start (ap,fmt);
   __log_vprintf (fd,level,file,function,line,fmt,ap);
   va_end (ap);
}
#endif

/* initialize logging */
void log_init (int level)
{
#ifdef LOGFILE
   if ((log_fd = open (logfile,O_CREAT | O_APPEND | O_WRONLY | O_SYNC,S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH)) < 0)
	 {
		__log_printf (STDERR_FILENO,LOG_ERROR,__FILE__,__FUNCTION__,__LINE__,"Couldn't open logfile: %s.\n",logfile);
		exit (1);
	 }
#endif
   loglevel = level;
   log_printf (LOG_VERBOSE,"Starting to log output.\n");
}

/* cleanup logging */
void log_close ()
{
   log_printf (LOG_VERBOSE,"Stopped logging output.\n");
#ifdef LOGFILE
   if (log_fd > 0) close (log_fd);
   log_fd = -1;
#endif
}

/* closes and reopens the log file if necessary */
void log_reset ()
{
#ifdef LOGFILE
   if (log_fd > 0)
	 {
		log_close ();
		log_init (loglevel);
	 }
#endif
}

/* print a message to the log file */
void log_vprintf_stub (int level,const char *file,const char *function,int line,const char *fmt,va_list ap)
{
   int fd = STDOUT_FILENO;
   if (level == LOG_WARNING || LOG_ERROR) fd = STDERR_FILENO;
#ifdef LOGFILE
   if (log_fd > 0) fd = log_fd;
#endif
   __log_vprintf (fd,level,file,function,line,fmt,ap);
}

/* print a message to the log file */
void log_printf_stub (int level,const char *file,const char *function,int line,const char *fmt, ...)
{
   va_list ap;
   va_start (ap,fmt);
   log_vprintf_stub (level,file,function,line,fmt,ap);
   va_end (ap);
}

