/*********************************************************************
 * $Id: main.c,v 1.5 2000/12/02 20:40:30 orjana Exp $
 * Filename:      main.c
 * Description:   Spawn two threads; a GUI and a led-state thread
 * Status:        Experimental, do not distribute.
 * Author:        rjan Nygaard Austvold <austvold@acm.org>
 * Created at:    Mon Nov 24 20:52:39 2000
 * Modified at:   Sat Dec  2 21:05:45 2000
 * Modified by:   rjan Nygaard Austvold <austvold@acm.org>
 *                
 * Copyright (c) 2000 rjan Nygaard Austvold, All Rights Reserved.
 *                
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 ********************************************************************/

#include "common.h"
#include "led_thread.h"
#include "gui_thread.h"

extern gint errno;

gint led_pipe[2];
gboolean gui_is_up = FALSE;
pthread_t led_th;
led_thread_arg_t led_thread_arg;

int
main(gint argc, gchar **argv)
{

  /* initialize i18n */
#ifdef ENABLE_NLS
  (void) setlocale (LC_ALL, "");
  (void) bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  (void) textdomain (PACKAGE);
#endif

  /* set a common error handler */
  (void) g_log_set_handler (NULL, G_LOG_FLAG_FATAL | G_LOG_FLAG_RECURSION
			    | G_LOG_LEVEL_ERROR    | G_LOG_LEVEL_CRITICAL
			    | G_LOG_LEVEL_WARNING  | G_LOG_LEVEL_MESSAGE
			    | G_LOG_LEVEL_INFO     | G_LOG_LEVEL_DEBUG,
			    error_handler, NULL);

  /* create a pipe for delivery of updated led state to the GUI thread */
  if (pipe(led_pipe) != 0)
    g_error ("pipe(): %s", sys_errlist[MIN(errno, sys_nerr - 1)]);

  /* initialize the applet library, gnome and corba */
  if (applet_widget_init (PACKAGE, VERSION, argc, argv, NULL, 0, NULL) != TRUE)
    g_error(_("Couldn't initialize the applet library, gnome or corba!"));
  gui_is_up = TRUE;

  led_thread_arg.display_name = gdk_get_display();

  /* create and spawn a ledstate thread */
  if (pthread_create (&led_th, NULL, (void*)&led_thread, &led_thread_arg) !=0)
    g_error(_("Couldn't create led thread!"));

  /* let the main thread handle gui and sleep in the gui-mainloop */
  gui_thread();

  return 0;
}
