/*********************************************************************
 * $Id: properties.h,v 1.2 2000/11/27 17:24:46 orjana Exp $
 * Filename:      properties.h
 * Status:        Experimental, do not distribute.
 * Author:        rjan Nygaard Austvold <austvold@acm.org>
 * Created at:    Mon Nov 27 16:05:39 2000
 * Modified at:   Mon Nov 27 18:13:58 2000
 * Modified by:   rjan Nygaard Austvold <austvold@acm.org>
 *                
 * Copyright (c) 2000 rjan Nygaard Austvold, All Rights Reserved.
 *                
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 ********************************************************************/

#ifndef PROPERTIES_H
#define PROPERTIES_H 1

#include "common.h"

/* configuration of the min-, max-, and aspect-spinbuttons */
#define MIN_MIN  3
#define MIN_MAX  256
#define MIN_SINC 1
#define MIN_PINC 10
#define MIN_PSZ  10
#define MAX_MIN  3
#define MAX_MAX  256
#define MAX_SINC 1
#define MAX_PINC 10
#define MAX_PSZ  10
#define ASP_MIN  0.1
#define ASP_MAX  100
#define ASP_SINC 0.01
#define ASP_PINC 1
#define ASP_PSZ  1

/* various indices to the labels array */
#define NUM_CHK                0
#define CAPS_CHK               1
#define SCROLL_CHK             2
#define DEFAULT_CHK            3
#define MIN_CHK                4
#define MAX_CHK                5
#define OPTIMIZE_CHK           6

#define PROPERTY_DIALOG_TITLE  7
#define PROPERTY_GENERAL_PAGE  8
#define PROPERTY_IMAGES_PAGE   9
#define PROPERTY_SIZE_FRAME    10
#define PROPERTY_DISPLAY_FRAME 11
#define PROPERTY_ASPECT_RATIO  12

#define FILE_DIALOG_TITLE      13
#define PIXMAP_FILE_LABEL_BASE 14

struct _settings {
  gboolean use_default;
  gboolean minimum_checked;
  gboolean maximum_checked;
  gboolean optimize_checked;
  gboolean lock_key_checked[3];
  gchar *pixmap_file[6];
  gint minimum;
  gint maximum;
  gfloat aspect_ratio;
};

void callback_properties (AppletWidget *applet, gpointer data);

GtkWidget * general_page (void);

GtkWidget * images_page (void);

void save_properties (const gchar *path);

void load_properties (const gchar *path);

void configure_property_window (void);

void control_active_widgets (void);

void check_and_set_lock_toggles_sensitivity (void);

void on_default_checkbutton_toggled (GtkToggleButton *togglebutton,
				     gpointer user_data);
void on_min_checkbutton_toggled (GtkToggleButton *togglebutton,
				 gpointer user_data);
void on_max_checkbutton_toggled (GtkToggleButton *togglebutton,
				 gpointer user_data);
void on_min_spinbutton_changed (GtkSpinButton *spinbutton, gpointer user_data);

void on_max_spinbutton_changed (GtkSpinButton *spinbutton, gpointer user_data);

void on_lock_key_checkbutton_toggled (GtkToggleButton *togglebutton,
				 gpointer user_data);
void property_apply_callback (GnomePropertyBox *property_box, gint page_num);

void property_help_callback (GnomePropertyBox *property_box, gint page_num);

gint property_destroy_callback (GtkWidget *widget, void *data);

#endif
