/* ----------------------------------------------------------------------
LIGGGHTS - LAMMPS Improved for General Granular and Granular Heat
Transfer Simulations

www.liggghts.com | www.cfdem.com
Christoph Kloss, christoph.kloss@cfdem.com

LIGGGHTS is based on LAMMPS
LAMMPS - Large-scale Atomic/Molecular Massively Parallel Simulator
http://lammps.sandia.gov, Sandia National Laboratories
Steve Plimpton, sjplimp@sandia.gov

Copyright (2003) Sandia Corporation. Under the terms of Contract
DE-AC04-94AL85000 with Sandia Corporation, the U.S. Government retains
certain rights in this software. This software is distributed under
the GNU General Public License.

See the README file in the top-level LAMMPS directory.
------------------------------------------------------------------------- */

#ifdef FIX_CLASS

FixStyle(couple/cfd/force,FixCfdCouplingForce)
FixStyle(couple/cfd/dragforce,FixCfdCouplingForce)

#else

#ifndef LMP_FIX_CFD_COUPLING_FORCE_H
#define LMP_FIX_CFD_COUPLING_FORCE_H

#include "fix_cfd_coupling.h"

namespace LAMMPS_NS {

class FixCfdCouplingForce : public Fix  {
 public:
  FixCfdCouplingForce(class LAMMPS *, int, char **);
  ~FixCfdCouplingForce();
  void post_create();
  void pre_delete();

  int setmask();
  virtual void init();
  void post_force(int);
  double compute_vector(int n);

 protected:
  double dragforce_total[3];
  class FixCfdCoupling* fix_coupling_;
  class FixPropertyAtom* fix_dragforce_;
  class FixPropertyAtom* fix_volumeweight_;
};

}

#endif
#endif
