/*b
 * Copyright (C) 2001,2002  Rick Richardson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Rick Richardson <rickr@mn.rr.com>
b*/

/*
 * Display the Island Level II book
 *
 * Incomplete.
 *
 * TODO: replace the linear search/insert/delete with a linked list
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <ncurses.h>
#include <panel.h>
#include <errno.h>
#include <time.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include "curse.h"
#include "error.h"
#include "rc.h"
#include "streamer.h"
#include "linuxtrade.h"
#include "island.h"
#include "util.h"

static WINDOW	*Win;
static WINDOW	*Hdrwin;
static WINDOW	*Subwin;
static PANEL	*Panel;
static char	Symbol[SYMLEN+1];

/*
 * Book
 */
#define IDLEN	16
#define MMLEN	8

typedef struct
{
	char	id[IDLEN+1];
	char	mmid[MMLEN+1];
	int	decicents;
	int	size;
	int	hh, mm, ss;
} BOOKE;

#define		NUMBOOK	2000
#define		NUMSET	5

typedef struct
{
	int	num;
	int	size;
} SET;

typedef struct
{
	int	num;
	int	total;
	SET	set[NUMSET];
	BOOKE	ent[NUMBOOK];
} BOOK;

static BOOK	Ask, Bid;

static attr_t SetColors[NUMSET] =
{
	COLOR_PAIR(BLACKonGREEN),
	COLOR_PAIR(BLACKonYELLOW),
	COLOR_PAIR(BLACKonCYAN),
	A_REVERSE|COLOR_PAIR(REDonWHITE),
	A_REVERSE|COLOR_PAIR(BLUEonWHITE)
};

/*
 * Stream buffer
 */
static int	Fd = -1;
static FILE	*Fp = NULL;
static int	DataState = 0;

int
island_open(void)
{
	struct hostent		*hep;
	struct sockaddr_in	sockaddr;
	int			afd;
	int			rc;
	int			port;

	hep = mygethostbyname(get_rc_value(RcFile, "island_host"));
	if (!hep)
		return (-1);

	memcpy(&sockaddr.sin_addr, hep->h_addr, hep->h_length);
	sockaddr.sin_family = AF_INET;

	port = atoi(get_rc_value(RcFile, "island_port"));
	sockaddr.sin_port = htons(port);

	afd = socket(AF_INET, SOCK_STREAM, 0);
	if (afd < 0)
		return -2;

	rc = connect_timeout(afd, (SA *) &sockaddr, sizeof(sockaddr), 8);
	if (rc < 0)
		return -3;

	Bid.num = Ask.num = 0;

	return (afd);
}

int
island_fd(void)
{
	return (Fd);
}

static void
calc_bar(BOOK *b)
{
	int	i;
	int	n = -1;
	int	last = -1;

	b->total = 0;
	for (i = 0; i < b->num; ++i)
	{
		BOOKE	*e = &b->ent[i];

		b->total += e->size;
		if (n < (NUMSET-1) && e->decicents != last)
		{
			++n;
			last = e->decicents;
			b->set[n].size = e->size;
			b->set[n].num = 1;
		}
		else
		{
			b->set[n].size += e->size;
			++b->set[n].num;
		}
	}
	while (++n < NUMSET)
	{
		b->set[n].size = 0;
		b->set[n].num = 0;
	}
}

static void
disp_bar(void)
{
	int	i, x;
	int	total;
	int	barcols = (getmaxx(Hdrwin) - 1) & ~1;
	int	bidcols, askcols;

	calc_bar(&Ask);
	calc_bar(&Bid);

	total = Ask.total + Bid.total;

	wblankrect(Hdrwin, 1, 0, 1, getmaxx(Hdrwin)-1, FALSE);
	if (total == 0)
	{
		return;
	}
	else if (Ask.total == 0)
	{
		askcols = 0;
		bidcols = barcols;
	}
	else if (Bid.total == 0)
	{
		bidcols = 0;
		askcols = barcols;
	}
	else
	{
		bidcols = lrint((double)barcols * Bid.total / total);
		askcols = lrint((double)barcols * Ask.total / total);
	}

	wattrset(Hdrwin, A_REVERSE);
	mvwaddch(Hdrwin, 1, bidcols, ACS_VLINE);

	if (bidcols)
	{
		x = bidcols;
		for (i = 0; i < NUMSET; ++i)
		{
			int	cols;

			cols = lrint((double)bidcols * Bid.set[i].size
							/ Bid.total);
			if (cols == 0 && Bid.set[i].size)
				cols = 1;

			wattrset(Hdrwin, SetColors[i]);
			while (cols--)
				mvwaddch(Hdrwin, 1, --x, ' ');
		}
	}

	if (askcols)
	{
		x = bidcols;
		for (i = 0; i < NUMSET; ++i)
		{
			int	cols;

			cols = lrint((double)askcols * Ask.set[i].size
							/ Ask.total);
			if (cols == 0 && Ask.set[i].size)
				cols = 1;

			wattrset(Hdrwin, SetColors[i]);
			while (cols--)
				mvwaddch(Hdrwin, 1, ++x, ' ');
		}
	}
	wattrset(Hdrwin, A_NORMAL);
}

static void
disp_book(BOOK *b)
{
	int	y, x;
	int	maxy = getmaxy(Subwin) - 1;
	int	n = -1;
	int	last = -1;
	int	incnt = 0;
	int	insize = 0;
	int	remain;

	x = (b == &Bid) ? 0 : getmaxx(Subwin)/3;

	for (y = 0; y < maxy; ++y)
	{
		BOOKE	*e = &b->ent[y];

		if (y < b->num)
		{
			if (e->decicents != last)
			{
				if (++n == NUMSET) n = NUMSET - 1;
				last = e->decicents;
			}
			if (n == 0)
			{
				++incnt;
				insize += e->size;
			}
			wattrset(Subwin, SetColors[n]);
			if (e->decicents < 100*10)
				mvwprintw(Subwin, y, x,
					"%'7d %8.3f",
					e->size, e->decicents/1000.0);
			else
				mvwprintw(Subwin, y, x,
					"%'7d %8.2f",
					e->size, e->decicents/1000.0);
		}
		else
			mvwprintw(Subwin, y, x, "%*s",
					getmaxx(Subwin)/3, "");
		wattrset(Subwin, A_NORMAL);
	}

	if (b->num == 0)
		mvwprintw(Subwin, 0, x, "     (none)");

	remain = b->num - maxy;
	if (remain > 0)
		mvwprintw(Subwin, y, x, "%d more", remain);
	else
		mvwprintw(Subwin, y, x, "          ");

	x = (b == &Bid) ? 0 : getmaxx(Subwin)/2;
	mvwprintw(Hdrwin, 0, x+8, "%3d", incnt);
	mvwprintw(Hdrwin, 0, x+21, "%7d", insize);
	disp_bar();

}

static unsigned int
getN(FILE *fp, int n)
{
	unsigned int	val = 0;
	int		s = 0;

	while (n--)
	{
		int	c;

		c = getc(fp);
		if (c == EOF)
			return 0x1;
		val |= (c&0xff) << s;
		s += 8;
	}
	return val;
}

static void
island_S(void)
{
	int	time;
	int	bid_count;
	int	ask_count;
	int	order_count;
	int	volume;
	int	last_price;
	int	last_time;
	int	tmp;
	int	share_size;
	int	price_size;
	int	base_price;

	int	i;

	time = getN(Fp, 3);

	bid_count = getN(Fp, 2);
	ask_count = getN(Fp, 2);
	order_count = getN(Fp, 3);
	volume = getN(Fp, 4);
	last_price = getN(Fp, 3);
	last_time = getN(Fp, 3);

	tmp = getN(Fp, 1);
	Bid.num = (tmp>>4) & 0x0f;
	Ask.num = (tmp>>0) & 0x0f;

	tmp = getN(Fp, 1);
	share_size = (tmp>>4) & 0x0f;
	price_size = (tmp>>0) & 0x0f;
	base_price = getN(Fp, 4);

	for (i = 0; i < Bid.num; ++i)
	{
		int	shares, price;
		shares = getN(Fp, share_size);
		price = getN(Fp, price_size) - base_price;
		if (price < 0) price = -price;

		// price = lrint((price * 100) / 1248.0);
		price = lrint((price * 100) / 100.0);
		Bid.ent[i].decicents = price;
		Bid.ent[i].size = shares;
	}

	for (i = 0; i < Ask.num; ++i)
	{
		int	shares, price;
		shares = getN(Fp, share_size);
		price = getN(Fp, price_size) + base_price;
		if (price < 0) price = -price;

		// price = lrint((price * 100) / 1248.0);
		price = lrint((price * 100) / 100.0);
		Ask.ent[i].decicents = price;
		Ask.ent[i].size = shares;
	}

	disp_book(&Bid);
	disp_book(&Ask);

	if (last_price < 1000)
		mvwprintw(Subwin, 0, 2*getmaxx(Subwin)/3,
			"%-7.3f  %02d:%02d:%02d",
			last_price/1000.0,
			last_time / 3600,
			(last_time / 60) % 60,
			last_time % 60);
	else
		mvwprintw(Subwin, 0, 2*getmaxx(Subwin)/3,
			"%-7.2f  %02d:%02d:%02d",
			last_price/1000.0,
			last_time / 3600,
			(last_time / 60) % 60,
			last_time % 60);

	mvwprintw(Subwin, 2, 2*getmaxx(Subwin)/3, "Orders:  %'d", order_count);
	mvwprintw(Subwin, 3, 2*getmaxx(Subwin)/3, "Volume:  %'d", volume);
	mvwprintw(Subwin, 4, 2*getmaxx(Subwin)/3, "As of:   %02d:%02d:%02d\n",
			time / 3600, (time / 60) % 60, time % 60);

	if (bid_count > 15)
		mvwprintw(Subwin, getmaxy(Subwin)-1, 0*getmaxx(Subwin)/3,
				"... %d more ...", bid_count - 15);
	else
		mvwprintw(Subwin, getmaxy(Subwin)-1, 0*getmaxx(Subwin)/3,
				"%*s", getmaxx(Subwin)/3, "");
	if (ask_count > 15)
		mvwprintw(Subwin, getmaxy(Subwin)-1, 1*getmaxx(Subwin)/3,
				"... %d more ...", ask_count - 15);
	else
		mvwprintw(Subwin, getmaxy(Subwin)-1, 1*getmaxx(Subwin)/3,
				"%*s", getmaxx(Subwin)/3, "");
}

void
island_data(void)
{
	char	buf[BUFSIZ];

	if (Fd < 0 || !Fp)
		return;

	for (;;)
	{
		switch (DataState)
		{
		case 0:
			// EAT initial HTTP response
			if (fgets(buf, sizeof(buf), Fp) == NULL)
			{
			errout:
				mvwprintw(Hdrwin, 2, 0,
					"Error reading Island");
				fclose(Fp);
				Fd = -1;
				Fp = NULL;
				goto out;
			}
			if (strcmp(buf, "\n") == 0 || strcmp(buf, "\r\n") == 0)
				DataState = 1;
			break;
		case 1:
			switch (fgetc(Fp))
			{
			case 'S':
				island_S();
				break;
			case 'H':
				fgetc(Fp);
				fgetc(Fp);
				fgetc(Fp);
				break;
			case 'N':
				break;
			case EOF:
				goto errout;
			default:
				break;
			}
			break;
		}

		// If stdio has no more data in its buffers, then
		// return.  The next select() will call us later.
		if (!FRcnt(Fp))
			break;
	}

out:
	touchwin(Win);
	update_panels(); refresh(); // doupdate();
}

static void
load_dummy_data(void)
{
}

void
island_popup(STOCK *sp)
{
	int	rc, len;
	char	buf[BUFSIZ];
	char	*title = "Island L2";

	Win = bestwin(22);
	if (!Win)
		error(1, "Can't create island window\n");

	wbkgd(Win, Reverse ? A_REVERSE : A_NORMAL);

	box(Win, 0, 0);

	wattrset(Win, A_BOLD);
	mvwprintw(Win, 0, 3, "%s", sp->sym);
	mvwprintw(Win, 0, getmaxx(Win)-strlen(title)-3, title);
	wattrset(Win, A_NORMAL);

	Hdrwin = derwin(Win, 4, getmaxx(Win) - 2, 1, 1);
	if (!Hdrwin)
		error(1, "Can't create island hdrwindow\n");

	Subwin = derwin(Win,
			getmaxy(Win) - 2 - getmaxy(Hdrwin), getmaxx(Win) - 2,
			1 + getmaxy(Hdrwin), 1);
	if (!Subwin)
		error(1, "Can't create island subwindow\n");

	strcpy(Symbol, sp->sym);

	mvwprintw(Hdrwin, 0, 0,
			"Inside: %-3d BidSize: %d", 0, 0);
	mvwprintw(Hdrwin, 0, getmaxx(Hdrwin)/2,
			"Inside: %-3d AskSize: %d", 0, 0);

	wattrset(Hdrwin, A_BOLD);
	mvwprintw(Hdrwin, getmaxy(Hdrwin) - 1, 0,
			"BidSize BidPrice");
	mvwprintw(Hdrwin, getmaxy(Hdrwin) - 1, getmaxx(Hdrwin)/3,
			"AskSize AskPrice");
	mvwprintw(Hdrwin, getmaxy(Hdrwin) - 1, 2*getmaxx(Hdrwin)/3,
			"Last Match");
	wattrset(Hdrwin, A_NORMAL);

	Panel = new_panel(Win);

	attrset(A_BOLD);
	mvprintw(LINES-1, 0,
		"*** Please Wait - opening connection to Island.  ");
	attrset(A_NORMAL);
	update_panels(); refresh(); // doupdate();

	Fd = island_open();
	if (Fd < 0)
	{
		mvwprintw(Subwin, 1, 0, "Can't open Island streamer");
		goto out;
	}

	Fp = fdopen(Fd, "r");
	if (!Fp)
	{
		mvwprintw(Subwin, 1, 0, "Can't buffer Island streamer");
		goto out;
	}
	DataState = 0;

	len = sprintf(buf,
		"GET /SERVICE/SQUOTE?STOCK=%s HTTP/1.1\r\n"
		"User-Agent: Java(tm) 2 SDK, Standard Edition v1.4.0-beta3\r\n"
		"Host: newgritch.island.com\r\n"
		"Accept: text/html, image/gif, *; q=.2, */*; q=.2\r\n"
		"Connection: keep-alive\r\n"
		"\r\n",
		sp->sym);

	rc = write(Fd, buf, len);
	if (rc != len)
	{
		mvwprintw(Subwin, 1, 0, "Can't write Island streamer");
		goto out;
	}

	if (Debug)
		load_dummy_data();

out:
	blankrect(LINES-1, 0, LINES-1, COLS-1, 0);
	touchwin(Win);
}

static void
popdown(void)
{
	if (Fd >= 0)
	{
		close(Fd);
		Fd = -1;
		Fp = NULL;
	}

	hide_panel(Panel);
	update_panels();
	del_panel(Panel);
	delwin(Hdrwin);
	delwin(Subwin);
	delwin(Win);
}

int
island_command(int c, STREAMER sr)
{
	MEVENT	m;

	switch (c)
	{
	case KEY_MOUSE:
		if (getmouse(&m) != OK)
			break;

		// Ignore clicks in our window
		if (m.y >= getbegy(Win)
			&& m.y < getbegy(Win) + getmaxy(Win))
			break;

		// popdown and reprocess clicks in main window
		if (ungetmouse(&m) == OK)
			Ungetch = 1;
		popdown();
		return 2;

	case KEY_F(11):
		if (1) print_rect_troff(getbegy(Win), getbegx(Win),
				getmaxy(Win), getmaxx(Win),
				NULL, "screen.tr");
		break;

	default:
		popdown();
		return 2;
	}
	return 0;
}
