/* (C) Marcin Kwadrans <quar@vitea.pl> */

/*! \file board.h 
	\brief Zarządzanie planszą
*/

#ifndef __LW_BOARD_H
#define __LW_BOARD_H

#include <libxml/tree.h>

#include "row.h"
#include "boardset.h"

class LWRow;
class LWBoardSet;
class LWWizard;

/*! \class LWBoard
	\brief Zarządzanie planszą

	Na planszy znajdują się wiersze LWRow. Klasa umożliwia operowanie
	na strukturze planszy, umożliwia m.in. dodawanie, usuwanie, pobieranie wierszy
*/

class LWBoard {
private:
GSList *list_row;
GtkWidget *vbox;
GtkImage *zoominout;
GtkWidget *widget;
LWRow *dummy_row;
LWPiece *marked_piece;
LWType type;
guint piecesize;
gboolean enable_grid;
LWBoardSet *boardset;
LWWizard *wizard;
void init (LWType a_type);
void buildResizeBar ();
public:
LWBoard (LWType a_type);
LWBoard (LWBoardSet *a_boardset);
LWBoard (const LWBoard *board, LWType a_type);
~LWBoard ();
LWBoardSet *getBoardSet ();
void restoreFromXML (xmlNode *node);
void storeToXML (xmlNode *parent_node);
void addRow (LWRow *row);
void insertRowBefore (LWRow *row, LWRow *sibiling);
void removeRow (LWRow *row);
gint getRowIndex (LWRow *row);
LWRow *getRowNth (guint n);
GSList *getPieceList ();
void setSize (guint width, guint height);
guint getHeight ();
void setPieceSize (guint size);
guint getPieceSize ();
void enableGrid (gboolean enable);
gboolean isGridEnabled (); 
void clear ();
void markPiece (LWPiece *piece);
void unmarkPiece ();
LWWizard *getWizard ();
GtkWidget *getWidget ();
LWType getType();
gboolean isRowDummy (LWRow *row);
};

#endif
