/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIteratorFieldDelegate;
import java.text.DecimalFormatSymbols;
import java.text.DigitList;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import sun.text.resources.LocaleData;

public class DecimalFormat
extends NumberFormat {
    private static final int STATUS_INFINITE = 0;
    private static final int STATUS_POSITIVE = 1;
    private static final int STATUS_LENGTH = 2;
    private transient DigitList digitList = new DigitList();
    private String positivePrefix = "";
    private String positiveSuffix = "";
    private String negativePrefix = "-";
    private String negativeSuffix = "";
    private String posPrefixPattern;
    private String posSuffixPattern;
    private String negPrefixPattern;
    private String negSuffixPattern;
    private int multiplier = 1;
    private byte groupingSize = (byte)3;
    private boolean decimalSeparatorAlwaysShown = false;
    private transient boolean isCurrencyFormat = false;
    private DecimalFormatSymbols symbols = null;
    private boolean useExponentialNotation;
    private transient FieldPosition[] positivePrefixFieldPositions;
    private transient FieldPosition[] positiveSuffixFieldPositions;
    private transient FieldPosition[] negativePrefixFieldPositions;
    private transient FieldPosition[] negativeSuffixFieldPositions;
    private byte minExponentDigits;
    static final int currentSerialVersion = 2;
    private int serialVersionOnStream = 2;
    private static final char PATTERN_ZERO_DIGIT = '0';
    private static final char PATTERN_GROUPING_SEPARATOR = ',';
    private static final char PATTERN_DECIMAL_SEPARATOR = '.';
    private static final char PATTERN_PER_MILLE = '\u2030';
    private static final char PATTERN_PERCENT = '%';
    private static final char PATTERN_DIGIT = '#';
    private static final char PATTERN_SEPARATOR = ';';
    private static final char PATTERN_EXPONENT = 'E';
    private static final char PATTERN_MINUS = '-';
    private static final char CURRENCY_SIGN = '\u00a4';
    private static final char QUOTE = '\'';
    private static FieldPosition[] EmptyFieldPositionArray = new FieldPosition[0];
    static final int DOUBLE_INTEGER_DIGITS = 309;
    static final int DOUBLE_FRACTION_DIGITS = 340;
    static final long serialVersionUID = 864413376551465018L;
    private static Hashtable cachedLocaleData = new Hashtable(3);

    public DecimalFormat() {
        Locale locale = Locale.getDefault();
        String string = (String)cachedLocaleData.get(locale);
        if (string == null) {
            ResourceBundle resourceBundle = LocaleData.getLocaleElements(locale);
            String[] stringArray = resourceBundle.getStringArray("NumberPatterns");
            string = stringArray[0];
            cachedLocaleData.put(locale, string);
        }
        this.symbols = new DecimalFormatSymbols(locale);
        this.applyPattern(string, false);
    }

    public DecimalFormat(String string) {
        this.symbols = new DecimalFormatSymbols(Locale.getDefault());
        this.applyPattern(string, false);
    }

    public DecimalFormat(String string, DecimalFormatSymbols decimalFormatSymbols) {
        this.symbols = (DecimalFormatSymbols)decimalFormatSymbols.clone();
        this.applyPattern(string, false);
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        return this.format(d, stringBuffer, fieldPosition.getFieldDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer format(double d, StringBuffer stringBuffer, Format.FieldDelegate fieldDelegate) {
        boolean bl;
        if (Double.isNaN(d)) {
            int n = stringBuffer.length();
            stringBuffer.append(this.symbols.getNaN());
            fieldDelegate.formatted(0, NumberFormat.Field.INTEGER, NumberFormat.Field.INTEGER, n, stringBuffer.length(), stringBuffer);
            return stringBuffer;
        }
        boolean bl2 = bl = d < 0.0 || d == 0.0 && 1.0 / d < 0.0;
        if (bl) {
            d = -d;
        }
        if (this.multiplier != 1) {
            d *= (double)this.multiplier;
        }
        if (Double.isInfinite(d)) {
            if (bl) {
                this.append(stringBuffer, this.negativePrefix, fieldDelegate, this.getNegativePrefixFieldPositions(), NumberFormat.Field.SIGN);
            } else {
                this.append(stringBuffer, this.positivePrefix, fieldDelegate, this.getPositivePrefixFieldPositions(), NumberFormat.Field.SIGN);
            }
            int n = stringBuffer.length();
            stringBuffer.append(this.symbols.getInfinity());
            fieldDelegate.formatted(0, NumberFormat.Field.INTEGER, NumberFormat.Field.INTEGER, n, stringBuffer.length(), stringBuffer);
            if (bl) {
                this.append(stringBuffer, this.negativeSuffix, fieldDelegate, this.getNegativeSuffixFieldPositions(), NumberFormat.Field.SIGN);
            } else {
                this.append(stringBuffer, this.positiveSuffix, fieldDelegate, this.getPositiveSuffixFieldPositions(), NumberFormat.Field.SIGN);
            }
            return stringBuffer;
        }
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            this.digitList.set(d, this.useExponentialNotation ? this.getMaximumIntegerDigits() + this.getMaximumFractionDigits() : this.getMaximumFractionDigits(), !this.useExponentialNotation);
            return this.subformat(stringBuffer, fieldDelegate, bl, false);
        }
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        return this.format(l, stringBuffer, fieldPosition.getFieldDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer format(long l, StringBuffer stringBuffer, Format.FieldDelegate fieldDelegate) {
        boolean bl;
        boolean bl2 = bl = l < 0L;
        if (bl) {
            l = -l;
        }
        if (this.multiplier != 1 && this.multiplier != 0) {
            long l2;
            boolean bl3 = false;
            if (l < 0L) {
                l2 = Long.MIN_VALUE / (long)this.multiplier;
                bl3 = l < l2;
            } else {
                l2 = Long.MAX_VALUE / (long)this.multiplier;
                boolean bl4 = bl3 = l > l2;
            }
            if (bl3) {
                double d = bl ? -l : l;
                return this.format(d, stringBuffer, fieldDelegate);
            }
        }
        l *= (long)this.multiplier;
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            this.digitList.set(l, this.useExponentialNotation ? this.getMaximumIntegerDigits() + this.getMaximumFractionDigits() : 0);
            return this.subformat(stringBuffer, fieldDelegate, bl, true);
        }
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        CharacterIteratorFieldDelegate characterIteratorFieldDelegate = new CharacterIteratorFieldDelegate();
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof Long || object instanceof BigInteger && ((BigInteger)object).bitLength() < 64) {
            this.format(((Number)object).longValue(), stringBuffer, (Format.FieldDelegate)characterIteratorFieldDelegate);
        } else {
            if (object == null) {
                throw new NullPointerException("formatToCharacterIterator must be passed non-null object");
            }
            if (object instanceof Number) {
                this.format(((Number)object).doubleValue(), stringBuffer, (Format.FieldDelegate)characterIteratorFieldDelegate);
            } else {
                throw new IllegalArgumentException("Cannot format given Object as a Number");
            }
        }
        return characterIteratorFieldDelegate.getIterator(stringBuffer.toString());
    }

    private StringBuffer subformat(StringBuffer stringBuffer, Format.FieldDelegate fieldDelegate, boolean bl, boolean bl2) {
        char c;
        char c2 = this.symbols.getZeroDigit();
        int n = c2 - 48;
        char c3 = this.symbols.getGroupingSeparator();
        char c4 = c = this.isCurrencyFormat ? this.symbols.getMonetaryDecimalSeparator() : this.symbols.getDecimalSeparator();
        if (this.digitList.isZero()) {
            this.digitList.decimalAt = 0;
        }
        int n2 = stringBuffer.length();
        if (bl) {
            this.append(stringBuffer, this.negativePrefix, fieldDelegate, this.getNegativePrefixFieldPositions(), NumberFormat.Field.SIGN);
        } else {
            this.append(stringBuffer, this.positivePrefix, fieldDelegate, this.getPositivePrefixFieldPositions(), NumberFormat.Field.SIGN);
        }
        if (this.useExponentialNotation) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7 = stringBuffer.length();
            int n8 = -1;
            int n9 = -1;
            int n10 = this.digitList.decimalAt;
            int n11 = this.getMaximumIntegerDigits();
            int n12 = this.getMinimumIntegerDigits();
            if (n11 > 1 && n11 > n12) {
                n10 = n10 >= 1 ? (n10 - 1) / n11 * n11 : (n10 - n11) / n11 * n11;
                n12 = 1;
            } else {
                n10 -= n12;
            }
            int n13 = this.getMinimumIntegerDigits() + this.getMinimumFractionDigits();
            int n14 = n6 = this.digitList.isZero() ? n12 : this.digitList.decimalAt - n10;
            if (n13 < n6) {
                n13 = n6;
            }
            if (n13 > (n5 = this.digitList.count)) {
                n5 = n13;
            }
            boolean bl3 = false;
            for (n4 = 0; n4 < n5; ++n4) {
                if (n4 == n6) {
                    n8 = stringBuffer.length();
                    stringBuffer.append(c);
                    bl3 = true;
                    n9 = stringBuffer.length();
                }
                stringBuffer.append(n4 < this.digitList.count ? (char)(this.digitList.digits[n4] + n) : c2);
            }
            if (n8 == -1) {
                n8 = stringBuffer.length();
            }
            fieldDelegate.formatted(0, NumberFormat.Field.INTEGER, NumberFormat.Field.INTEGER, n7, n8, stringBuffer);
            if (bl3) {
                fieldDelegate.formatted(NumberFormat.Field.DECIMAL_SEPARATOR, NumberFormat.Field.DECIMAL_SEPARATOR, n8, n9, stringBuffer);
            }
            if (n9 == -1) {
                n9 = stringBuffer.length();
            }
            fieldDelegate.formatted(1, NumberFormat.Field.FRACTION, NumberFormat.Field.FRACTION, n9, stringBuffer.length(), stringBuffer);
            n2 = stringBuffer.length();
            stringBuffer.append(this.symbols.getExponentialSymbol());
            fieldDelegate.formatted(NumberFormat.Field.EXPONENT_SYMBOL, NumberFormat.Field.EXPONENT_SYMBOL, n2, stringBuffer.length(), stringBuffer);
            if (this.digitList.isZero()) {
                n10 = 0;
            }
            int n15 = n4 = n10 < 0 ? 1 : 0;
            if (n4 != 0) {
                n10 = -n10;
                this.append(stringBuffer, this.negativePrefix, fieldDelegate, this.getNegativePrefixFieldPositions(), NumberFormat.Field.EXPONENT_SIGN);
            } else {
                this.append(stringBuffer, this.positivePrefix, fieldDelegate, this.getPositivePrefixFieldPositions(), NumberFormat.Field.EXPONENT_SIGN);
            }
            this.digitList.set(n10);
            int n16 = stringBuffer.length();
            for (n3 = this.digitList.decimalAt; n3 < this.minExponentDigits; ++n3) {
                stringBuffer.append(c2);
            }
            for (n3 = 0; n3 < this.digitList.decimalAt; ++n3) {
                stringBuffer.append(n3 < this.digitList.count ? (char)(this.digitList.digits[n3] + n) : c2);
            }
            fieldDelegate.formatted(NumberFormat.Field.EXPONENT, NumberFormat.Field.EXPONENT, n16, stringBuffer.length(), stringBuffer);
            n2 = stringBuffer.length();
            if (n4 != 0) {
                this.append(stringBuffer, this.negativeSuffix, fieldDelegate, this.getNegativeSuffixFieldPositions(), NumberFormat.Field.EXPONENT_SIGN);
            } else {
                this.append(stringBuffer, this.positiveSuffix, fieldDelegate, this.getPositiveSuffixFieldPositions(), NumberFormat.Field.EXPONENT_SIGN);
            }
        } else {
            int n17;
            int n18;
            int n19 = stringBuffer.length();
            int n20 = this.getMinimumIntegerDigits();
            int n21 = 0;
            if (this.digitList.decimalAt > 0 && n20 < this.digitList.decimalAt) {
                n20 = this.digitList.decimalAt;
            }
            if (n20 > this.getMaximumIntegerDigits()) {
                n20 = this.getMaximumIntegerDigits();
                n21 = this.digitList.decimalAt - n20;
            }
            int n22 = stringBuffer.length();
            for (n18 = n20 - 1; n18 >= 0; --n18) {
                if (n18 < this.digitList.decimalAt && n21 < this.digitList.count) {
                    stringBuffer.append((char)(this.digitList.digits[n21++] + n));
                } else {
                    stringBuffer.append(c2);
                }
                if (!this.isGroupingUsed() || n18 <= 0 || this.groupingSize == 0 || n18 % this.groupingSize != 0) continue;
                n17 = stringBuffer.length();
                stringBuffer.append(c3);
                fieldDelegate.formatted(NumberFormat.Field.GROUPING_SEPARATOR, NumberFormat.Field.GROUPING_SEPARATOR, n17, stringBuffer.length(), stringBuffer);
            }
            int n23 = n18 = this.getMinimumFractionDigits() > 0 || !bl2 && n21 < this.digitList.count ? 1 : 0;
            if (n18 == 0 && stringBuffer.length() == n22) {
                stringBuffer.append(c2);
            }
            fieldDelegate.formatted(0, NumberFormat.Field.INTEGER, NumberFormat.Field.INTEGER, n19, stringBuffer.length(), stringBuffer);
            n17 = stringBuffer.length();
            if (this.decimalSeparatorAlwaysShown || n18 != 0) {
                stringBuffer.append(c);
            }
            if (n17 != stringBuffer.length()) {
                fieldDelegate.formatted(NumberFormat.Field.DECIMAL_SEPARATOR, NumberFormat.Field.DECIMAL_SEPARATOR, n17, stringBuffer.length(), stringBuffer);
            }
            int n24 = stringBuffer.length();
            for (int i = 0; i < this.getMaximumFractionDigits() && (i < this.getMinimumFractionDigits() || !bl2 && n21 < this.digitList.count); ++i) {
                if (-1 - i > this.digitList.decimalAt - 1) {
                    stringBuffer.append(c2);
                    continue;
                }
                if (!bl2 && n21 < this.digitList.count) {
                    stringBuffer.append((char)(this.digitList.digits[n21++] + n));
                    continue;
                }
                stringBuffer.append(c2);
            }
            fieldDelegate.formatted(1, NumberFormat.Field.FRACTION, NumberFormat.Field.FRACTION, n24, stringBuffer.length(), stringBuffer);
        }
        if (bl) {
            this.append(stringBuffer, this.negativeSuffix, fieldDelegate, this.getNegativeSuffixFieldPositions(), NumberFormat.Field.SIGN);
        } else {
            this.append(stringBuffer, this.positiveSuffix, fieldDelegate, this.getPositiveSuffixFieldPositions(), NumberFormat.Field.SIGN);
        }
        return stringBuffer;
    }

    private void append(StringBuffer stringBuffer, String string, Format.FieldDelegate fieldDelegate, FieldPosition[] fieldPositionArray, Format.Field field) {
        int n = stringBuffer.length();
        if (string.length() > 0) {
            stringBuffer.append(string);
            int n2 = fieldPositionArray.length;
            for (int i = 0; i < n2; ++i) {
                FieldPosition fieldPosition = fieldPositionArray[i];
                Format.Field field2 = fieldPosition.getFieldAttribute();
                if (field2 == NumberFormat.Field.SIGN) {
                    field2 = field;
                }
                fieldDelegate.formatted(field2, field2, n + fieldPosition.getBeginIndex(), n + fieldPosition.getEndIndex(), stringBuffer);
            }
        }
    }

    public Number parse(String string, ParsePosition parsePosition) {
        if (string.regionMatches(parsePosition.index, this.symbols.getNaN(), 0, this.symbols.getNaN().length())) {
            parsePosition.index += this.symbols.getNaN().length();
            return new Double(Double.NaN);
        }
        boolean[] blArray = new boolean[2];
        if (!this.subparse(string, parsePosition, this.digitList, false, blArray)) {
            return null;
        }
        double d = 0.0;
        long l = 0L;
        boolean bl = true;
        if (blArray[0]) {
            d = Double.POSITIVE_INFINITY;
        } else if (this.digitList.fitsIntoLong(blArray[1], this.isParseIntegerOnly())) {
            bl = false;
            l = this.digitList.getLong();
        } else {
            d = this.digitList.getDouble();
        }
        if (this.multiplier != 1) {
            if (bl) {
                d /= (double)this.multiplier;
            } else if (l % (long)this.multiplier == 0L) {
                l /= (long)this.multiplier;
            } else {
                d = (double)l / (double)this.multiplier;
                if (d < 0.0) {
                    d = -d;
                }
                bl = true;
            }
        }
        if (!blArray[1]) {
            d = -d;
            if (l > 0L) {
                l = -l;
            }
        }
        if (this.multiplier != 1 && bl) {
            l = (long)d;
            bl = d != (double)l || d == 0.0 && !blArray[1] && !this.isParseIntegerOnly();
        }
        return bl ? (Number)new Double(d) : (Number)new Long(l);
    }

    private final boolean subparse(String string, ParsePosition parsePosition, DigitList digitList, boolean bl, boolean[] blArray) {
        int n = parsePosition.index;
        int n2 = parsePosition.index;
        boolean bl2 = string.regionMatches(n, this.positivePrefix, 0, this.positivePrefix.length());
        boolean bl3 = string.regionMatches(n, this.negativePrefix, 0, this.negativePrefix.length());
        if (bl2 && bl3) {
            if (this.positivePrefix.length() > this.negativePrefix.length()) {
                bl3 = false;
            } else if (this.positivePrefix.length() < this.negativePrefix.length()) {
                bl2 = false;
            }
        }
        if (bl2) {
            n += this.positivePrefix.length();
        } else if (bl3) {
            n += this.negativePrefix.length();
        } else {
            parsePosition.errorIndex = n;
            return false;
        }
        blArray[0] = false;
        if (!bl && string.regionMatches(n, this.symbols.getInfinity(), 0, this.symbols.getInfinity().length())) {
            n += this.symbols.getInfinity().length();
            blArray[0] = true;
        } else {
            digitList.count = 0;
            digitList.decimalAt = 0;
            char c = this.symbols.getZeroDigit();
            char c2 = this.isCurrencyFormat ? this.symbols.getMonetaryDecimalSeparator() : this.symbols.getDecimalSeparator();
            char c3 = this.symbols.getGroupingSeparator();
            char c4 = this.symbols.getExponentialSymbol();
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            int n3 = 0;
            int n4 = 0;
            int n5 = -1;
            while (n < string.length()) {
                char c5 = string.charAt(n);
                int n6 = c5 - c;
                if (n6 < 0 || n6 > 9) {
                    n6 = Character.digit(c5, 10);
                }
                if (n6 == 0) {
                    n5 = -1;
                    bl6 = true;
                    if (digitList.count == 0) {
                        if (bl4) {
                            --digitList.decimalAt;
                        }
                    } else {
                        ++n4;
                        digitList.append((char)(n6 + 48));
                    }
                } else if (n6 > 0 && n6 <= 9) {
                    bl6 = true;
                    ++n4;
                    digitList.append((char)(n6 + 48));
                    n5 = -1;
                } else if (!bl && c5 == c2) {
                    if (this.isParseIntegerOnly() || bl4) break;
                    digitList.decimalAt = n4;
                    bl4 = true;
                } else if (!bl && c5 == c3 && this.isGroupingUsed()) {
                    if (bl4) break;
                    n5 = n;
                } else {
                    boolean[] blArray2;
                    DigitList digitList2;
                    ParsePosition parsePosition2;
                    if (bl || c5 != c4 || bl5 || !this.subparse(string, parsePosition2 = new ParsePosition(n + 1), digitList2 = new DigitList(), true, blArray2 = new boolean[2]) || !digitList2.fitsIntoLong(blArray2[1], true)) break;
                    n = parsePosition2.index;
                    n3 = (int)digitList2.getLong();
                    if (!blArray2[1]) {
                        n3 = -n3;
                    }
                    bl5 = true;
                    break;
                }
                ++n;
            }
            if (n5 != -1) {
                n = n5;
            }
            if (!bl4) {
                digitList.decimalAt = n4;
            }
            digitList.decimalAt += n3;
            if (!bl6 && n4 == 0) {
                parsePosition.index = n2;
                parsePosition.errorIndex = n2;
                return false;
            }
        }
        if (bl2) {
            bl2 = string.regionMatches(n, this.positiveSuffix, 0, this.positiveSuffix.length());
        }
        if (bl3) {
            bl3 = string.regionMatches(n, this.negativeSuffix, 0, this.negativeSuffix.length());
        }
        if (bl2 && bl3) {
            if (this.positiveSuffix.length() > this.negativeSuffix.length()) {
                bl3 = false;
            } else if (this.positiveSuffix.length() < this.negativeSuffix.length()) {
                bl2 = false;
            }
        }
        if (bl2 == bl3) {
            parsePosition.errorIndex = n;
            return false;
        }
        parsePosition.index = n + (bl2 ? this.positiveSuffix.length() : this.negativeSuffix.length());
        blArray[1] = bl2;
        if (parsePosition.index == n2) {
            parsePosition.errorIndex = n;
            return false;
        }
        return true;
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        try {
            return (DecimalFormatSymbols)this.symbols.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        try {
            this.symbols = (DecimalFormatSymbols)decimalFormatSymbols.clone();
            this.expandAffixes();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getPositivePrefix() {
        return this.positivePrefix;
    }

    public void setPositivePrefix(String string) {
        this.positivePrefix = string;
        this.posPrefixPattern = null;
        this.positivePrefixFieldPositions = null;
    }

    private FieldPosition[] getPositivePrefixFieldPositions() {
        if (this.positivePrefixFieldPositions == null) {
            this.positivePrefixFieldPositions = this.posPrefixPattern != null ? this.expandAffix(this.posPrefixPattern) : EmptyFieldPositionArray;
        }
        return this.positivePrefixFieldPositions;
    }

    public String getNegativePrefix() {
        return this.negativePrefix;
    }

    public void setNegativePrefix(String string) {
        this.negativePrefix = string;
        this.negPrefixPattern = null;
    }

    private FieldPosition[] getNegativePrefixFieldPositions() {
        if (this.negativePrefixFieldPositions == null) {
            this.negativePrefixFieldPositions = this.negPrefixPattern != null ? this.expandAffix(this.negPrefixPattern) : EmptyFieldPositionArray;
        }
        return this.negativePrefixFieldPositions;
    }

    public String getPositiveSuffix() {
        return this.positiveSuffix;
    }

    public void setPositiveSuffix(String string) {
        this.positiveSuffix = string;
        this.posSuffixPattern = null;
    }

    private FieldPosition[] getPositiveSuffixFieldPositions() {
        if (this.positiveSuffixFieldPositions == null) {
            this.positiveSuffixFieldPositions = this.posSuffixPattern != null ? this.expandAffix(this.posSuffixPattern) : EmptyFieldPositionArray;
        }
        return this.positiveSuffixFieldPositions;
    }

    public String getNegativeSuffix() {
        return this.negativeSuffix;
    }

    public void setNegativeSuffix(String string) {
        this.negativeSuffix = string;
        this.negSuffixPattern = null;
    }

    private FieldPosition[] getNegativeSuffixFieldPositions() {
        if (this.negativeSuffixFieldPositions == null) {
            this.negativeSuffixFieldPositions = this.negSuffixPattern != null ? this.expandAffix(this.negSuffixPattern) : EmptyFieldPositionArray;
        }
        return this.negativeSuffixFieldPositions;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(int n) {
        this.multiplier = n;
    }

    public int getGroupingSize() {
        return this.groupingSize;
    }

    public void setGroupingSize(int n) {
        this.groupingSize = (byte)n;
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.decimalSeparatorAlwaysShown;
    }

    public void setDecimalSeparatorAlwaysShown(boolean bl) {
        this.decimalSeparatorAlwaysShown = bl;
    }

    public Object clone() {
        try {
            DecimalFormat decimalFormat = (DecimalFormat)super.clone();
            decimalFormat.symbols = (DecimalFormatSymbols)this.symbols.clone();
            decimalFormat.digitList = (DigitList)this.digitList.clone();
            return decimalFormat;
        }
        catch (Exception exception) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DecimalFormat decimalFormat = (DecimalFormat)object;
        return (this.posPrefixPattern == decimalFormat.posPrefixPattern && this.positivePrefix.equals(decimalFormat.positivePrefix) || this.posPrefixPattern != null && this.posPrefixPattern.equals(decimalFormat.posPrefixPattern)) && (this.posSuffixPattern == decimalFormat.posSuffixPattern && this.positiveSuffix.equals(decimalFormat.positiveSuffix) || this.posSuffixPattern != null && this.posSuffixPattern.equals(decimalFormat.posSuffixPattern)) && (this.negPrefixPattern == decimalFormat.negPrefixPattern && this.negativePrefix.equals(decimalFormat.negativePrefix) || this.negPrefixPattern != null && this.negPrefixPattern.equals(decimalFormat.negPrefixPattern)) && (this.negSuffixPattern == decimalFormat.negSuffixPattern && this.negativeSuffix.equals(decimalFormat.negativeSuffix) || this.negSuffixPattern != null && this.negSuffixPattern.equals(decimalFormat.negSuffixPattern)) && this.multiplier == decimalFormat.multiplier && this.groupingSize == decimalFormat.groupingSize && this.decimalSeparatorAlwaysShown == decimalFormat.decimalSeparatorAlwaysShown && this.useExponentialNotation == decimalFormat.useExponentialNotation && (!this.useExponentialNotation || this.minExponentDigits == decimalFormat.minExponentDigits) && this.symbols.equals(decimalFormat.symbols);
    }

    public int hashCode() {
        return super.hashCode() * 37 + this.positivePrefix.hashCode();
    }

    public String toPattern() {
        return this.toPattern(false);
    }

    public String toLocalizedPattern() {
        return this.toPattern(true);
    }

    private void expandAffixes() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.posPrefixPattern != null) {
            this.positivePrefix = this.expandAffix(this.posPrefixPattern, stringBuffer);
            this.positivePrefixFieldPositions = null;
        }
        if (this.posSuffixPattern != null) {
            this.positiveSuffix = this.expandAffix(this.posSuffixPattern, stringBuffer);
            this.positiveSuffixFieldPositions = null;
        }
        if (this.negPrefixPattern != null) {
            this.negativePrefix = this.expandAffix(this.negPrefixPattern, stringBuffer);
            this.negativePrefixFieldPositions = null;
        }
        if (this.negSuffixPattern != null) {
            this.negativeSuffix = this.expandAffix(this.negSuffixPattern, stringBuffer);
            this.negativeSuffixFieldPositions = null;
        }
    }

    private String expandAffix(String string, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        int n = 0;
        block6: while (n < string.length()) {
            char c;
            if ((c = string.charAt(n++)) == '\'') {
                c = string.charAt(n++);
                switch (c) {
                    case '\u00a4': {
                        if (n < string.length() && string.charAt(n) == '\u00a4') {
                            ++n;
                            stringBuffer.append(this.symbols.getInternationalCurrencySymbol());
                            continue block6;
                        }
                        stringBuffer.append(this.symbols.getCurrencySymbol());
                        continue block6;
                    }
                    case '%': {
                        c = this.symbols.getPercent();
                        break;
                    }
                    case '\u2030': {
                        c = this.symbols.getPerMill();
                        break;
                    }
                    case '-': {
                        c = this.symbols.getMinusSign();
                    }
                }
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private FieldPosition[] expandAffix(String string) {
        ArrayList arrayList = null;
        int n = 0;
        int n2 = 0;
        block6: while (n2 < string.length()) {
            char c;
            if ((c = string.charAt(n2++)) == '\'') {
                Object object;
                int n3 = -1;
                NumberFormat.Field field = null;
                c = string.charAt(n2++);
                switch (c) {
                    case '\u00a4': {
                        if (n2 < string.length() && string.charAt(n2) == '\u00a4') {
                            ++n2;
                            object = this.symbols.getInternationalCurrencySymbol();
                        } else {
                            object = this.symbols.getCurrencySymbol();
                        }
                        if (((String)object).length() <= 0) continue block6;
                        if (arrayList == null) {
                            arrayList = new ArrayList(2);
                        }
                        FieldPosition fieldPosition = new FieldPosition(NumberFormat.Field.CURRENCY);
                        fieldPosition.setBeginIndex(n);
                        fieldPosition.setEndIndex(n + ((String)object).length());
                        arrayList.add(fieldPosition);
                        n += ((String)object).length();
                        continue block6;
                    }
                    case '%': {
                        c = this.symbols.getPercent();
                        n3 = -1;
                        field = NumberFormat.Field.PERCENT;
                        break;
                    }
                    case '\u2030': {
                        c = this.symbols.getPerMill();
                        n3 = -1;
                        field = NumberFormat.Field.PERMILLE;
                        break;
                    }
                    case '-': {
                        c = this.symbols.getMinusSign();
                        n3 = -1;
                        field = NumberFormat.Field.SIGN;
                    }
                }
                if (field != null) {
                    if (arrayList == null) {
                        arrayList = new ArrayList(2);
                    }
                    object = new FieldPosition(field, n3);
                    ((FieldPosition)object).setBeginIndex(n);
                    ((FieldPosition)object).setEndIndex(n + 1);
                    arrayList.add(object);
                }
            }
            ++n;
        }
        if (arrayList != null) {
            return (FieldPosition[])arrayList.toArray(EmptyFieldPositionArray);
        }
        return EmptyFieldPositionArray;
    }

    private void appendAffix(StringBuffer stringBuffer, String string, String string2, boolean bl) {
        if (string == null) {
            this.appendAffix(stringBuffer, string2, bl);
        } else {
            int n = 0;
            while (n < string.length()) {
                int n2 = string.indexOf(39, n);
                if (n2 < 0) {
                    this.appendAffix(stringBuffer, string.substring(n), bl);
                    break;
                }
                if (n2 > n) {
                    this.appendAffix(stringBuffer, string.substring(n, n2), bl);
                }
                char c = string.charAt(++n2);
                ++n2;
                if (c == '\'') {
                    stringBuffer.append(c);
                } else if (c == '\u00a4' && n2 < string.length() && string.charAt(n2) == '\u00a4') {
                    stringBuffer.append(c);
                } else if (bl) {
                    switch (c) {
                        case '%': {
                            c = this.symbols.getPercent();
                            break;
                        }
                        case '\u2030': {
                            c = this.symbols.getPerMill();
                            break;
                        }
                        case '-': {
                            c = this.symbols.getMinusSign();
                        }
                    }
                }
                stringBuffer.append(c);
                n = ++n2;
            }
        }
    }

    private void appendAffix(StringBuffer stringBuffer, String string, boolean bl) {
        boolean bl2;
        if (bl) {
            bl2 = string.indexOf(this.symbols.getZeroDigit()) >= 0 || string.indexOf(this.symbols.getGroupingSeparator()) >= 0 || string.indexOf(this.symbols.getDecimalSeparator()) >= 0 || string.indexOf(this.symbols.getPercent()) >= 0 || string.indexOf(this.symbols.getPerMill()) >= 0 || string.indexOf(this.symbols.getDigit()) >= 0 || string.indexOf(this.symbols.getPatternSeparator()) >= 0 || string.indexOf(this.symbols.getMinusSign()) >= 0 || string.indexOf(164) >= 0;
        } else {
            boolean bl3 = bl2 = string.indexOf(48) >= 0 || string.indexOf(44) >= 0 || string.indexOf(46) >= 0 || string.indexOf(37) >= 0 || string.indexOf(8240) >= 0 || string.indexOf(35) >= 0 || string.indexOf(59) >= 0 || string.indexOf(45) >= 0 || string.indexOf(164) >= 0;
        }
        if (bl2) {
            stringBuffer.append('\'');
        }
        if (string.indexOf(39) < 0) {
            stringBuffer.append(string);
        } else {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                stringBuffer.append(c);
                if (c != '\'') continue;
                stringBuffer.append(c);
            }
        }
        if (bl2) {
            stringBuffer.append('\'');
        }
    }

    private String toPattern(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i >= 0; --i) {
            int n;
            int n2;
            if (i == 1) {
                this.appendAffix(stringBuffer, this.posPrefixPattern, this.positivePrefix, bl);
            } else {
                this.appendAffix(stringBuffer, this.negPrefixPattern, this.negativePrefix, bl);
            }
            for (n2 = n = this.useExponentialNotation ? this.getMaximumIntegerDigits() : Math.max(this.groupingSize, this.getMinimumIntegerDigits()) + 1; n2 > 0; --n2) {
                if (n2 != n && this.isGroupingUsed() && this.groupingSize != 0 && n2 % this.groupingSize == 0) {
                    stringBuffer.append(bl ? this.symbols.getGroupingSeparator() : (char)',');
                }
                stringBuffer.append(n2 <= this.getMinimumIntegerDigits() ? (bl ? this.symbols.getZeroDigit() : (char)'0') : (bl ? this.symbols.getDigit() : (char)'#'));
            }
            if (this.getMaximumFractionDigits() > 0 || this.decimalSeparatorAlwaysShown) {
                stringBuffer.append(bl ? this.symbols.getDecimalSeparator() : (char)'.');
            }
            for (n2 = 0; n2 < this.getMaximumFractionDigits(); ++n2) {
                if (n2 < this.getMinimumFractionDigits()) {
                    stringBuffer.append(bl ? this.symbols.getZeroDigit() : (char)'0');
                    continue;
                }
                stringBuffer.append(bl ? this.symbols.getDigit() : (char)'#');
            }
            if (this.useExponentialNotation) {
                stringBuffer.append(bl ? this.symbols.getExponentialSymbol() : (char)'E');
                for (n2 = 0; n2 < this.minExponentDigits; ++n2) {
                    stringBuffer.append(bl ? this.symbols.getZeroDigit() : (char)'0');
                }
            }
            if (i == 1) {
                this.appendAffix(stringBuffer, this.posSuffixPattern, this.positiveSuffix, bl);
                if ((this.negSuffixPattern == this.posSuffixPattern && this.negativeSuffix.equals(this.positiveSuffix) || this.negSuffixPattern != null && this.negSuffixPattern.equals(this.posSuffixPattern)) && (this.negPrefixPattern != null && this.posPrefixPattern != null && this.negPrefixPattern.equals("'-" + this.posPrefixPattern) || this.negPrefixPattern == this.posPrefixPattern && this.negativePrefix.equals(this.symbols.getMinusSign() + this.positivePrefix))) break;
                stringBuffer.append(bl ? this.symbols.getPatternSeparator() : (char)';');
                continue;
            }
            this.appendAffix(stringBuffer, this.negSuffixPattern, this.negativeSuffix, bl);
        }
        return stringBuffer.toString();
    }

    public void applyPattern(String string) {
        this.applyPattern(string, false);
    }

    public void applyLocalizedPattern(String string) {
        this.applyPattern(string, true);
    }

    private void applyPattern(String string, boolean bl) {
        int n = 48;
        int n2 = 44;
        int n3 = 46;
        int n4 = 37;
        int n5 = 8240;
        int n6 = 35;
        int n7 = 59;
        int n8 = 69;
        int n9 = 45;
        if (bl) {
            n = this.symbols.getZeroDigit();
            n2 = this.symbols.getGroupingSeparator();
            n3 = this.symbols.getDecimalSeparator();
            n4 = this.symbols.getPercent();
            n5 = this.symbols.getPerMill();
            n6 = this.symbols.getDigit();
            n7 = this.symbols.getPatternSeparator();
            n8 = this.symbols.getExponentialSymbol();
            n9 = this.symbols.getMinusSign();
        }
        boolean bl2 = false;
        this.decimalSeparatorAlwaysShown = false;
        this.isCurrencyFormat = false;
        this.useExponentialNotation = false;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        for (int i = 1; i >= 0 && n12 < string.length(); --i) {
            int n13;
            int n14;
            boolean bl3 = false;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            int n15 = -1;
            int n16 = 1;
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            int n20 = -1;
            int n21 = 0;
            StringBuffer stringBuffer3 = stringBuffer;
            block5: for (n14 = n12; n14 < string.length(); ++n14) {
                n13 = string.charAt(n14);
                switch (n21) {
                    case 0: 
                    case 2: {
                        if (bl3) {
                            if (n13 == 39) {
                                if (n14 + 1 < string.length() && string.charAt(n14 + 1) == '\'') {
                                    ++n14;
                                    stringBuffer3.append("''");
                                    continue block5;
                                }
                                bl3 = false;
                                continue block5;
                            }
                        } else {
                            if (n13 == n6 || n13 == n || n13 == n2 || n13 == n3) {
                                n21 = 1;
                                if (i == 1) {
                                    n10 = n14;
                                }
                                --n14;
                                continue block5;
                            }
                            if (n13 == 164) {
                                boolean bl4;
                                boolean bl5 = bl4 = n14 + 1 < string.length() && string.charAt(n14 + 1) == '\u00a4';
                                if (bl4) {
                                    ++n14;
                                }
                                this.isCurrencyFormat = true;
                                stringBuffer3.append(bl4 ? "'\u00a4\u00a4" : "'\u00a4");
                                continue block5;
                            }
                            if (n13 == 39) {
                                if (n13 == 39) {
                                    if (n14 + 1 < string.length() && string.charAt(n14 + 1) == '\'') {
                                        ++n14;
                                        stringBuffer3.append("''");
                                        continue block5;
                                    }
                                    bl3 = true;
                                    continue block5;
                                }
                            } else {
                                if (n13 == n7) {
                                    if (n21 == 0 || i == 0) {
                                        throw new IllegalArgumentException("Unquoted special character '" + (char)n13 + "' in pattern \"" + string + '\"');
                                    }
                                    n12 = n14 + 1;
                                    n14 = string.length();
                                    continue block5;
                                }
                                if (n13 == n4) {
                                    if (n16 != 1) {
                                        throw new IllegalArgumentException("Too many percent/permille characters in pattern \"" + string + '\"');
                                    }
                                    n16 = 100;
                                    stringBuffer3.append("'%");
                                    continue block5;
                                }
                                if (n13 == n5) {
                                    if (n16 != 1) {
                                        throw new IllegalArgumentException("Too many percent/permille characters in pattern \"" + string + '\"');
                                    }
                                    n16 = 1000;
                                    stringBuffer3.append("'\u2030");
                                    continue block5;
                                }
                                if (n13 == n9) {
                                    stringBuffer3.append("'-");
                                    continue block5;
                                }
                            }
                        }
                        stringBuffer3.append((char)n13);
                        continue block5;
                    }
                    case 1: {
                        if (i == 1) {
                            ++n11;
                        } else {
                            if (--n11 != 0) continue block5;
                            n21 = 2;
                            stringBuffer3 = stringBuffer2;
                            continue block5;
                        }
                        if (n13 == n6) {
                            if (n18 > 0) {
                                ++n19;
                            } else {
                                ++n17;
                            }
                            if (n20 < 0 || n15 >= 0) continue block5;
                            n20 = (byte)(n20 + 1);
                            continue block5;
                        }
                        if (n13 == n) {
                            if (n19 > 0) {
                                throw new IllegalArgumentException("Unexpected '0' in pattern \"" + string + '\"');
                            }
                            ++n18;
                            if (n20 < 0 || n15 >= 0) continue block5;
                            n20 = (byte)(n20 + 1);
                            continue block5;
                        }
                        if (n13 == n2) {
                            n20 = 0;
                            continue block5;
                        }
                        if (n13 == n3) {
                            if (n15 >= 0) {
                                throw new IllegalArgumentException("Multiple decimal separators in pattern \"" + string + '\"');
                            }
                            n15 = n17 + n18 + n19;
                            continue block5;
                        }
                        if (n13 == n8) {
                            if (this.useExponentialNotation) {
                                throw new IllegalArgumentException("Multiple exponential symbols in pattern \"" + string + '\"');
                            }
                            this.useExponentialNotation = true;
                            this.minExponentDigits = 0;
                            while (++n14 < string.length() && string.charAt(n14) == n) {
                                this.minExponentDigits = (byte)(this.minExponentDigits + 1);
                                ++n11;
                            }
                            if (n17 + n18 < 1 || this.minExponentDigits < 1) {
                                throw new IllegalArgumentException("Malformed exponential pattern \"" + string + '\"');
                            }
                            n21 = 2;
                            stringBuffer3 = stringBuffer2;
                            --n14;
                            continue block5;
                        }
                        n21 = 2;
                        stringBuffer3 = stringBuffer2;
                        --n14;
                        --n11;
                        continue block5;
                    }
                }
            }
            if (n18 == 0 && n17 > 0 && n15 >= 0) {
                n14 = n15;
                if (n14 == 0) {
                    ++n14;
                }
                n19 = n17 - n14;
                n17 = n14 - 1;
                n18 = 1;
            }
            if (n15 < 0 && n19 > 0 || n15 >= 0 && (n15 < n17 || n15 > n17 + n18) || n20 == 0 || bl3) {
                throw new IllegalArgumentException("Malformed pattern \"" + string + '\"');
            }
            if (i == 1) {
                this.posPrefixPattern = stringBuffer.toString();
                this.posSuffixPattern = stringBuffer2.toString();
                this.negPrefixPattern = this.posPrefixPattern;
                this.negSuffixPattern = this.posSuffixPattern;
                n14 = n17 + n18 + n19;
                n13 = n15 >= 0 ? n15 : n14;
                this.setMinimumIntegerDigits(n13 - n17);
                this.setMaximumIntegerDigits(this.useExponentialNotation ? n17 + this.getMinimumIntegerDigits() : 309);
                this.setMaximumFractionDigits(n15 >= 0 ? n14 - n15 : 0);
                this.setMinimumFractionDigits(n15 >= 0 ? n17 + n18 - n15 : 0);
                this.setGroupingUsed(n20 > 0);
                this.groupingSize = (byte)(n20 > 0 ? n20 : 0);
                this.multiplier = n16;
                this.setDecimalSeparatorAlwaysShown(n15 == 0 || n15 == n14);
                continue;
            }
            this.negPrefixPattern = stringBuffer.toString();
            this.negSuffixPattern = stringBuffer2.toString();
            bl2 = true;
        }
        if (string.length() == 0) {
            this.posSuffixPattern = "";
            this.posPrefixPattern = "";
            this.setMinimumIntegerDigits(0);
            this.setMaximumIntegerDigits(309);
            this.setMinimumFractionDigits(0);
            this.setMaximumFractionDigits(340);
        }
        if (!bl2 || this.negPrefixPattern.equals(this.posPrefixPattern) && this.negSuffixPattern.equals(this.posSuffixPattern)) {
            this.negSuffixPattern = this.posSuffixPattern;
            this.negPrefixPattern = "'-" + this.posPrefixPattern;
        }
        this.expandAffixes();
    }

    public void setMaximumIntegerDigits(int n) {
        super.setMaximumIntegerDigits(Math.min(n, 309));
    }

    public void setMinimumIntegerDigits(int n) {
        super.setMinimumIntegerDigits(Math.min(n, 309));
    }

    public void setMaximumFractionDigits(int n) {
        super.setMaximumFractionDigits(Math.min(n, 340));
    }

    public void setMinimumFractionDigits(int n) {
        super.setMinimumFractionDigits(Math.min(n, 340));
    }

    public Currency getCurrency() {
        return this.symbols.getCurrency();
    }

    public void setCurrency(Currency currency) {
        if (currency != this.symbols.getCurrency()) {
            this.symbols.setCurrency(currency);
            if (this.isCurrencyFormat) {
                this.expandAffixes();
            }
        }
    }

    void adjustForCurrencyDefaultFractionDigits() {
        int n;
        Currency currency = this.symbols.getCurrency();
        if (currency == null) {
            try {
                currency = Currency.getInstance(this.symbols.getInternationalCurrencySymbol());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (currency != null && (n = currency.getDefaultFractionDigits()) != -1) {
            int n2 = this.getMinimumFractionDigits();
            if (n2 == this.getMaximumFractionDigits()) {
                this.setMinimumFractionDigits(n);
                this.setMaximumFractionDigits(n);
            } else {
                this.setMinimumFractionDigits(Math.min(n, n2));
                this.setMaximumFractionDigits(n);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.getMaximumIntegerDigits() > 309 || this.getMaximumFractionDigits() > 340) {
            throw new InvalidObjectException("Digit count out of range");
        }
        if (this.serialVersionOnStream < 1) {
            this.useExponentialNotation = false;
        }
        this.serialVersionOnStream = 2;
        this.digitList = new DigitList();
    }
}

